$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply measurement period"
	break
}

$measurePeriod = $args[0]
$Items = Get-MessageTrackingLog -Start (Get-Date).AddSeconds(-$measurePeriod) -End (Get-Date) -ResultSize Unlimited
if($Items)
{
	foreach($Item in $Items)
	{
		Write-Host "EventId:" $Item.EventId
		Write-Host "MessageId:" $Item.MessageId
		Write-Host "TotalBytes:" $Item.TotalBytes
		Write-Host "Sender:" $Item.Sender
		Write-Host "Recipients:" $Item.Recipients
	}
}

