﻿#
#
clear
#Set LOG Location
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$logDir=$egurkhaPath+'\agent\O365'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$logFile=$logDir+'\O365_prerequisites.log'
#Remove-Item -Path $logFile

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$osNam='N/A';$csdVersion='N/A';$sysType='N/A'
Try{
    $os=[String](Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).Name
    $osNam=$os.Substring(0,$os.IndexOf('|')).Trim() #(Microsoft Windows 7 Professional |C:\Windows|\Device\Harddisk0\Partition2)
    $csdVersion=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).CSDVersion #(Service Pack 1)
    $sysType=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).OSArchitecture #(64-bit)
    Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
}Catch{Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType}
$stTim=Get-Date
O365-WriteLog -writString "******************************************** O365_setup_prerequisites ********************************************" -LogPath $logFile -ReportingName 'Script'
O365-WriteLog -writString "O365_setup_prerequisites started at $stTim" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString $osNam ' -- ' $csdVersion '--' $sysType -LogPath $logFile -ReportingName 'SYSTEM INFO'

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExistURP=$false
$isO365MailSR='false'
foreach($line in $lines){  
    if($isExistURP){
        if($line.StartsWith('Monitor_O365_Mail_Sender_Receiver')){
           $isO365MailSR=$line.Replace('Monitor_O365_Mail_Sender_Receiver=','')
        }
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExistURP=$true
    }
}

$tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
$iniContent=get-content -Path $tstIniPath
$lineStr=''
$isReadStrt=$false
$isMASupport=$false
foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('Modern_Auth_Supported=')){
        if($line -match 'true'){
            $isMASupport=$true
            $isReadStrt=$false
        }
    }
    if($line.StartsWith('[Modern_Auth_Support')){
        $isReadStrt=$true
    }
}

if($isMASupport){
    $certBasedRes=[system.windows.forms.messagebox]::show(("Connect to O365 using `"Modern Authentication`"?" -join "`n"),"O365_Prerequisites",'YesNo')
}else{
    $certBasedRes='No'
}

foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('CertBased_Scripts') -and $certBasedRes -eq 'Yes'){
        $lineStr=$line
        break
    }
    if($isReadStrt -and $line.StartsWith('CredBased_Scripts') -and $certBasedRes -eq 'No'){
        $lineStr=$line
        break
    }
    
    if($line.StartsWith('[O365_Setup_Prerequisites')){
        $isReadStrt=$true
    }
}
if($certBasedRes -eq 'Yes'){
    O365-WriteLog -writString "connect to O365 using Modern Authentication" -LogPath $logFile -ReportingName 'INFO'
    $lineStr=$lineStr.Replace('CertBased_Scripts=','')
}else{
    O365-WriteLog -writString "connect to O365 using Basic Authentication" -LogPath $logFile -ReportingName 'INFO'
    $lineStr=$lineStr.Replace('CredBased_Scripts=','')
}

$scriptArr=$lineStr.Split('~')
$scriptDir=$egurkhaPath+'\lib\'


$chkins=[ordered]@{}
foreach($obj in $scriptArr){
    $arr=$obj.Split('@')
    if($chkins[$arr[0]]){
        $val=$chkins[$arr[0]]+'~'+$arr[1]
        $chkins.Remove($arr[0])
        $chkins.add($arr[0],$val)
    }else{
        $chkins.Add($arr[0],$arr[1])
    }
}

foreach($key in $chkins.Keys){
    if($chkins[$key] -eq 'O365LimitAccessToMailFlowUsers.ps1'){
        if($isO365MailSR -eq 'true'){
            $res=[system.windows.forms.messagebox]::show(($key -join "`n"),"O365_Prerequisites",'YesNo')
        }
    }else{
        $res=[system.windows.forms.messagebox]::show(($key -join "`n"),"O365_Prerequisites",'YesNo')
    }
    
    if($res -eq 'Yes'){ 
        $scptArr=([String]$chkins[$key]).Split('~')
        foreach($script in $scptArr){
            $scptSrt=$scriptDir+$script

            if($certBasedRes -eq 'Yes' -and $script -match 'O365_Step2_ModulesDwnldnInstall.ps1'){
                Try{
                    Write-Host "$script has started to run..." -ForegroundColor Green
                    O365-WriteLog -writString "script has started to run..." -LogPath $logFile -ReportingName $script
                    & $scptSrt 'Yes'
                    Write-Host "$script ran successfully" -ForegroundColor Green
                    O365-WriteLog -writString "$script ran successfully" -LogPath $logFile -ReportingName $script
                }Catch{
                    Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                    O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                }

            }elseif($script -match 'SBONtwrkAssmnt.ps1'){
                $nwAssesTool=Get-Childitem "C:\*\Microsoft Skype for Business Network Assessment Tool"
                if($nwAssesTool -ne $null -and $nwAssesTool -ne ''){
                    $stTim4=Get-Date
                    O365-WriteLog -writString "******************************************** SBONtwrkAssmnt ********************************************" -LogPath $logFile -ReportingName 'Script'
                    O365-WriteLog -writString "SBONtwrkAssmnt started at $stTim4" -LogPath $logFile -ReportingName 'INFO'

                    Try{
                        Write-Host "$script has started to run..." -ForegroundColor Green
                        & $scptSrt
                        Write-Host "$script ran successfully" -ForegroundColor Green
                    }
                    Catch{
                        Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                        O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                    }
                    $edTim4=Get-Date
                    O365-WriteLog -writString "SBONtwrkAssmnt ended at $edTim4" -LogPath $logFile -ReportingName 'INFO'
                    O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

                }
            }
			elseif($script -match 'MTMCallQualityPrerequisites.ps1'){
                $nwAssesTool=Get-Childitem "C:\*\Microsoft Teams Network Assessment Tool"
                if($nwAssesTool -ne $null -and $nwAssesTool -ne ''){
                    $stTim4=Get-Date
                    O365-WriteLog -writString "******************************************** MTMCallQualityPrerequisites ********************************************" -LogPath $logFile -ReportingName 'Script'
                    O365-WriteLog -writString "MTMCallQualityPrerequisites started at $stTim4" -LogPath $logFile -ReportingName 'INFO'

                    Try{
                        Write-Host "$script has started to run..." -ForegroundColor Green
                        & $scptSrt
                        Write-Host "$script ran successfully" -ForegroundColor Green
                    }
                    Catch{
                        Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                        O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                    }
                    $edTim4=Get-Date
                    O365-WriteLog -writString "MTMCallQualityPrerequisites ended at $edTim4" -LogPath $logFile -ReportingName 'INFO'
                    O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

                }
            }
            elseif($script -match 'O365LimitAccessToMailFlowUsers.ps1'){
                if($isO365MailSR -eq 'true'){
                    Try{
                        Write-Host "$script has started to run..." -ForegroundColor Green
                        O365-WriteLog -writString "script has started to run..." -LogPath $logFile -ReportingName $script
                        & "$scptSrt"
                        Write-Host "$script ran successfully" -ForegroundColor Green
                        O365-WriteLog -writString "$script ran successfully" -LogPath $logFile -ReportingName $script
                    }
                    Catch{
                        Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                        O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                    }
                }
            }
			else{
                Try{
                    Write-Host "$script has started to run..." -ForegroundColor Green
                    O365-WriteLog -writString "script has started to run..." -LogPath $logFile -ReportingName $script
                    & "$scptSrt"
                    Write-Host "$script ran successfully" -ForegroundColor Green
                    O365-WriteLog -writString "$script ran successfully" -LogPath $logFile -ReportingName $script
                }
                Catch{
                    Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                    O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                }
            }
        }
    }else{
        $msg=$key.Replace('?','')
        $str='you have cancelled the '+'"'+$msg+'"'+' script'
        Write-Host $str
        O365-WriteLog -writString $str -LogPath $logFile -ReportingName $script
    }
}
$edTim=Get-Date
O365-WriteLog -writString "O365_setup_prerequisites ended at $edTim" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

