$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$strComputer = "."
$disks = Get-WmiObject Win32_MappedLogicalDisk -ComputerName $strComputer
foreach($disk in $disks)
{
	$totalSize=-1
	$freeSpace=-1
	$usedSpace=-1
	$spaceUtil=-1

	$totalSize = $disk.Size / ( 1024 * 1024)
	$freeSpace = $disk.FreeSpace / ( 1024 * 1024)

	if($totalSize -gt $freeSpace)
	{
		$usedSpace = $totalSize - $freeSpace
	}
	else
	{
		$usedSpace = 0
	}

	if($usedSpace -eq 0)
	{
		$spaceUtil = 0
	}
	else
	{
		$spaceUtil = ($usedSpace / $totalSize) * 100
	}

	Write-Host $disk.Name ,$totalSize,$freeSpace,$usedSpace,$spaceUtil -separator "#"
}