$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$stats = 'Inbox','Outbox','DeletedItems','SentItems','Calendar'
$Global:ErrorActionPreference="SilentlyContinue"
$mbxs = Get-Mailbox -Server $env:computername -ResultSize unlimited
foreach ($mbx in $mbxs)
{
	foreach($stat in $stats)
	{
		$folders = Get-MailboxFolderStatistics -Identity $mbx.Name -FolderScope $stat
		foreach ($folder in $folders)
		{
			Write-Host ($mbx.Database,$mbx.Name,$folder.Name,$folder.ItemsInFolder,$folder.FolderSize.ToKB(),$folder.ItemsInFolderAndSubfolders,$folder.FolderAndSubfolderSize.ToKB() ) -Separator  ";"
	 	}
	}
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
