$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}
Write-Host "EMail Address Policy settings"
Write-Host "------------------------------"

$emailPolicies = Get-EMailAddressPolicy 

foreach($p in $emailPolicies)
{
	Write-Host "Name: " $p.Name
	Write-Host "HasEmailAddressSetting: " $p.HasEmailAddressSetting
	Write-Host "Enabled: " $p.Enabled
	Write-Host "Priority: " $p.Priority
	Write-Host "HasMailboxManagerSetting: " $p.HasMailboxManagerSetting
	Write-Host "EnabledPrimarySMTPAddressTemplate: " $p.EnabledPrimarySMTPAddressTemplate
	Write-Host "DisabledEmailAddressTemplates: " $p.DisabledEmailAddressTemplates
	Write-Host "NonAuthoritativeDomains: " $p.NonAuthoritativeDomains
	Write-Host "RecipientFilterType: " $p.RecipientFilterType
	Write-Host "RecipientFilter: " $p.RecipientFilter
	Write-Host "IncludedRecipients: " $p.IncludedRecipients
	Write-Host "RecipientFilterApplied: " $p.RecipientFilterApplied
}

Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010