$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Admin Server"
	break
}

$adminServer = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$adminConn = New-XdAdminConnection -Name $adminServer
$xenFarm = Get-XdFarm -AdminConnection $adminConn
Write-Host "Desktop Groups"
Write-Host "---------------"
$dgroups = Get-XdDesktopGroup 
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		Write-Host($i.Name,$i.Enabled) -Separator ";" 
	}
}
Write-Host "Virtual Desktops"
Write-Host "---------------"
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		$vds = Get-XdVirtualDesktop -Group $i
		if($vds -ne $null)
		{
			foreach ($vd in $vds)
			{	
				$vdPowerState = "-";
				if ($vd.PowerState.length -gt 0)
				{
					$vdPowerState = $vd.PowerState;
				}
				Write-Host($vd.GroupId,$vd.Name,$vd.GroupName,$vd.State,$i.AssignmentBehavior,$vdPowerState,$vd.AssignedUserName) -Separator ";"	
			}
		}
	}
}

Write-Host "Sessions"
Write-Host "--------"
$sessions = Get-XdSession
if($sessions -ne $null)
{
	foreach($session in $sessions)
	{
		$UserName = "Unknown";
		if ($session.UserName.length -gt 0)
		{
			$UserName = $session.UserName;
		}
		Write-Host($session.GroupId,$session.DesktopName,$UserName,$session.State) -Separator ";"
	}
}

Disconnect-XdAdminConnection -AdminConnection $adminConn






