﻿$Global:ErrorActionPreference = "SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

function getStringAsArray($StrArray)
{
    $FinalStr = "-"
    if ($StrArray -ne $null -and $StrArray.count -gt 0)
    {
        $count = 0
        $FinalStr = ""
        foreach ($Str in $StrArray)
        {
            if ($count -eq 0)
            {
                $FinalStr = $Str
            }
            else
            {
                $FinalStr = $FinalStr + "," + $Str
            }
            $count = $count + 1
        }
    }
    return $FinalStr
}

Write-Host "DedupStatus"
Write-Host "-----------"
$DedupStatus = Get-DedupStatus
if ($DedupStatus -ne $null)
{
    foreach ($Status in $DedupStatus)
    {
        $Volume = $Status.Volume
        $VolumeId = $Status.VolumeId
        $Capacity = $Status.Capacity
        $FreeSpece = $Status.FreeSpace
        $UsedSpace = $Status.UsedSpace
        $UnoptimizedSize = $Status.UnoptimizedSize
        $SavedSpace = $Status.SavedSpace
        $SavingsRate = $Status.SavingsRate
        $OptimizedFilesCount = $Status.OptimizedFilesCount
        $OptimizedFilesSize = $Status.OptimizedFilesSize
        $OptimizedFilesSavingsRate = $Status.OptimizedFilesSavingsRate
        $InPolicyFilesCount = $Status.InPolicyFilesCount
        $InPolicyFilesSize = $Status.InPolicyFilesSize
        $LastOptimizationTime = $Status.LastOptimizationTime
        $LastOptimizationResult = $Status.LastOptimizationResult
        $LastOptimizationResultMessage = $Status.LastOptimizationResultMessage
        $LastGarbageCollectionTime = $Status.LastGarbageCollectionTime
        $LastGarbageCollectionResult = $Status.LastGarbageCollectionResult
        $LastGarbageCollectionResultMessage = $Status.LastGarbageCollectionResultMessage
        $LastScrubbingTime = $Status.LastScrubbingTime
        $LastScrubbingResult = $Status.LastScrubbingResult
        $LastScrubbingResultMessage = $Status.LastScrubbingResultMessage
 
        if ($Volume -eq $null)
        {
            continue
        }

        Write-Host ($Volume,$VolumeId,$Capacity,$FreeSpece,$UsedSpace,$UnoptimizedSize,$SavedSpace,$SavingsRate,$OptimizedFilesCount,
                    $OptimizedFilesSize,$OptimizedFilesSavingsRate,$InPolicyFilesCount,$InPolicyFilesSize,$LastOptimizationTime,$LastOptimizationResult,
                    $LastGarbageCollectionTime,$LastGarbageCollectionResult,
                    $LastScrubbingTime,$LastScrubbingResult) -Separator "#~#"
     }
}

Write-Host "DedupVolume"
Write-Host "-----------"
$DedupVolumes = Get-DedupVolume
if ($DedupVolumes -ne $null)
{
    foreach ($DedupVolume in $DedupVolumes)
    {
        $Volume = $DedupVolume.Volume
        $VolumeId = $DedupVolume.VolumeId
        $Enabled = $DedupVolume.Enabled
        $UsageType = $DedupVolume.UsageType
        $MinimumFileAgeDays = $DedupVolume.MinimumFileAgeDays
        $MinimumFileSize = $DedupVolume.MinimumFileSize
        $NoCompress = $DedupVolume.NoCompress
        $ExcludeFolder = $DedupVolume.ExcludeFolder
        $ExcludeFileType = $DedupVolume.ExcludeFileType
        $ExcludeFileTypeDefault = $DedupVolume.ExcludeFileTypeDefault
        $NoCompressionFileType = $DedupVolume.NoCompressionFileType
        $ChunkRedundancyThreshold = $DedupVolume.ChunkRedundancyThreshold
        $Verify = $DedupVolume.Verify
        $OptimizeInUseFiles = $DedupVolume.OptimizeInUseFiles
        $OptimizePartialFiles = $DedupVolume.OptimizePartialFiles

        if ($Volume -eq $null)
        {
            continue
        }
        
        $ExcludeFolders = getStringAsArray $ExcludeFolder
        $ExcludeFileTypes = getStringAsArray $ExcludeFileType
        $ExcludeFileTypeDefaults = getStringAsArray $ExcludeFileTypeDefault
        $NoCompressionFileTypes = getStringAsArray $NoCompressionFileType

        Write-Host ($Volume,$VolumeId,$Enabled,$UsageType,$MinimumFileAgeDays,$MinimumFileSize,$NoCompress,
                    $ExcludeFolders,$ExcludeFileTypes,$ExcludeFileTypeDefaults,$NoCompressionFileTypes,
                    $ChunkRedundancyThreshold,$Verify,$OptimizeInUseFiles,$OptimizePartialFiles) -Separator "#~#"

    }
}

Write-Host "DedupMetadata"
Write-Host "-------------"
$DedupMetadatas = Get-DedupMetadata
if ($DedupMetadatas -ne $null)
{
    foreach ($Metadata in $DedupMetadatas)
    {
        $Volume = $Metadata.Volume
        $VolumeId = $Metadata.VolumeId
        $StoreId = $Metadata.StoreId
        $DataChunkCount = $Metadata.DataChunkCount
        $DataContainerCount = $Metadata.DataContainerCount
        $DataChunkAverageSize = $Metadata.DataChunkAverageSize
        $DataChunkMedianSize = $Metadata.DataChunkMedianSize
        $DataStoreUncompactedFreespace = $Metadata.DataStoreUncompactedFreespace
        $StreamMapChunkCount = $Metadata.StreamMapChunkCount
        $StreamMapContainerCount = $Metadata.StreamMapContainerCount
        $StreamMapAverageDataChunkCount = $Metadata.StreamMapAverageDataChunkCount
        $StreamMapMedianDataChunkCount = $Metadata.StreamMapMedianDataChunkCount
        $StreamMapMaxDataChunkCount = $Metadata.StreamMapMaxDataChunkCount
        $HotspotChunkCount = $Metadata.HotspotChunkCount
        $HotspotContainerCount = $Metadata.HotspotContainerCount
        $HotspotMedianReferenceCount = $Metadata.HotspotMedianReferenceCount
        $CorruptionLogEntryCount = $Metadata.CorruptionLogEntryCount
        $TotalChunkStoreSize = $Metadata.TotalChunkStoreSize
        
        if ($Volume -eq $null)
        {
            continue
        }
       
        Write-Host ($Volume,$VolumeId,$StoreId,$DataChunkCount,$DataContainerCount,$DataChunkAverageSize,$DataChunkMedianSize,$DataStoreUncompactedFreespace,
                    $StreamMapChunkCount,$StreamMapContainerCount,$StreamMapContainerCount,$StreamMapAverageDataChunkCount,$StreamMapMaxDataChunkCount,
                    $HotspotChunkCount,$HotspotContainerCount,$HotspotMedianReferenceCount,$CorruptionLogEntryCount,$TotalChunkStoreSize) -Separator "#~#"       
    }
}

Write-Host "DedupJob"
Write-Host "--------"
#Type - Optimization,GarbageCollection,Scrubbing,Unoptimization
#InputOutputThrottleLevel - None,Low,Medium,High,Maximum
#Priority - Low,Normal,High
#ScheduleType - Scheduled,Manual
#State - Queued,Initializing,Running,Completed,PendingCancel,Canceled,Failed
#Start-DedupJob -Type Optimization -Volume <VolumeName> -Memory 100 -Priority High
$DedupJobs = Get-DedupJob
if ($DedupJobs -ne $null)
{
    foreach ($Job in $DedupJobs)
    {
        $Volume = $Job.Volume
        $VolumeId = $Job.VolumeId
        $Type = $Job.Type
        $ScheduleType = $Job.ScheduleType
        $StartTime = $Job.StartTime
        $Progress = $Job.Progress
        $State = $Job.State
        $Id = $Job.Id
        $StopWhenSystemBusy = $Job.StopWhenSystemBusy
        $Memory = $Job.Memory
        $Priority = $Job.Priority
        $InputOutputThrottleLevel = $Job.InputOutputThrottleLevel
        $ProcessId = $Job.ProcessId
        $Full = $Job.Full
        $ReadOnly = $Job.ReadOnly

        if ($Volume -eq $null)
        {
            continue
        }

        Write-Host ($Volume,$VolumeId,$Type,$ScheduleType,$StartTime,$Progress,$State,$Id,$StopWhenSystemBusy,$Memory,
                    $Priority,$InputOutputThrottleLevel,$ProcessId,$Full,$ReadOnly) -Separator "#~#"

    }
}





