Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$farm = Get-XAFarm

$zones = Get-XAZone

foreach($zone in $zones)
{
	Write-Host $farm.FarmName,$zone.ZoneName -Separator "#"
}

Write-Host "--ZoneNames End--"

foreach ($zone in $zones)
{
	$allservers = Get-XAServer -ZoneName $zone.ZoneName
	foreach ($server in $allservers)
	{
		Write-Host $farm.FarmName,$zone.ZoneName,$server.ServerName , $server.IPAddresses -Separator "#"
	}
}

Write-Host "--ZoneServers End--"

foreach ($zone in $zones)
{
	$onlineservers = Get-XAServer -ZoneName $zone.ZoneName -OnlineOnly 
	foreach ($onlineserver in $onlineservers) 
	{
		Write-Host $farm.FarmName,$zone.ZoneName, $onlineserver.ServerName, $onlineserver.IPAddresses -Separator "#"
	}
}
Remove-PSSnapin Citrix.XenApp.Commands



