﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Write-Host "Application LoadEvaluators"
Write-Host "=========================="
$Applications = Get-XAApplication -EA 0 | sort-object BrowserName, DisplayName
if($? -and $Applications)
{
	foreach($Application in $Applications)
	{
		$BrowserName = $Application.BrowserName
		$FolderPath = $Application.FolderPath
		$LoadEvaluatorName = "-"
		if ($BrowserName -ne $null -and $BrowserName.length -gt 0)
		{
			$LoadEvaluator = Get-XALoadEvaluator -BrowserName $BrowserName
			if ($LoadEvaluator -ne $null)
			{
				$LoadEvaluatorName = $LoadEvaluator.LoadEvaluatorName
			}
		}
		Write-Host ($BrowserName,$FolderPath,$LoadEvaluatorName) -Separator "#~#"
	}
}

Write-Host "Server LoadEvaluators"
Write-Host "====================="
$Servers = Get-XAServer
if($? -and $Servers)
{
	foreach($Server in $Servers)
	{
		$ServerName = $Server.ServerName
		$FolderPath = $Server.FolderPath
		$LoadEvaluatorName = "-"
		$LoadEvaluator = Get-XALoadEvaluator -Server $ServerName
		if ($LoadEvaluator -ne $null)
		{
			$LoadEvaluatorName = $LoadEvaluator.LoadEvaluatorName
		}
		Write-Host ($ServerName,$FolderPath,$LoadEvaluatorName) -Separator "#~#"
	}
}
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands

