﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$hostname = $env:COMPUTERNAME
$WorkerGroups = Get-XAWorkerGroup -EA 0 | sort-object WorkerGroupName
foreach($workGroup in $WorkerGroups)
{
	Write-Host "###Worker Groups - starts ###"
	Write-Host "Name: " $workGroup.WorkerGroupName
	Write-Host "Description: " $workGroup.Description
	Write-Host "Folder Path: " $workGroup.FolderPath
	If($workGroup.ServerNames)
	{
		Write-Host "Farm Servers : " $workGroup.ServerNames
	}
	else
	{
		Write-Host "Farm Servers : -"
	}
	If($workGroup.ServerGroups)
	{
		Write-Host "Active Directory Server Groups : " $workGroup.ServerGroups
	}
	else
	{
		Write-Host "Active Directory Server Groups : -"
	}
	
	If($workGroup.OUs)
	{
		Write-Host "Active Directory Containers : " $workGroup.OUs
	}
	else
	{
		Write-Host "Active Directory Containers : -"
	}
	Write-Host "###Worker Groups - ends ###"
}
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands

