﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       display the activity operations that done by user
    Created           :       31/01/2018
    Modified By       : 

#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

clear

$TestInputs=$args
#<#
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$testFreRpt=$TestInputs[2]
$inputUsrKey=$TestInputs[3]   
$arrStrng=$TestInputs[4]
$proxyUsr=$TestInputs[5]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[6]
$appDetails=$TestInputs[7]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$inputUsrKey=$inputUsrKey.ToString().Replace('^',' ')

#<#
$spoOpertns=$arrStrng.ToString().Trim().Split('#')
$fileOpe=$spoOpertns[0].ToString().Trim().Split('~')
$folderOpe=$spoOpertns[1].ToString().Trim().Split('~')
$syncOpe=$spoOpertns[2].ToString().Trim().Split('~')
$sharngOpe=$spoOpertns[3].ToString().Trim().Split('~')
$siteAdminOpe=$spoOpertns[4].ToString().Trim().Split('~')
#>

$allOperatns=$fileOpe+$folderOpe+$syncOpe+$sharngOpe+$siteAdminOpe

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$tstArr=$testFreRpt.Split('#')
$testFrequency=[int]$tstArr[0]
$reportingNam=$tstArr[1]
$showUsrFileOpe=$tstArr[2]
$proxyserverip=$tstArr[3]
$rptPath='SPO/'+$reportingNam
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

$logPath=$egurkhaPath+'\agent\'+$rptPath+'\SPOActOperations.log'
$isWriteLog=$false

Function Start-SleepWithProgress {
	Param([int]$sleeptime)

	For ($i=0;$i -le $sleeptime;$i++){
		$timeleft = ($sleeptime - $i);
		Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		start-sleep 1
	}
	
	Write-Progress -Completed -Activity "Sleeping"
}

Function New-CleanSPOSession {
    $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $i = 0
	while (($Credential -eq $Null) -and ($i -lt 5)){
		$script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		$i++
	}

	if ($Credential -eq $null){
		Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	}

	$getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
	    Disconnect-ExchangeOnline -Confirm:$false
    }
	[System.GC]::Collect()
	Start-SleepWithProgress -SleepTime 15
	$Error.Clear()
	
    $sessionOption = New-PSSessionOption -SkipRevocationCheck
    if(!$proxyserverip.ToString().ToLower().Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
	    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication Basic -ProxyCredential $proxyCred
	    }
    }
		
	if ($Error.Count -gt 0){
		$ErrorCount++
		if ($ErrorCount -gt 3){
			exit
		}
		Start-SleepWithProgress -sleeptime 60
		New-CleanSPOSession
	}
	else {
		$ErrorCount = 0
	}
	# Connect the ExchangeOnline
    if($appDetails -and $appDetails -ne 'none'){
            Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
    }else{
        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption -WarningAction SilentlyContinue
	}
    Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
}

$fileAct=@{}
foreach($act in $fileOpe){  
    $fileAct.Add($act,0)
}

$folderAct=@{}
foreach($act in $folderOpe){ 
    $folderAct.Add($act,0)
}

$syncAct=@{}
foreach($act in $syncOpe){  
    $syncAct.Add($act,0)
}

$sharngAct=@{}
foreach($act in $sharngOpe){  
    $sharngAct.Add($act,0)
}

$siteAdminAct=@{}
foreach($act in $siteAdminOpe){  
    $siteAdminAct.Add($act,0)
}

# hash for summary counts
$uniqOpe=@{}
$uniqusers= @{}
$uniqClientIp=@{}
$uniqsites=@{}
$uniqItem=@{}
$uniqDestnatn=@{}
$uniqUsrAgent=@{}

$uniqFdrOpe=@{}
$uniqFdrusers= @{}
$uniqFdrClientIp=@{}
$uniqFdrsites=@{}
$uniqFdrItem=@{}
$uniqFdrDestnatn=@{}
$uniqFdUsrAgent=@{}

$uniqSyncOpe=@{}
$uniqSyncUsers= @{}
$uniqSyncClientIp=@{}
$uniqSyncSites=@{}
$uniqSyncItem=@{}
$uniqSyncDestnatn=@{}
$uniqSyncUsrAgent=@{}

$uniqShrOpe=@{}
$uniqShrUsers= @{}
$uniqShrClientIp=@{}
$uniqShrSites=@{}
$uniqShrItem=@{}
$uniqShrDestnatn=@{}
$uniqShrUsrAgent=@{}

$uniqAdmnOpe=@{}
$uniqAdmnUsers= @{}
$uniqAdmnClientIp=@{}
$uniqAdmnSites=@{}
$uniqAdmnItem=@{}
$uniqAdmnDestnatn=@{}
$uniqAdmnUsrAgent=@{}

$usrFileOpe=@("FileAccessed","FileCheckedIn","FileCheckedOut","FileDeleted","FileUploaded","FileModified","PageViewed")

$usrKeyArr=$inputUsrKey.Split(',')
$filePath=''
$kfilePath=''
$actPath=''

$sysDat=(Get-Date).ToUniversalTime()
$endDat=$sysDat.AddMinutes(-60)
$startDat=$endDat.AddMinutes(-($testFrequency))
Try{
    Import-Module MsOnline
    Set-StrictMode -Version 2
    $ErrorCount = 0

    New-CleanSPOSession
    Eg-WriteLog -writString ('Entering create session...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    Try{
        $actWritArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "spoActOprBase" -keyFileName "kspoActOprBase" -EgPath $egurkhaPath
        #Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat | select AuditData,Operations |Export-Csv $actWritArr[1]
        Eg-WriteLog -writString ('actWritArr -->>'+$actWritArr.Keys +' -- '+$actWritArr.Values) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        $curResCnt=0
        while($true){
            $results=Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat -Operations $allOperatns -SessionId sa -SessionCommand ReturnLargeSet -ResultSize 5000
            $results | Export-Csv $actWritArr[1] -Encoding $encTyp -Append -Force
            $curResCnt=$curResCnt+($results.count)
            if(($curResCnt -eq 50000) -or ($results.count -lt 5000)){
                break
            }
        }
        Eg-WriteLog -writString ('curResCnt -->>'+$curResCnt) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        $null=Protect-File  $actWritArr[1] -Algorithm AES -KeyAsPlainText $actWritArr[0] -RemoveSource
    }Catch{
        if([System.IO.File]::Exists($actWritArr[1]) -eq 'True'){
            Remove-Item $actWritArr[1]
        }
        $spoExcepMsg1='[SPOActOperations] Exception Occured in "Search-UnifiedAuditLog" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
        Eg-WriteLog -writString ('spoExcepMsg1 -->>'+$spoExcepMsg1) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        Write-Host $spoExcepMsg1
    }
    Try{
        $actReadArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "spoActOprBase" -keyFileName "kspoActOprBase" -EgPath $egurkhaPath
        if($actReadArr -ne $null -and [System.IO.File]::Exists($actReadArr[1]) -eq 'True'){
            Eg-WriteLog -writString ('actReadArr -->>'+$actReadArr.Keys +' -- '+$actReadArr.Values) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $unProtctAct=$actReadArr[1] -replace (".csv",".dat")
            Eg-WriteLog -writString ('unProtctAct -->>'+$unProtctAct) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $actPath=Unprotect-File $unProtctAct -Algorithm AES -KeyAsPlainText $actReadArr[0]
            Eg-WriteLog -writString ('actPath -->>'+$actPath) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $serchAuditLog= import-csv $actPath -Encoding $encTyp
            Eg-WriteLog -writString ('serchAuditLog.Count -->>'+$serchAuditLog.Count) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            Remove-Item $actPath
            Eg-WriteLog -writString ('After Remove-Item actPath') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $filePath=$actReadArr[2]+''+$actReadArr[3]
            $kfilePath=$actReadArr[2]+''+$actReadArr[4]
            Eg-WriteLog -writString ('filePath -->> '+$filePath+' -- '+$kfilePath) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            if(Test-Path -Path $filePath -PathType Leaf){
                Remove-Item $filePath -Force
            }
            if(Test-Path -Path $kfilePath -PathType Leaf){
                Remove-Item $kfilePath -Force
            }
        }
    }Catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
    Eg-WriteLog -writString ('After Remove-Item filePath') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
        Eg-WriteLog -writString ('Disconnect-ExchangeOnline') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
	    Disconnect-ExchangeOnline -Confirm:$false
    }
}
Catch{
    if([System.IO.File]::Exists($actPath) -eq 'True'){
        Remove-Item $actPath
    }
    if([System.IO.File]::Exists($filePath) -eq 'True'){
        Remove-Item $filePath -Force
    }
    if([System.IO.File]::Exists($kfilePath) -eq 'True'){
        Remove-Item $kfilePath -Force
    }
    $spoExcepMsg2='[SPOActOperations] Exception Occured while reading the Files -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
    Eg-WriteLog -writString ('spoExcepMsg2 -->> '+$spoExcepMsg2) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    Write-Host $spoExcepMsg2
}

[System.GC]::GetTotalMemory($true) | out-null

Try{

    foreach($log in $serchAuditLog){

         #'if' condition for if userkey is in {NT AUTHORITY\SYSTEM,SHAREPOINT\system} or not
        if($inputUsrKey -ne "" -and $inputUsrKey -ne $null -and $inputUsrKey -ne "No" -and $inputUsrKey -ne "false"){
            $res= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $fileOpe -and $_.UserKey -notin $usrKeyArr}
            $resFldr= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $folderOpe -and $_.UserKey -notin $usrKeyArr}
            $resSync= $log.AuditData | ConvertFrom-Json | Where-Object {($_.Workload -eq "SharePoint" -or $_.Workload -eq "OneDrive") -and $_.Operation -in $syncOpe -and $_.UserKey -notin $usrKeyArr}
            $resShrg= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $sharngOpe -and $_.UserKey -notin $usrKeyArr}
            $resSAdm= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $siteAdminOpe -and $_.UserKey -notin $usrKeyArr}
        }else{
            $res= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $fileOpe}
            $resFldr= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $folderOpe }
            $resSync= $log.AuditData | ConvertFrom-Json | Where-Object {($_.Workload -eq "SharePoint" -or $_.Workload -eq "OneDrive") -and $_.Operation -in $syncOpe }
            $resShrg= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $sharngOpe }
            $resSAdm= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $siteAdminOpe }
        }


        # ******* FILE OPERATIONS ********* 

        if($res -ne "" -and $res -ne $null){ 
	        if($showUsrFileOpe -eq 'no'){
                if(($res.UserId -eq $userName) -and ($res.Operation -in $usrFileOpe )){
                    continue;
                }
            }
        
            $isUserAgent=[bool]($res.PSobject.Properties.name -match "UserAgent")
            $isSiteUrl=[bool]($res.PSobject.Properties.name -match "SiteUrl")
            if(!$isSiteUrl -or ($isUserAgent -eq $false) -or (($res.UserId).IndexOf('#') -ne -1)){
                continue
            }   

            if($uniqOpe.ContainsKey($res.Operation)){
                $uniqOpe[$res.Operation]=[int]$uniqOpe[$res.Operation]+1
            }else{
                $uniqOpe.Add($res.Operation,1) 
            }

            $uniqUsrLine=$res.UserId+'#'+$res.ClientIP
            if($uniqusers.ContainsKey($uniqUsrLine)){          
                $output=[String]$uniqusers[$uniqUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($res.Operation)){
                    $uniqusers[$uniqUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqusers[$uniqUsrLine]= $arr[0]+','+$res.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqusers.Add($uniqUsrLine,$res.Operation+'#'+1) 
            }

            if($uniqClientIp.ContainsKey($res.ClientIP)){
                $ipOutput=[String]$uniqClientIp[$res.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($res.Operation)){
                    $uniqClientIp[$res.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqClientIp[$res.ClientIP]= $ipArr[0]+','+$res.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqClientIp.Add($res.ClientIP,$res.Operation+'#'+1)
            }        

            if($isSiteUrl){
                $uniqsiteLine=$res.SiteUrl+'#'+$res.Site
            }#else{
            #    $uniqsiteLine='-#'+$res.Site
            #}
            if($uniqsites.ContainsKey($uniqsiteLine)){
                $siteOutput=[String]$uniqsites[$uniqsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($res.Operation)){
                    $uniqsites[$uniqsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqsites[$uniqsiteLine]= $siteArr[0]+','+$res.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqsites.Add($uniqsiteLine,$res.Operation+'#'+1)
            }

            if($uniqItem.ContainsKey($res.ItemType)){
                $itemOutput=[String]$uniqItem[$res.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($res.Operation)){
                    $uniqItem[$res.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqItem[$res.ItemType]= $itemArr[0]+','+$res.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqItem.Add($res.ItemType,$res.Operation+'#'+1)
            }

            if($isSiteUrl){
                if($uniqDestnatn.ContainsKey($res.SiteUrl)){
                    $destOutput=[String]$uniqDestnatn[$res.SiteUrl]
                    $destArr=$destOutput.Split('#')
                    if($destOutput.Contains($res.Operation)){
                        $uniqDestnatn[$res.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                    }else{
                        $uniqDestnatn[$res.SiteUrl]= $destArr[0]+','+$res.Operation+'#'+[String]([int]$destArr[1]+1)
                    }
                }else{
                    $uniqDestnatn.Add($res.SiteUrl,$res.Operation+'#'+1)
                }
            }

            if($isUserAgent){
                if($uniqUsrAgent.ContainsKey($res.UserAgent)){
                    $uniqUsrAgent[$res.UserAgent]=[int]$uniqUsrAgent[$res.UserAgent]+1
                }else{
                    $uniqUsrAgent.Add($res.UserAgent,1)
                }
            }

            if($fileAct.ContainsKey($res.Operation)){      
                $fileAct[$res.Operation]=[int]$fileAct[$res.Operation]+1
            }
        }

        #    ********** FOLDER OPERATIONS *******

        if($resFldr -ne "" -and $resFldr -ne $null){
            
            $isSiteUrlFldr=[bool]($resFldr.PSobject.Properties.name -match "SiteUrl")
            $isUsrAgntFldr=[bool]($resFldr.PSobject.Properties.name -match "UserAgent")
            if(!$isSiteUrlFldr -or ($isUsrAgntFldr -eq $false) -or (($resFldr.UserId).IndexOf('#') -ne -1)){
                continue
            }   
            if($uniqFdrOpe.ContainsKey($resFldr.Operation)){
                $uniqFdrOpe[$resFldr.Operation]=[int]$uniqFdrOpe[$resFldr.Operation]+1
            }else{
                $uniqFdrOpe.Add($resFldr.Operation,1) 
            }

            $fldrUsrLine=$resFldr.UserId+'#'+$resFldr.ClientIP
            if($uniqFdrusers.ContainsKey($fldrUsrLine)){          
                $output=[String]$uniqFdrusers[$fldrUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resFldr.Operation)){
                    $uniqFdrusers[$fldrUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqFdrusers[$fldrUsrLine]= $arr[0]+','+$resFldr.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqFdrusers.Add($fldrUsrLine,$resFldr.Operation+'#'+1) 
            }

            if($uniqFdrClientIp.ContainsKey($resFldr.ClientIP)){
                $ipOutput=[String]$uniqFdrClientIp[$resFldr.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resFldr.Operation)){
                    $uniqFdrClientIp[$resFldr.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqFdrClientIp[$resFldr.ClientIP]= $ipArr[0]+','+$resFldr.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqFdrClientIp.Add($resFldr.ClientIP,$resFldr.Operation+'#'+1)
            }

            $fldrsiteLine=$resFldr.SiteUrl+'#'+$resFldr.Site
            if($uniqFdrsites.ContainsKey($fldrsiteLine)){
                $siteOutput=[String]$uniqFdrsites[$fldrsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resFldr.Operation)){
                    $uniqFdrsites[$fldrsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqFdrsites[$fldrsiteLine]= $siteArr[0]+','+$resFldr.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqFdrsites.Add($fldrsiteLine,$resFldr.Operation+'#'+1)
            }

            if($uniqFdrItem.ContainsKey($resFldr.ItemType)){
                $itemOutput=[String]$uniqFdrItem[$resFldr.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resFldr.Operation)){
                    $uniqFdrItem[$resFldr.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqFdrItem[$resFldr.ItemType]= $itemArr[0]+','+$resFldr.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqFdrItem.Add($resFldr.ItemType,$resFldr.Operation+'#'+1)
            }

            if($uniqFdrDestnatn.ContainsKey($resFldr.SiteUrl)){
                $destOutput=[String]$uniqFdrDestnatn[$resFldr.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resFldr.Operation)){
                    $uniqFdrDestnatn[$resFldr.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqFdrDestnatn[$resFldr.SiteUrl]= $destArr[0]+','+$resFldr.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqFdrDestnatn.Add($resFldr.SiteUrl,$resFldr.Operation+'#'+1)
            }

            if($uniqFdUsrAgent.ContainsKey($resFldr.UserAgent)){
                $uniqFdUsrAgent[$resFldr.UserAgent]=[int]$uniqFdUsrAgent[$resFldr.UserAgent]+1
            }else{
                $uniqFdUsrAgent.Add($resFldr.UserAgent,1)
            }
     
            if($folderAct.ContainsKey($resFldr.Operation)){      
                $folderAct[$resFldr.Operation]=[int]$folderAct[$resFldr.Operation]+1
            }       
        }

        #    ********** SYNC OPERATIONS ********

        if($resSync -ne "" -and $resSync -ne $null){
            $isSiteUrlSync=[bool]($resSync.PSobject.Properties.name -match "SiteUrl")
            $isUsrAgntSync=[bool]($resSync.PSobject.Properties.name -match "UserAgent")
            if(!$isSiteUrlSync -or ($isUsrAgntSync -eq $false) -or (($resSync.UserId).IndexOf('#') -ne -1)){
                continue
            }
            if($uniqSyncOpe.ContainsKey($resSync.Operation)){
                $uniqSyncOpe[$resSync.Operation]=[int]$uniqSyncOpe[$resSync.Operation]+1
            }else{
                $uniqSyncOpe.Add($resSync.Operation,1) 
            }

            $syncUsrLine=$resSync.UserId+'#'+$resSync.ClientIP
            if($uniqSyncUsers.ContainsKey($syncUsrLine)){          
                $output=[String]$uniqSyncUsers[$syncUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resSync.Operation)){
                    $uniqSyncUsers[$syncUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqSyncUsers[$syncUsrLine]= $arr[0]+','+$resSync.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqSyncUsers.Add($syncUsrLine,$resSync.Operation+'#'+1) 
            }

            if($uniqSyncClientIp.ContainsKey($resSync.ClientIP)){
                $ipOutput=[String]$uniqSyncClientIp[$resSync.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resSync.Operation)){
                    $uniqSyncClientIp[$resSync.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqSyncClientIp[$resSync.ClientIP]= $ipArr[0]+','+$resSync.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqSyncClientIp.Add($resSync.ClientIP,$resSync.Operation+'#'+1)
            }

            $syncsiteLine=$resSync.SiteUrl+'#'+$resSync.Site
            if($uniqSyncSites.ContainsKey($syncsiteLine)){
                $siteOutput=[String]$uniqSyncSites[$syncsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resSync.Operation)){
                    $uniqSyncSites[$syncsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqSyncSites[$syncsiteLine]= $siteArr[0]+','+$resSync.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqSyncSites.Add($syncsiteLine,$resSync.Operation+'#'+1)
            }

            if($uniqSyncItem.ContainsKey($resSync.ItemType)){
                $itemOutput=[String]$uniqSyncItem[$resSync.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resSync.Operation)){
                    $uniqSyncItem[$resSync.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqSyncItem[$resSync.ItemType]= $itemArr[0]+','+$resSync.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqSyncItem.Add($resSync.ItemType,$resSync.Operation+'#'+1)
            }

            if($uniqSyncDestnatn.ContainsKey($resSync.SiteUrl)){
                $destOutput=[String]$uniqSyncDestnatn[$resSync.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resSync.Operation)){
                    $uniqSyncDestnatn[$resSync.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqSyncDestnatn[$resSync.SiteUrl]= $destArr[0]+','+$resSync.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqSyncDestnatn.Add($resSync.SiteUrl,$resSync.Operation+'#'+1)
            }

            if($uniqSyncUsrAgent.ContainsKey($resSync.UserAgent)){
                $uniqSyncUsrAgent[$resSync.UserAgent]=[int]$uniqSyncUsrAgent[$resSync.UserAgent]+1
            }else{
                $uniqSyncUsrAgent.Add($resSync.UserAgent,1)
            }

            if($syncAct.ContainsKey($resSync.Operation)){          
                $syncAct[$resSync.Operation]=[int]$syncAct[$resSync.Operation]+1
            }  
        }

        #    ********** SHARING OPERATIONS ********

        if($resShrg -ne "" -and $resShrg -ne $null){
            $isSiteUrlShrg=[bool]($resShrg.PSobject.Properties.name -match "SiteUrl")
            $isUsrAgntShrg=[bool]($resShrg.PSobject.Properties.name -match "UserAgent")
            if(!$isSiteUrlShrg -or ($isUsrAgntShrg -eq $false) -or (($resShrg.UserId).IndexOf('#') -ne -1)){
                continue
            }
            if($uniqShrOpe.ContainsKey($resShrg.Operation)){
                $uniqShrOpe[$resShrg.Operation]=[int]$uniqShrOpe[$resShrg.Operation]+1
            }else{
                $uniqShrOpe.Add($resShrg.Operation,1) 
            }

            $shrgUsrLine=$resShrg.UserId+'#'+$resShrg.ClientIP
            if($uniqShrUsers.ContainsKey($shrgUsrLine)){          
                $output=[String]$uniqShrUsers[$shrgUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resShrg.Operation)){
                    $uniqShrUsers[$shrgUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqShrUsers[$shrgUsrLine]= $arr[0]+','+$resShrg.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqShrUsers.Add($shrgUsrLine,$resShrg.Operation+'#'+1) 
            }

            if($uniqShrClientIp.ContainsKey($resShrg.ClientIP)){
                $ipOutput=[String]$uniqShrClientIp[$resShrg.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resShrg.Operation)){
                    $uniqShrClientIp[$resShrg.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqShrClientIp[$resShrg.ClientIP]= $ipArr[0]+','+$resShrg.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqShrClientIp.Add($resShrg.ClientIP,$resShrg.Operation+'#'+1)
            }

            $shrgsiteLine=$resShrg.SiteUrl+'#'+$resShrg.Site
            if($uniqShrSites.ContainsKey($shrgsiteLine)){
                $siteOutput=[String]$uniqShrSites[$shrgsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resShrg.Operation)){
                    $uniqShrSites[$shrgsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqShrSites[$shrgsiteLine]= $siteArr[0]+','+$resShrg.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqShrSites.Add($shrgsiteLine,$resShrg.Operation+'#'+1)
            }

            if($uniqShrItem.ContainsKey($resShrg.ItemType)){
                $itemOutput=[String]$uniqShrItem[$resShrg.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resShrg.Operation)){
                    $uniqShrItem[$resShrg.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqShrItem[$resShrg.ItemType]= $itemArr[0]+','+$resShrg.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqShrItem.Add($resShrg.ItemType,$resShrg.Operation+'#'+1)
            }

            if($uniqShrDestnatn.ContainsKey($resShrg.SiteUrl)){
                $destOutput=[String]$uniqShrDestnatn[$resShrg.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resShrg.Operation)){
                    $uniqShrDestnatn[$resShrg.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqShrDestnatn[$resShrg.SiteUrl]= $destArr[0]+','+$resShrg.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqShrDestnatn.Add($resShrg.SiteUrl,$resShrg.Operation+'#'+1)
            }   

            if($uniqShrUsrAgent.ContainsKey($resShrg.UserAgent)){
                $uniqShrUsrAgent[$resShrg.UserAgent]=[int]$uniqShrUsrAgent[$resShrg.UserAgent]+1
            }else{
                $uniqShrUsrAgent.Add($resShrg.UserAgent,1)
            }
     
            if($sharngAct.ContainsKey($resShrg.Operation)){               
                $sharngAct[$resShrg.Operation]=[int]$sharngAct[$resShrg.Operation]+1
            }
   
        }

        # ************** SITE ADMIN OPERATIONS ****************

        if($resSAdm -ne "" -and $resSAdm -ne $null){
            $isAdmUserAgent=[bool]($resSAdm.PSobject.Properties.name -match "UserAgent")
            $isAdmSiteUrl=[bool]($resSAdm.PSobject.Properties.name -match "SiteUrl")
            if(!$isAdmSiteUrl -or ($isAdmUserAgent -eq $false) -or (($resSAdm.UserId).IndexOf('#') -ne -1)){
                continue
            }
            if($uniqAdmnOpe.ContainsKey($resSAdm.Operation)){
                $uniqAdmnOpe[$resSAdm.Operation]=[int]$uniqAdmnOpe[$resSAdm.Operation]+1
            }else{
                $uniqAdmnOpe.Add($resSAdm.Operation,1) 
            }

            $admnUsrLine=$resSAdm.UserId+'#'+$resSAdm.ClientIP
            if($uniqAdmnUsers.ContainsKey($admnUsrLine)){          
                $output=[String]$uniqAdmnUsers[$admnUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resSAdm.Operation)){
                    $uniqAdmnUsers[$admnUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqAdmnUsers[$admnUsrLine]= $arr[0]+','+$resSAdm.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqAdmnUsers.Add($admnUsrLine,$resSAdm.Operation+'#'+1) 
            }

            if($uniqAdmnClientIp.ContainsKey($resSAdm.ClientIP)){
                $ipOutput=[String]$uniqAdmnClientIp[$resSAdm.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnClientIp[$resSAdm.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqAdmnClientIp[$resSAdm.ClientIP]= $ipArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqAdmnClientIp.Add($resSAdm.ClientIP,$resSAdm.Operation+'#'+1)
            }

            if($isAdmSiteUrl){
                $admnsiteLine=$resSAdm.SiteUrl+'#'+$resSAdm.Site
            }#else{
             #   $admnsiteLine='-#'+$resSAdm.Site
            #}
            if($uniqAdmnSites.ContainsKey($admnsiteLine)){
                $siteOutput=[String]$uniqAdmnSites[$admnsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnSites[$admnsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqAdmnSites[$admnsiteLine]= $siteArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqAdmnSites.Add($admnsiteLine,$resSAdm.Operation+'#'+1)
            }

            if($uniqAdmnItem.ContainsKey($resSAdm.ItemType)){
                $itemOutput=[String]$uniqAdmnItem[$resSAdm.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnItem[$resSAdm.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqAdmnItem[$resSAdm.ItemType]= $itemArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqAdmnItem.Add($resSAdm.ItemType,$resSAdm.Operation+'#'+1)
            }

            if($isAdmSiteUrl){
                if($uniqAdmnDestnatn.ContainsKey($resSAdm.SiteUrl)){
                    $destOutput=[String]$uniqAdmnDestnatn[$resSAdm.SiteUrl]
                        $destArr=$destOutput.Split('#')
                    if($destOutput.Contains($resSAdm.Operation)){
                        $uniqAdmnDestnatn[$resSAdm.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                    }else{
                        $uniqAdmnDestnatn[$resSAdm.SiteUrl]= $destArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$destArr[1]+1)
                    }
                }else{
                    $uniqAdmnDestnatn.Add($resSAdm.SiteUrl,$resSAdm.Operation+'#'+1)
                }
            }

            if($isAdmUserAgent){
                if($uniqAdmnUsrAgent.ContainsKey($resSAdm.UserAgent)){
                    $uniqAdmnUsrAgent[$resSAdm.UserAgent]=[int]$uniqAdmnUsrAgent[$resSAdm.UserAgent]+1
                }else{
                    $uniqAdmnUsrAgent.Add($resSAdm.UserAgent,1)
                }
            }
      
            if($siteAdminAct.ContainsKey($resSAdm.Operation)){    
                $siteAdminAct[$resSAdm.Operation]=[int]$siteAdminAct[$resSAdm.Operation]+1
            }
        }
    }
    Eg-WriteLog -writString ('serchAuditLog iteartion finished ...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog

    # ******* FILE OPERATIONS *********

    $fileOperCnt=""
    for($i=0;$i -lt $fileOpe.Length;$i++ ){
        $fileOperCnt+="~!~"+$fileAct[$fileOpe[$i]]
    }
    Write-Host "FilePage Operations Count"$fileOperCnt !>

    #Summary measure count values
    foreach($key in $uniqOpe.keys){
        Write-Host "FilePageOpeartion"~!~ $key ~!~ $uniqOpe[$key] !>
    }

    foreach($key in $uniqusers.keys){
        $fileStrArr=([String]$uniqusers[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageUsers"~!~ $key '#' $updtdStr !>
        }else{
            Write-Host "FilePageUsers"~!~ $key '#' $uniqusers[$key] !>
        }
    }

    foreach($key in $uniqClientIp.keys){
        $fileStrArr=([String]$uniqClientIp[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageClientIP #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageClientIP #"$key '#' $uniqClientIp[$key] !>
        }
    }

    foreach($key in $uniqsites.keys){
        $fileStrArr=([String]$uniqsites[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageSites #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageSites #"$key '#' $uniqsites[$key] !>
        }
    }

    foreach($key in $uniqItem.keys){
        $fileStrArr=([String]$uniqItem[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageitems #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageitems #"$key '#' $uniqItem[$key] !>
        }
    }
    
    foreach($key in $uniqDestnatn.keys){
        $fileStrArr=([String]$uniqDestnatn[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageDestination #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageDestination #"$key '#' $uniqDestnatn[$key] !>
        }   
    }

    foreach($key in $uniqUsrAgent.keys){
        Write-Host "FilePageUserAgent"~!~ $key~!~ $uniqUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('File operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    #    ********** FOLDER OPERATIONS *******

    $fldrOperCnt=""
    for($i=0;$i -lt $folderOpe.Length;$i++ ){   
        $fldrOperCnt+="~!~"+$folderAct[$folderOpe[$i]]
    }
    Write-Host "Folder Operations Count"$fldrOperCnt !>

    foreach($key in $uniqFdrOpe.keys){
        Write-Host "FolderOpeartion"~!~ $key ~!~ $uniqFdrOpe[$key] !>
    }

    foreach($key in $uniqFdrusers.keys){
        $fldrStrArr=([String]$uniqFdrusers[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderUsers"~!~ $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderUsers"~!~ $key '#' $uniqFdrusers[$key] !>
        }   
    }

    foreach($key in $uniqFdrClientIp.keys){
        $fldrStrArr=([String]$uniqFdrClientIp[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderClientIP #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderClientIP #" $key '#' $uniqFdrClientIp[$key] !>
        }
        
    }

    foreach($key in $uniqFdrsites.keys){
        $fldrStrArr=([String]$uniqFdrsites[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderSites #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderSites #" $key '#' $uniqFdrsites[$key] !>
        } 
    }

    foreach($key in $uniqFdrItem.keys){
        $fldrStrArr=([String]$uniqFdrItem[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "Folderitems #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "Folderitems #" $key '#' $uniqFdrItem[$key] !>
        } 
    }

    foreach($key in $uniqFdrDestnatn.keys){
        $fldrStrArr=([String]$uniqFdrDestnatn[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderDestination #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderDestination #" $key '#' $uniqFdrDestnatn[$key] !>
        }
    }

    foreach($key in $uniqFdUsrAgent.keys){
        Write-Host "FolderUserAgent"~!~ $key~!~ $uniqFdUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Folder operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog

    #    ********** SYNC OPERATIONS ********


    $syncOperCnt=""
    for($i=0;$i -lt $syncOpe.Length;$i++ ){
        $syncOperCnt+="~!~"+$syncAct[$syncOpe[$i]]
    }
    Write-Host "Synchronization Operations Count"$syncOperCnt !>

    foreach($key in $uniqSyncOpe.keys){
        Write-Host "SyncOpeartion"~!~ $key ~!~ $uniqSyncOpe[$key] !>
    }

    foreach($key in $uniqSyncUsers.keys){
        $syncStrArr=([String]$uniqSyncUsers[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncUsers"~!~ $key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncUsers"~!~ $key '#' $uniqSyncUsers[$key] !>
        }  
    }

    foreach($key in $uniqSyncClientIp.keys){
        $syncStrArr=([String]$uniqSyncClientIp[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncClientIP #" $key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncClientIP #" $key '#' $uniqSyncClientIp[$key] !>
        }  
    }

    foreach($key in $uniqSyncSites.keys){
        $syncStrArr=([String]$uniqSyncSites[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncSites #"$key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncSites #"$key '#' $uniqSyncSites[$key] !>
        }
    }

    foreach($key in $uniqSyncItem.keys){
        $syncStrArr=([String]$uniqSyncItem[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "Syncitems #"$key '#' $updtdSyncStr !>
        }else{
            Write-Host "Syncitems #"$key '#' $uniqSyncItem[$key] !>
        }
    }

    foreach($key in $uniqSyncDestnatn.keys){
        $syncStrArr=([String]$uniqSyncDestnatn[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncDestination #"$key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncDestination #"$key '#' $uniqSyncDestnatn[$key] !>
        }   
    }

    foreach($key in $uniqSyncUsrAgent.keys){
        Write-Host "SyncUserAgent"~!~ $key~!~ $uniqSyncUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Sync operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog

    #    ********** SHARING OPERATIONS ******** 

    $shrOperCnt=""
     for($i=0;$i -lt $sharngOpe.Length;$i++ ){  
         $shrOperCnt+="~!~"+$sharngAct[$sharngOpe[$i]]
     }
     Write-Host "Sharng Operations Count"$shrOperCnt !>
 
    foreach($key in $uniqShrOpe.keys){
        Write-Host "SharngOpeartion"~!~ $key ~!~ $uniqShrOpe[$key] !>
    }

    foreach($key in $uniqShrUsers.keys){
        $shrStrArr=([String]$uniqShrUsers[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngUsers"~!~ $key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngUsers"~!~ $key '#' $uniqShrUsers[$key] !>
        }  
    }

    foreach($key in $uniqShrClientIp.keys){
        $shrStrArr=([String]$uniqShrClientIp[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngClientIP #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngClientIP #"$key '#' $uniqShrClientIp[$key] !>
        }  
    }

    foreach($key in $uniqShrSites.keys){
        $shrStrArr=([String]$uniqShrSites[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngSites #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngSites #"$key '#' $uniqShrSites[$key] !>
        }  
    }

    foreach($key in $uniqShrItem.keys){
        $shrStrArr=([String]$uniqShrItem[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "Sharngitems #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "Sharngitems #"$key '#' $uniqShrItem[$key] !>
        }    
    }

    foreach($key in $uniqShrDestnatn.keys){
        $shrStrArr=([String]$uniqShrDestnatn[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngDestination #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngDestination #"$key '#' $uniqShrDestnatn[$key] !>
        }
    }

    foreach($key in $uniqShrUsrAgent.keys){
        Write-Host "SharngUserAgent"~!~ $key~!~ $uniqShrUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Sharing operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    # ************** SITE ADMIN OPERATIONS ****************

    $siteAdminOperCnt=""
    for($i=0;$i -lt $siteAdminOpe.Length;$i++ ){  
        $siteAdminOperCnt+="~!~"+$siteAdminAct[$siteAdminOpe[$i]]
    }
    Write-Host "SAdmin Operations Count"$siteAdminOperCnt !>
 
    foreach($key in $uniqAdmnOpe.keys){
        Write-Host "SAdminOpeartion"~!~ $key ~!~ $uniqAdmnOpe[$key] !>
    }

    foreach($key in $uniqAdmnUsers.keys){
        $admnStrArr=([String]$uniqAdmnUsers[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminUsers"~!~ $key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminUsers"~!~ $key '#' $uniqAdmnUsers[$key] !>
        }  
    }

    foreach($key in $uniqAdmnClientIp.keys){
        $admnStrArr=([String]$uniqAdmnClientIp[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminClientIP #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminClientIP #"$key '#' $uniqAdmnClientIp[$key] !>
        }  
    }

    foreach($key in $uniqAdmnSites.keys){
        $admnStrArr=([String]$uniqAdmnSites[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminSites #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminSites #"$key '#' $uniqAdmnSites[$key] !>
        } 
    }

    foreach($key in $uniqAdmnItem.keys){
        $admnStrArr=([String]$uniqAdmnItem[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminitems #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminitems #"$key '#' $uniqAdmnItem[$key] !>
        }
    }

    foreach($key in $uniqAdmnDestnatn.keys){
        $admnStrArr=([String]$uniqAdmnDestnatn[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminDestination #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminDestination #"$key '#' $uniqAdmnDestnatn[$key] !>
        }
    }

    foreach($key in $uniqAdmnUsrAgent.keys){
        Write-Host "SAdminUserAgent"~!~ $key~!~ $uniqAdmnUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Site admin operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
}
Catch{
    $spoExcepMsg3='[SPOActOperations] Exception Occured while processing the objects -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
    Eg-WriteLog -writString ('spoExcepMsg3 -->> '+$spoExcepMsg3) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    Write-Host $spoExcepMsg3
}

[System.GC]::GetTotalMemory($true) | out-null

#         *************************** END *************************


# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUIL3n3fVQEFIz/eylMU5jmRCu
# JX6ggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFNuzSv7A
# l/F4YoezthRZdhPxVYRjMA0GCSqGSIb3DQEBAQUABIICAEoWChukmFTEl8BqU050
# MjU0HqYVoGeobSxWxLGmDFG5DNl+Yq2QkQjejw+VVADIoRM913nZysM5IZt7QvYn
# wufX6EWVAo6TVVFnadY0N4xtVmG/U4cwpDRhcpEvX84cz7Ha1OpzRazTUAujcSPm
# tQdy2mZkL5/TnCB+4kNWTOk2ZNToDS626X27jqDEgI/NgSUXMsj15lEb0NB0DjdM
# y7jka6qRjGZX4mPT4W9Pc0A8TPhVAauks3AGgmLpYK+YYOkR4E9m39CFwmJjH/oY
# vWvu2IHZ/XKV3LqtytmWxXJfoy0uz88AOfJz7wEEiMVPgXqoxLjQ/7dSqJzm0nfE
# KtmmAn1R0jhzcZFQ5MlavwYBFezm7yurhevle8WkaEEbVFEkP7c60g77E2C4RVq+
# ZgWXGGj4n46e7P3hPt0sv1K1gweGWNobbX+BLyegYIOeCcV7wQz5rFsNbJIP+bFx
# M1jMGhAdtKra8wqa6F/QiDtCmN5iHC01DTw4BUwqfJvga25j91Rpx5sdIKOiysfh
# h8K6ip+3Sd+3FlMiFHdSwMc2ANAFOS1P4dZxBe+xBti2yYReFwMvWJb9SFzHEii4
# j5Bof1BPv3hxAObCfp+y7nfrUoaKXL4X1zwjHt2WGiMWYFicIHuhUHEKGYQzfaIW
# EdZHA3RW0IpvwvdapaZYRt9MoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MTAw
# NlowLwYJKoZIhvcNAQkEMSIEIFf4Is2erWngmpb7Jv+F97JnOAUA3RKYeOqMoxH5
# jr6tMA0GCSqGSIb3DQEBAQUABIICAIFPMx/SmuEeEhWCg8XyekXefGBL/EbdOr+Z
# WW2zaWwnPq93Hvx6kyEK3LO8NtaHnaZVNxbBQhfPNMsrpt+rQyEtJb6uc1zom+gq
# 9wVA8MMjULjtD/5hjEbuFj1qyynF7jOspzyqs5jAR7WWrRnUc0y+9UijtgUUGIEe
# ai0u2R5U3xx1pCMmLt9ovrhZCSoI4Y7K+73V+GHI2W3LJLs6kMjd9VDrEaLIr3Nm
# m1nxptSi18DzVjUUbugwXumFxz29bCceKSovslJwQrvXwzBaaYNjZcvqi3VY5HTB
# vuNwgPKtFjh/at/L/i5QYhUlMFgX9cEytob90IjKIMDQKRIJH7FJ2XHRgDaZvnAx
# viQgJBsMUxBowvaepkMlTxid2yiBEYnzvmd5fsfmkxN9hS9Mk0lKb8OTEXhLVqgq
# BXYUgEh0wTKVFFDO71GXbNbacPIKQB0WFs94z/mDWRjp8VZ60ryDLEqocFIp+OxK
# V6zUBbczpSw6+pVoz71y8LxcWsGApN1Qh60D8a4ziKBN1LgFzuO7mTJJ+NVL8JDR
# uUOaIsaU/C0M62eNKktywc6VMOxxYmakoQrWj2UFjr6ev6jblQaxuydyb994JEUi
# F9ofLJnBjTvUKjOWLJC5FhLxs6YmpCK/dsrAfYsMFVWlGK0DUj5V9sWHDTIOVBKF
# HD7fZQBE
# SIG # End signature block
