$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
$computer = $env:computername
Write-Host "Exchange Certificates"
Write-Host "---------------------"
$certs = Get-ExchangeCertificate -Server $computer
if($certs -ne $null)
{
	foreach($cert in $certs)
	{
		$CertificateDomains = $cert.CertificateDomains
		$CertDomains = "-"
		if ($CertificateDomains -ne $null -and $CertificateDomains.length -gt 0)
		{
			$count = 0
			foreach ($CertDomain in $CertificateDomains)
			{
				if ($count -eq 0)
				{
					$CertDomains = $CertDomain
				}
				else
				{
					$CertDomains = $CertDomains + "," + $CertDomain
				}
				$count++
			}
		}
		Write-Host($cert.FriendlyName,$cert.Status,$cert.IsSelfSigned,$cert.HasPrivateKey,$cert.RootCAType,$cert.PublicKeySize,
			   $cert.Services,$cert.Issuer,$cert.Subject,$CertDomains,$cert.NotBefore,$cert.NotAfter,$cert.Thumbprint,$cert.Version) -Separator "#~#"
	}
}

Write-Host "Date Time Format"
Write-Host "----------------"
$ShortDatePattern = (Get-Culture).datetimeformat.ShortDatePattern
$LongTimePattern = (Get-Culture).datetimeformat.LongTimePattern
Write-Host "$ShortDatePattern $LongTimePattern"



