﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

#<#
$TestInputs=$args
$proxyUsr=$TestInputs[0]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[1]
$splitArrVal=($TestInputs[2]).ToString().Split("#")
$testFrequency=($splitArrVal[0]).ToString().trim()
$proxyserverip=($splitArrVal[1]).ToString().trim()
$rptNam=($splitArrVal[2]).ToString().trim()
$statusVal=($splitArrVal[3]).ToString().trim()
$graphDtls=$TestInputs[3]
#>

$graphDtlsArr=$graphDtls.ToString() -split '~!~'
$appId=$graphDtlsArr[0]
$appSecret=$graphDtlsArr[1]
$authString=$graphDtlsArr[2]
$resource=$graphDtlsArr[3]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$rptPath=$egurkhaPath+'\agent\YMR\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$logPath=$rptPath+'\YMRServiceHealth.log'

$lastruntime=((Get-date).AddMinutes($testFrequency)).ToUniversalTime()
Eg-WriteLog -writString ('Lastruntime -->> '+$lastruntime) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
$proxyserver='http://'+$proxyserverip
[System.GC]::GetTotalMemory($true) | out-null
[System.Collections.ArrayList]$incidentIDs=@()
    

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url, 
        [Parameter(Mandatory=$true, Position=2)]
        [Object]$header              
    )

    Process
    {
        $query=[System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        $query= $query | ConvertFrom-Json
        #$query=$query.value
        return $query
    }
}  

$path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $path
$creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
$authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
$context = $authContext.AcquireTokenAsync($resource, $creds).Result
$authCode=$context.CreateAuthorizationHeader()
$header = @{
    'Authorization'=$authCode
}
$O365Servicesurl= "https://graph.microsoft.com/v1.0/admin/serviceAnnouncement/issues"
while($true){
    $serv= Eg-InvokeUrl -Url $O365Servicesurl -header $header
    $values=$serv.value
    foreach($issue in $values){
        $Status = ($issue.Status).Trim()
        $ID = $issue.id
        $title = $issue.title
        $ServiceName=($issue.service).Trim()
        $Startime=$issue.startDateTime
        $Endtime =$issue.endDateTime
        $lastupdated=$issue.lastModifiedDateTime
        #$messages=$issue.impactDescription
        $FeatureName= $issue.Feature
        $type=($issue.classification).Trim()

        Eg-WriteLog -writString ('Incidents ID -->>'+$ID+" -- "+$ServiceName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
        if($ServiceName -eq 'Yammer Enterprise' -and $issue.isResolved -ne 'True' -and $statusVal -match $Status){
            $post=$issue.posts|select -Last 1
            $messages=$post.description
            if($type -eq "incident"){ 
                Write-Host $type  ~!~ "NOTOKSERVICE" ~!~  $Status ~!~  $ID ~!~  $title ~!~  $Status   ~!~  $ServiceName ~!~  $Startime ~!~  $Endtime ~!~  $lastupdated ~!~  $FeatureName ~!~ $messages "##msage##"
                Eg-WriteLog -writString ('OUTPUT -->> '+$type+'~'+$Status+'~'+$ID+'~'+$title+'~'+$ServiceName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
            }
            elseif($type -eq "advisory"){
                Write-Host $type ~!~ "ADVISORY" ~!~ $Status ~!~  $ID ~!~  $title ~!~  $Status   ~!~  $ServiceName ~!~  $Startime ~!~  $Endtime ~!~  $lastupdated ~!~  $FeatureName ~!~  $messages "##msage##"
                Eg-WriteLog -writString ('OUTPUT -->> '+$type+'~'+$Status+'~'+$ID+'~'+$title+'~'+$ServiceName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
            }
        }
    }
    if($serv."@odata.nextLink" -eq $null -or $serv."@odata.nextLink" -eq ''){
        break;
    }else{
        $O365Servicesurl=($serv."@odata.nextLink")
    }
}
    
[System.GC]::GetTotalMemory($true) | out-null
