﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyserverip=$TestInputs[2]
$proxyUsr=$TestInputs[3]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[4]
$appDetails=$TestInputs[5]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)    
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

if($appDetails -and $appDetails -ne 'none'){
    $azureAD=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName -AzureEnvironmentName AzureCloud
    $tenantId=$azureAD.TenantId
    $domains=Get-AzureADDomain |select * 
    foreach($domain in $domains){
        if($domain.IsInitial -eq $true){
            $initialDomain=$domain.Name
        }
    }
}else{
    $azureAD=Connect-AzureAD -Credential $Credential -AzureEnvironmentName $azureEnvArr[0] |select *
    $tenantId=$azureAD.TenantId

    Connect-MsolService -Credential $Credential -AzureEnvironment $azureEnvArr[0]
    $domains=Get-MsolDomain |select *
    foreach($domain in $domains){
        if($domain.IsInitial -eq $true){
            $initialDomain=$domain.Name
        }
    }
}
Write-Host $initialDomain'~'$tenantId

$dir=$egurkhaPath+'\agent\O365\MsGraph'
$grphKeyFile=$dir+'\GraphDetailsKey.dat'
$grphDtlsFile=$dir+'\GraphDetails.dat'
$wpath=$dir+'\GraphDetails1.txt'
$grphDtlsTxt=$dir+'\GraphDetails.txt'

if(Test-Path $grphDtlsFile -PathType Leaf){
    $kvalue=Get-Content -Path $grphKeyFile
    Unprotect-File $grphDtlsFile -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
}

$isExist=$false
$lines=Get-Content -Path $grphDtlsTxt
for($i=0;$i -lt $lines.Length;$i++){
    Add-Content -Path $wpath -Value $lines[$i]
    if($lines[$i] -match $initialDomain){
        $isExist=$true
    }
    if($isExist -and $lines[$i].StartsWith('Resource~')){
        $str='TenantId~'+$tenantId
        Add-Content -Path $wpath -Value $str
        $isExist=$false
    }
}

Remove-Item -Path $grphDtlsFile
Remove-Item -Path $grphDtlsTxt

Rename-Item $wpath 'GraphDetails.txt'

$key=Get-CryptoKey -FileDir $dir -FileName '\GraphDetailsKey.dat'
$null=Protect-File $grphDtlsTxt -Algorithm AES -KeyAsPlainText $key -RemoveSource

Write-Host 'TenantId updated'