﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides OneDrive Users Details
    Created           :       15/09/2020    
    /*****************************************************************************
#>

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$toreadDate_UsersUsage=[datetime]$TestInputs[5]
$toreadDate_UsersActvtyDtl=[datetime]$TestInputs[6]
$rptNam=$TestInputs[7]
$graphDetails=$TestInputs[8]
if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.ToString().ToLower().Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$rptPath=$egurkhaPath+'\agent\ODB\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$ODBUsersUsageCSV=$rptPath+'\ODBUsersUsage'+$timenow+'.csv'
$url1 = "https://graph.microsoft.com/v1.0/reports/getOneDriveUsageAccountDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url1 -filePath $ODBUsersUsageCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalUsersUsage=Import-Csv $ODBUsersUsageCSV -Encoding $encTyp
    $url1=$TotalUsersUsage.'@odata.nextLink'
    if($url1 -eq $null -or $url1 -eq ''){
        break
    }
}
$firstRecord1=$TotalUsersUsage | select ReportRefreshDate -First 1
$ReportRefreshDate1=($firstRecord1.ReportRefreshDate)
$diffence1=(NEW-TIMESPAN –Start $toreadDate_UsersUsage –End $ReportRefreshDate1 | Select-Object Days).Days
if($diffence1 -ge 1){$reportRefreshed1=$true}

[System.GC]::GetTotalMemory($true) | out-null
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$ODBUsrActvtyDtlCSV=$rptPath+'\ODBUsrActvtyDtl'+$timenow+'.csv'
$url2="https://graph.microsoft.com/v1.0/reports/getOneDriveActivityUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url2 -filePath $ODBUsrActvtyDtlCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $ODBUsrActvtytotal=Import-Csv $ODBUsrActvtyDtlCSV -Encoding $encTyp
    $url2=$ODBUsrActvtytotal.'@odata.nextLink'
    if($url2 -eq $null -or $url2 -eq ''){
        break
    }
}
$firstRecord2=$ODBUsrActvtytotal | select ReportRefreshDate -First 1
$ReportRefreshDate2=($firstRecord2.ReportRefreshDate)
$diffence2=(NEW-TIMESPAN –Start $toreadDate_UsersActvtyDtl –End $ReportRefreshDate2 | Select-Object Days).Days
if($diffence2 -ge 1){$reportRefreshed2=$true}

[System.GC]::GetTotalMemory($true) | out-null
if($reportRefreshed1 -and $reportRefreshed2){
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsersUsage –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsersUsage=$toreadDate_UsersUsage.AddDays(1) }
        $actualdate=$toreadDate_UsersUsage
        $notFirsttime = $true
        $TotalUsersUsg =$TotalUsersUsage | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalUsersUsg)
        {
            Write-Host 'ReadDate of UsersUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
	[System.GC]::GetTotalMemory($true) | out-null
	
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsersActvtyDtl –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsersActvtyDtl=$toreadDate_UsersActvtyDtl.AddDays(1) }
        $actualdate=$toreadDate_UsersActvtyDtl
        $notFirsttime = $true
        $ODBUsrActivity =$ODBUsrActvtytotal | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }
        if($ODBUsrActivity)
        {
            Write-Host 'ReadDate of UsersActvtyDtl Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersActvtyDtl Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
	[System.GC]::GetTotalMemory($true) | out-null
}
$TotalUsersUsg = $TotalUsersUsg | Where-Object { $_.OwnerPrincipalName -ne '(Unknown)' -and $_.IsDeleted -ne 'True'} 
foreach($dev in $TotalUsersUsg) {
    if([long]$dev.StorageUsed -ge 0){$StorageUsd=[math]::Round(([long]$dev.StorageUsed/1073741824),2)}else{$StorageUsd=0}
    if([long]$dev.StorageAllocated -ge 0){$StorageAllctd=[math]::Round(([long]$dev.StorageAllocated/1073741824),2)}else{$StorageAllctd=0}        
    if($StorageUsd -ge 0 -and $StorageAllctd -gt 0){ $Storageusedprcnt =($StorageUsd/$StorageAllctd)*100 }else{$Storageusedprcnt=0}                                
    $Output='UsageDetails~'+$dev.OwnerPrincipalName+'~'+$dev.FileCount+'~'+$dev.ActiveFileCount+'~'+$StorageUsd+'~'+$StorageAllctd+'~'+[math]::Round($Storageusedprcnt,2)
    Write-Host $Output
}
[System.GC]::GetTotalMemory($true) | out-null
Remove-Item $ODBUsersUsageCSV

$ODBUsrActivity = $ODBUsrActivity | Where-Object { $_.UserPrincipalName -ne '(Unknown)' -and $_.IsDeleted -ne 'True' }
foreach($usr in $ODBUsrActivity) {
    $hasLicenses=0
    $assignedProducts=$usr.AssignedProducts
    if($assignedProducts -and $assignedProducts.Trim().Length -gt 0){
        $hasLicenses=1
    }
    $Output='ActivityDetails~'+$usr.UserPrincipalName+'~'+$usr.ViewedOrEditedFileCount+'~'+$usr.SyncedFileCount+'~'+$usr.SharedInternallyFileCount+'~'+$usr.SharedExternallyFileCount+'~'+$hasLicenses
    Write-Host $Output
}
[System.GC]::GetTotalMemory($true) | out-null
Remove-Item $ODBUsrActvtyDtlCSV