﻿##/*****************************************************************************
##Author                :               Guravareddy.T
##Purpose               :               O365 Gropus Types And Count
##Created               :               11/1/2017
##Modified By		: 
##/*****************************************************************************

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$reportingname='EXO/'+$testargs[0]
$testFrequency=$testargs[1]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

function Convert-UnixTime {
Param(
[Parameter(Mandatory=$true)][int32]$udate
)
 
    # Retrieve start of UNIX Format
    $orig = (Get-Date -Year 1970 -Month 1 -Day 1 -hour 0 -Minute 0 -Second 0 -Millisecond 0)
 
    # Return final time
return $orig.AddSeconds($udate)
}


    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
    if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}


try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "unifiedgroups" -keyFileName "kunifiedgroups" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $disbtedgrp= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'unifiedgroups' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kunifiedgroups' -InputFile $readfiles[4]
        Write-Host "ReadFile:"$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    [System.GC]::GetTotalMemory($true) | out-null
        try{
            $datpos = $readfiles[3].IndexOf(".dat")
	        $length='unifiedgroups'.Length  
            $tmpvalue = $readfiles[3].toString().substring($length,($datpos-$length))
    		$readtime= Convert-UnixTime $tmpvalue
    		$readfiledif=NEW-TIMESPAN –Start $readtime –End (Get-Date) | Select-Object TotalMinutes
    		$dfnmb=[int]($readfiledif.TotalMinutes/(-$testFrequency))
    		$dfnmb=$dfnmb+1
    	}
    	catch{
    		$dfnmb=1
    	}

	$LastMsmtTime = ((Get-Date).AddMinutes($dfnmb*($testfrequency))).ToUniversalTime()
	$dsgrp_groups=@{}

	foreach($total in $disbtedgrp)
	{
	    $grouptype=($total.GroupType).Trim()
	    if($grouptype.StartsWith('Universal,'))
	    {

		$grouptype=$grouptype.Substring(('Universal,'.Length)).Trim()
	    }
	    if($dsgrp_groups.ContainsKey($grouptype))
	    {
	    }
	    else
	    {
		Write-Host 'grouptype##' $grouptype
		$dsgrp_groups[$grouptype]=@{}
		$dsgrp_groups[$grouptype]['changedcnt'] = 0
		$dsgrp_groups[$grouptype]['createdcnt'] = 0
		$dsgrp_groups[$grouptype]['softdeletcnt'] = 0
		$dsgrp_groups[$grouptype]['totalcnt'] = 0
		$dsgrp_groups[$grouptype]['publiccnt'] = 0
		$dsgrp_groups[$grouptype]['privatecnt'] = 0
		$dsgrp_groups[$grouptype]['orphancnt'] = 0
		$dsgrp_groups[$grouptype]['emptycnt'] = 0
		$dsgrp_groups[$grouptype]['groupextmemcnt'] = 0

	    }

	}

	foreach($total in $disbtedgrp)
	{
            $totChangedUTC=([String]$total.WhenChangedUTC.Replace('??','')).Trim()
            $totCreatedUTC=([String]$total.WhenCreatedUTC.Replace('??','')).Trim()
            try{
                if($totChangedUTC -ne $null -and $totChangedUTC -ne ''){
                    $total.WhenChangedUTC=Eg-ParseExact -dateStr $totChangedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }
                if($totCreatedUTC -ne $null -and $totCreatedUTC -ne ''){
                    $total.WhenCreatedUTC=Eg-ParseExact -dateStr $totCreatedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }
             #$total.WhenChangedUTC=[DateTime]::ParseExact(($total.WhenChangedUTC),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
             #$total.WhenCreatedUTC=[DateTime]::ParseExact(($total.WhenCreatedUTC),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            }catch{
             $exp=$_.Exception.Message
             Write-Error 'error occures while changing data format' $exp  
            }
	    $grouptype=($total.GroupType).Trim()
	    if($grouptype.StartsWith('Universal,'))
	    {

		$grouptype=$grouptype.Substring(('Universal,'.Length)).Trim()
	    }
	    if($dsgrp_groups.ContainsKey($grouptype))
	    {

		$status=$total.isvalid
		if($status -eq 'True')
		{
			$status='Active'
		}
		else
		{
			$status='Inactive'
		}

	        if($total.WhenSoftDeleted -eq "" -or $total.WhenSoftDeleted -eq $null)
                {
			$dsgrp_groups[$grouptype]['totalcnt']++
                }
	     
		 if($total.AccessType -eq "Public")
		 {
		      Write-Host $grouptype 'publiccnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberCount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		      $dsgrp_groups[$grouptype]['publiccnt']++
		 } 

		 if($total.AccessType -eq "Private") 
		 { 
		     Write-Host $grouptype 'privatecnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberCount'~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		     $dsgrp_groups[$grouptype]['privatecnt']++
		 }

		if($total.ManagedBy -eq "" -or $total.ManagedBy -eq $Null ) 
		{
		    Write-Host $grouptype 'orphancnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberCount'~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['orphancnt']++
		}
		if($total.GroupMemberCount -eq  0) 
		{
		    Write-Host $grouptype 'emptycnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' '-5' '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['emptycnt']++
		}
		if($total.GroupExternalMemberCount -gt 0) 
		{
		    Write-Host $grouptype 'groupextmemcnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupExternalMemberCount'~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['groupextmemcnt']++
		}
		if ($total.WhenSoftDeleted -ne "" -and  [DateTime]($total.WhenSoftDeleted) -gt $LastMsmtTime)  {
		    Write-Host $grouptype 'softdeletcnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberCount'~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['softdeletcnt']++
		}

		if ($total.WhenChangedUTC -ne "" -and [DateTime]($total.WhenChangedUTC) -gt $LastMsmtTime)  
		{
		    Write-Host $grouptype 'changedcnt#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberCount'~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['changedcnt']++
		}

		if ($total.WhenCreatedUTC -ne "" -and [DateTime]($total.WhenCreatedUTC) -gt $LastMsmtTime)  
		{
		    Write-Host $grouptype 'createdutc#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberCount  '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['createdcnt']++
		}
	    }

	}

	foreach($grup  in $dsgrp_groups.Keys)
	{
	 
	    foreach($key in $dsgrp_groups[$grup].Keys)
	    {
		Write-Host $grup$key  $dsgrp_groups[$grup][$key]
	    }
	}
[System.GC]::GetTotalMemory($true) | out-null
