﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$certDir=$egurkhaPath+'\agent\O365\AppInfo'
if(!(Test-Path -Path $certDir)){
    $null=New-Item -ItemType directory -Path $certDir
}
$logFile=$certDir+'\O365_AppPrerequisites.log'

$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
if($chkWinrm -notmatch 'Basic=true'){
    Write-Host 'WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE...' -ForegroundColor Red
    O365-WriteLog -writString ("WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE..."+$chkWinrm) -LogPath $logFile -ReportingName 'ERROR'
    exit
}

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
$msGrphAppName=''
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('Graph_APP_Name')){
            $msGrphAppName=$line.Replace('Graph_APP_Name=','')
            break;
        }  
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExist=$true
    }
}

$code = @"
[DllImport("user32.dll", CharSet = CharSet.Unicode)]
public static extern IntPtr SendMessage(IntPtr hWnd, 
    int msg, IntPtr wParam, string lParam);  
public const int EM_SETCUEBANER = 0x1501;
"@
$Win32Helpers = Add-Type -MemberDefinition $code -Name "Win32Helpers" -PassThru
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")

$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button

$pfxDtlsLbl=New-Object System.Windows.Forms.Label
$mfGrpLbl=New-Object System.Windows.Forms.Label
$mfGrpTxtBx=New-Object System.Windows.Forms.TextBox
$mfMemLbl=New-Object System.Windows.Forms.Label
$mfMemTxtBx=New-Object System.Windows.Forms.TextBox
$grphTntLbl=New-Object System.Windows.Forms.Label
$grphTntTxtBx=New-Object System.Windows.Forms.TextBox
$grphAppNamLbl=New-Object System.Windows.Forms.Label
$grphAppNamTxtBx=New-Object System.Windows.Forms.TextBox

$prxyDtlsLbl=New-Object System.Windows.Forms.Label
$prxyHostLbl=New-Object System.Windows.Forms.Label
$prxyPortLbl=New-Object System.Windows.Forms.Label
$prxyUsrLbl=New-Object System.Windows.Forms.Label
$prxyPassLbl=New-Object System.Windows.Forms.Label
$prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
$prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPassTxtBx=New-Object System.Windows.Forms.TextBox

$formsize = 320

$form.Controls.Add($mfGrpLbl)
$form.Controls.Add($mfGrpTxtBx)
$form.Controls.Add($mfMemLbl)
$form.Controls.Add($mfMemTxtBx)
$form.Controls.Add($grphTntLbl)
$form.Controls.Add($grphTntTxtBx)
$form.Controls.Add($grphAppNamLbl)
$form.Controls.Add($grphAppNamTxtBx)

$form.Controls.Add($prxyDtlsLbl)
$form.Controls.Add($prxyHostLbl)
$form.Controls.Add($prxyHostTxtBx)
$form.Controls.Add($prxyPortLbl)
$form.Controls.Add($prxyPortTxtBx)
$form.Controls.Add($prxyUsrLbl)
$form.Controls.Add($prxyUsrTxtBx)
$form.Controls.Add($prxyPassLbl)
$form.Controls.Add($prxyPassTxtBx)

$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "390 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'O365 Limiting Access To Mail Flow Users'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

$mfGrpLbl.Location="38,15"
$mfGrpLbl.Anchor="Bottom, Left"
$mfGrpLbl.Text="&Group Name"
$mfGrpLbl.Size="115,20"
$mfGrpTxtBx.Location="152,15"
$mfGrpTxtBx.Name="grpNam"
$mfGrpTxtBx.Size="200,20"
$mfGrpTxtBx.Text=""

$mfMemLbl.Location="38,45"
$mfMemLbl.Anchor="Bottom, Left"
$mfMemLbl.Text="&Group Member(s)"
$mfMemLbl.Size="115,20"
$mfMemTxtBx.Location="152,45"
$mfMemTxtBx.Name="memNam"
$mfMemTxtBx.Size="200,20"
$mfMemTxtBx.Text=""
$mfMemTxtBx.add_HandleCreated({
    $Win32Helpers::SendMessage($mfMemTxtBx.Handle,$Win32Helpers::EM_SETCUEBANER,[IntPtr]0, "abc@domain.com,xyz@domain.com")
})

$grphTntLbl.Location="38,75"
$grphTntLbl.Anchor="Bottom, Left"
$grphTntLbl.Text="&Tenant Name"
$grphTntLbl.Size="115,20"
$grphTntTxtBx.Location="152,75"
$grphTntTxtBx.Name="tntNam"
$grphTntTxtBx.Size="200,20"
$grphTntTxtBx.Text=""

$grphAppNamLbl.Location="38,105"
$grphAppNamLbl.Anchor="Bottom, Left"
$grphAppNamLbl.Text="&MsGraph App Name"
$grphAppNamLbl.Size="115,20"
$grphAppNamTxtBx.Location="152,105"
$grphAppNamTxtBx.Name="appNam"
$grphAppNamTxtBx.Size="200,20"
$grphAppNamTxtBx.Text=$msGrphAppName

$prxyDtlsLbl.Location="38,140"
$prxyDtlsLbl.Anchor="Bottom, Left"
$prxyDtlsLbl.Text="&Proxy Details :"
$prxyDtlsLbl.Size="100,20"
$prxyHostLbl.Location="68,165"
$prxyHostLbl.Anchor="Bottom, Left"
$prxyHostLbl.Text="&Host IP"
$prxyHostLbl.Size="80,20"
$prxyHostTxtBx.Location="152,165"
$prxyHostTxtBx.Name="ProxyHost"
$prxyHostTxtBx.Size="120,20"
$prxyHostTxtBx.Text="none"
$prxyPortLbl.Location="275,165"
$prxyPortLbl.Anchor="Bottom, Left"
$prxyPortLbl.Text="&Port"
$prxyPortLbl.Size="25,20"
$prxyPortTxtBx.Location="300,165"
$prxyPortTxtBx.Name="Port"
$prxyPortTxtBx.Size="50,20"
$prxyPortTxtBx.Text="none"
$prxyUsrLbl.Location="68,190"
$prxyUsrLbl.Anchor="Bottom, Left"
$prxyUsrLbl.Text="&Username"
$prxyUsrLbl.Size="80,20"
$prxyUsrTxtBx.Location="152,190"
$prxyUsrTxtBx.Name="ProxyUser"
$prxyUsrTxtBx.Size="200,20"
$prxyUsrTxtBx.Text="none"
$prxyPassLbl.Location="68,220"
$prxyPassLbl.Anchor="Bottom, Left"
$prxyPassLbl.Text="&Password"
$prxyPassLbl.Size="80,20"
$prxyPassTxtBx.Location="152,220"
$prxyPassTxtBx.Name="ProxyPass"
$prxyPassTxtBx.Size="200,20"
$prxyPassTxtBx.Text="none"
$prxyPassTxtBx.PasswordChar='*'


$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "150, 264"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'
$frmDialog=$form.ShowDialog()

if($frmDialog -eq 'OK' ){
    $mfGrpName=$mfGrpTxtBx.Text
    $mfGrpMembersStr=$mfMemTxtBx.Text
    $mfTntName=$grphTntTxtBx.Text
    $mfMsGrphNam=$grphAppNamTxtBx.Text
    $proxyHost=$prxyHostTxtBx.Text
    $proxyPort=$prxyPortTxtBx.Text
    $proxyUsr=$prxyUsrTxtBx.Text
    $proxyPass=$prxyPassTxtBx.Text
    if($mfGrpName -eq "" -or $mfGrpMembersStr -eq '' -or $proxyHost -eq '' -or $proxyPort -eq '' -or $proxyUsr -eq '' -or $proxyPass -eq ''){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red
        exit
    }
}else{
    Write-Host 'Exiting...'
    exit
}

$grphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $grphDir)){
    Write-Host 'MSGraph folder is not available!'
    exit
}

O365-WriteLog -writString  "---------------------------------------------------------------" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString "" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString  "     ******** O365 Limiting Access to MailFlow users execution started ***********   " -LogPath $logFile -ReportingName 'INFO'
Write-Host "     ******** O365 Limiting Access to MailFlow users execution started ***********   "

$sessionOption = New-PSSessionOption -SkipRevocationCheck
$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType IEConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
    }
}

Connect-ExchangeOnline -PSSessionOption $sessionOption

$isRunNewDist=$false
$existGrpMemStr=''
$mfGrpMembers=@()
$PolicyGrpId=''
Try{
    $existGrpMem=Get-DistributionGroupMember -Identity $mfGrpName -ErrorAction Stop |select * 
    foreach($emem in $existGrpMem){
        $existGrpMemStr+='~'+$emem.PrimarySmtpAddress
    }
    Write-Host "$mfGrpName - Group exists!" -ForegroundColor Green
    O365-WriteLog -writString  "$mfGrpName - Group exists!" -LogPath $logFile -ReportingName 'INFO'
    $mfGrpMembersArr=$mfGrpMembersStr.Split(',')
    foreach($mem in $mfGrpMembersArr){
        if($existGrpMemStr -notmatch $mem){  
            $mfGrpMembers+=$mem
        }
    }
    if($mfGrpMembers.Count -gt 0){
        foreach($grpmem in $mfGrpMembers){
            Add-DistributionGroupMember -Identity $mfGrpName -Member $grpmem
            Write-Host "$mfGrpMembers - member(s) is added to $mfGrpName" -ForegroundColor Green
            O365-WriteLog -writString  "$mfGrpMembers - member(s) is added to $mfGrpName" -LogPath $logFile -ReportingName 'INFO'
        }
    }else{
        Write-Host "$mfGrpMembers - member(s) already available in $mfGrpName" -ForegroundColor Green
        O365-WriteLog -writString  "$mfGrpMembers - member(s) already available in $mfGrpName" -LogPath $logFile -ReportingName 'INFO'
    }
}Catch{
    $msg=$_.Exception.Message
    $errStr="`'$mfGrpName`' couldn't be found"
    if($msg -match $errStr){
        Write-host "Mail-enabled Security Group not found" -ForegroundColor Red
        $isRunNewDist=$true
    }else{
        exit
    }
}

if($isRunNewDist){
    Write-Host "$mfGrpName - Group creation started"
    O365-WriteLog -writString  "$mfGrpName - Group creation started" -LogPath $logFile -ReportingName 'INFO'

    $mfGrpMembers=$mfGrpMembersStr.Split(',')
    Try{
        $newGrp= New-DistributionGroup -Name $mfGrpName -Alias $mfGrpName -Type "Security" -Members $mfGrpMembers
        if($newGrp.Name -eq $mfGrpName){
            Write-Host "$mfGrpName - Group created" -ForegroundColor Green
            O365-WriteLog -writString  "$mfGrpName - Group created" -LogPath $logFile -ReportingName 'INFO'
            $PolicyGrpId=$newGrp.PrimarySmtpAddress
        }
    }Catch{
        Write-host "[Group Creation] Exception Occurred - $message." -ForegroundColor Red
        O365-WriteLog -writString  "[Group Creation] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }
}

$mfAppId=''
$keyPath=$grphDir+'\GraphDetailsKey.dat'
$unProtFile=$grphDir+'\GraphDetails.dat'
if(Test-Path $unProtFile -PathType Leaf){
    $unProtPath=$grphDir+'\GraphDetails.dat'
    $kvalue=Get-Content -Path $keyPath
    Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
}
$grphDtlPath=$grphDir+'\GraphDetails.txt'
if(Test-Path $grphDtlPath -PathType Leaf){
    $lines=Get-Content -Path $grphDtlPath
    Remove-Item $grphDtlPath
    $isAppIdExist=$false
    $chkNam=('['+$mfMsGrphNam+'-'+$mfTntName).Trim()
    foreach($line in $lines){
        if($isAppIdExist){
            if($line.StartsWith('client_id')){
                $mfAppId=$line.Replace('client_id~','').Trim()
                break;
            }
        }
        if($line.StartsWith($chkNam)){
            $isAppIdExist=$true
        }
    }
}
if($mfGrpMembers.Count -eq 0){
    $mfGrpMembers=$mfGrpMembersStr.Split(',')
}
$identity=[String]$mfGrpMembers[0]

Start-Sleep -Seconds 10

if($mfAppId -ne ''){
    if($PolicyGrpId -ne ''){
        Try{
            $appPolicy=New-ApplicationAccessPolicy -AppId $mfAppId -PolicyScopeGroupId $PolicyGrpId -AccessRight 'RestrictAccess' -Description "Restrict this app to mailflow users"
            if($appPolicy.AppId -eq $mfAppId){
                Write-Host "New Application Access Policy is created for app ($mfAppId)..." -ForegroundColor Green
                O365-WriteLog -writString  "New Application Access Policy is created for app ($mfAppId)..." -LogPath $logFile -ReportingName 'INFO'
            }
        }
        Catch{
            Write-host "[New-ApplicationAccessPolicy] Exception Occurred - $message." -ForegroundColor Red
            O365-WriteLog -writString  "[New-ApplicationAccessPolicy] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
        }
    }
    else{
        Write-Host "PolicyGroupId is empty and Group exists..." -ForegroundColor Red
        O365-WriteLog -writString  "PolicyGroupId is empty and Group exists..." -LogPath $logFile -ReportingName 'INFO'
    }
    Start-Sleep -Seconds 5
    Try{
        $tstAppPolicy=Test-ApplicationAccessPolicy -Identity $identity -AppId $mfAppId
        if($tstAppPolicy.AppId -eq $mfAppId){
            Write-Host "New Application Access Policy is verified successfully" -ForegroundColor Green
            O365-WriteLog -writString  "New Application Access Policy is verified successfully" -LogPath $logFile -ReportingName 'INFO'
        }
    }Catch{
        Write-host "[Test-ApplicationAccessPolicy] Exception Occurred - $message." -ForegroundColor Red
        O365-WriteLog -writString  "[Test-ApplicationAccessPolicy] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }
}else{
    Write-Host "MsGraph Application not found" -ForegroundColor Red
    O365-WriteLog -writString  "MsGraph Application not found" -LogPath $logFile -ReportingName 'INFO'
}

$getSession=Get-PSSession -ErrorAction SilentlyContinue
if($getSession -ne $null -and $getSession -ne ''){
	Disconnect-ExchangeOnline -Confirm:$false
}

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

O365-WriteLog -writString  "     ******** O365 Limiting Access to MailFlow users execution ended ***********   " -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString  "---------------------------------------------------------------" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString "" -LogPath $logFile -ReportingName 'INFO'