﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()

function IsFileExists
{
    param(
        [Parameter(Mandatory=$true, Position=0)]
        [string] $fileName
    )
    process {
        $tempName = $fileName.Substring(0, $fileName.lastIndexOf('.csv'))
        $tempName = $tempName+'1.csv'
        If (Test-Path $tempName) {
            Remove-Item -Path $tempName -Force
        }
        If (Test-Path $fileName) {
            Get-ChildItem $fileName | Rename-Item -NewName {$_.Name -replace ".csv", "1.csv"}
        }
    }
}

function WriteToCSV
{
    Param
    (
         [Parameter(Mandatory=$true, Position=0)]
         [string] $fileName,
         [Parameter(Mandatory=$true, Position=1)]
         [Object[]]$data
    )
    process {
        If (Test-Path $fileName) {
            $dtls=Get-Content -Path $fileName
            $rows = $dtls.Length-1
            if($rows -lt 50000){
                $data | Export-Csv -Path $fileName -NoTypeInformation -Append
            }
            <#else{
                IsFileExists -fileName $fileName
                $data | Export-Csv -Path $fileName -NoTypeInformation
            }#>
        }else{
            $data | Export-Csv -Path $fileName -NoTypeInformation
        }
    }
}
clear
$InputDays=$args
$USER_INPUT=$InputDays[0]
$tFreq = [int]$InputDays[1]
$dFreq = [int]$InputDays[2]
$Test_Freq=(Get-Date).AddMinutes(-$tFreq)
$Dormant_Freq=(Get-Date).AddDays(-$dFreq)
$rptNam= $InputDays[3]
$writecsv= $InputDays[4]
$rptTopNDD= [int]$InputDays[5]
# Start-SPAssignment –Global
$ListNotAccess=""
$NoSitesCoAvailable=""
# Initializing the total variables 
$FileSize = @{}
$FileTypeCount = @{}
$FileSpecificCount = @{}
$TotalSiteCount=0
$TotalListCount = 0
$TotalDocLibraryCount = 0
$TotalDocCount = 0
$TotalUserCount = 0
$TotalSCCount = 0
$TotalVerCount =0 
$TotalDocSize = 0
$TotAvgDocPerDocLibrary=0
$TotalAttachments=0 
$TotalSiteCollSize=0
$TotalSiteSize = 0;
$SiteSize = 0
$TotalDormCount = 0
$TotalRecUpdCount = 0
$TotalRecAddCount = 0

$webs=$null;
$web="";
$file="";

$rootPath=$egurkhaPath +'\agent\SP\'+$rptNam+'\'
if(!(Test-Path -Path $rootPath )){
    $null=New-Item -ItemType directory -Path $rootPath
}

$RecAddedFileName=$rootPath+'Recently Added Files.csv'
$RecUpdatedFileName=$rootPath+'Recently Updated Files.csv'
$DormantFileName=$rootPath+'Dormant Files.csv'

if($writecsv){
    IsFileExists -fileName $RecAddedFileName
    IsFileExists -fileName $RecUpdatedFileName
    IsFileExists -fileName $DormantFileName
}

$webApp = Get-SPWebApplication;

foreach($webs in $webApp)
{
    try{
        # Initialize all variables to 0 at the start of the loop 
        $SiteCount=0
        $ListCount=0;
        $DocLibraryCount=0
        $DocCount=0 
        $UserCount=0
        $SCCount=0
        $VerCount =0 
        $DocSize=0
        $AvgDocPerDocLibrary=0
        $AvgSizeofDocument=0
        $SCSize=0 
        $ContentDBCount=0
        $AttachmentCount=0
        $SiteCount=0
        $wa = $webs.url
        $run=0
        
        $WebAppContentDB = $webs.ContentDatabases
        $WebAppConentDBName=""
    
        foreach($cd in $WebAppContentDB){
            $WebAppConentDBName = $WebAppConentDBName + $cd.Name + "~"
        }
	
        $ContentDBCount =$webs.ContentDatabases.Count             # Get the count of content databases associated to this web application
        $SCCount=$webs.Sites.Count                                # Get the count of site collections in a web application

        Write-Host 'Web application --->>> '$webs.Name 'Site collection -->>>> ' $webs.Sites 'SCCount ---->>>> ' $SCCount   
        try{
            $usr= $webs.Policies | select UserName,DisplayName #| Where-Object { (!($_.UserName -like "*AUTHORITY*")) -and 	(!($_.DisplayName -like "Search Crawling Account")) }
                
            foreach($us in $usr){
                $UserCount=$UserCount+1
            }
        }
        catch{
            $ErrorMessage = $_.Exception.Message
            write-host "catch block >>>> usr= webs.Policies >>>>> ErrorMessage :: " $ErrorMessage -ForegroundColor Red
        }

        $SPSCs = get-spsite -limit all -WebApplication $wa 
   
        foreach ($SPSC in $SPSCs){
            $SPSCURL = $SPSC.url
	        $SCSize = $SCSize + ($SPSC.Usage.Storage)/1MB;  # Get size of site collection 

            $allWebs = $SPSC.allwebs    # Get the count of sites in a web application 

             if($allWebs.Count -gt 0){
                $run=1
                $SiteCount = $SiteCount + $allWebs.count
            
                foreach ($spweb in $allWebs){
                    $listColl = $spweb.Lists
                    foreach ($list in $listColl){                
                        if($list.BaseType -eq "GenericList" -and  $list.BaseTemplate -eq "GenericList")   {  # Process only list types
    	                    $ItemsColl = $list.Items
    	                    if ($ItemsColl -ne $null){
        	                    foreach ($item in $ItemsColl){
			                        $AttachmentCollection = $item.Attachments
			                        $folder = $spweb.GetFolder($attachmentCollection.UrlPrefix);
			                        foreach ($file in $folder.Files){
			                            $AttachmentCount++;                            # Get the attachment count
			                        }
    		                    }
    	                    }
                        }
                        elseif($list.BaseType -ne "DocumentLibrary" -and  $list.BaseTemplate -ne "DocumentLibrary"){  
                            $ListCount++;
                        } 
                        if($List -ne $null){
                            if($List.GetType().Name -eq "SPDocumentLibrary" -and -not $List.Hidden){
    	                        $ItemsColl = $List.Items
                                $DocLibraryCount++;	                        
    
    	                        if ($ItemsColl -ne $null){
                                    Try{
    		                            foreach ($item in $ItemsColl){
        
                                        #Write-Host 'SpDocuments -- item -- ' $item.File
    			                           

                                            $fileName=($item.File.Name).ToString()
                                            $extentions=$fileName.Split(".")
                                            if($extentions -ne $null -and $extentions -ne ''){
                                                $idx=[int]$extentions.Count
                                                $extention=$extentions[$idx-1]
                                                if( $extention -notcontains "aspx" -and $extention -ne $null -and $extention -ne ''){
                                                    $DocCount =$DocCount + 1;                          # Get the documents count
                                                    $DocSize = $DocSize + ($item.File).length/1MB      # Get the document size 
                                                    $VerCount = $VerCount + $item.File.Versions.Count  # Get the versions count  

                                                    $fileSizeByte = ($item.File).length
                                                    $fileSizeMB=$fileSizeByte/1048576
                                                    $fileSizeMB=[Math]::Round(($fileSizeMB),2)
                                                    if($FileSize.ContainsKey($extention)){
                                                        $integer=$FileSize.Get_Item($extention)
                                                        $SizeCount = $integer -as [int]
                                                        $SizeCount =$SizeCount+$fileSizeMB
                                                        $FileSize.Set_Item($extention, $SizeCount)
                                                        $Counts=$FileTypeCount.Get_Item($extention)
                                                        $c = $Counts -as [int]
                                                        $c = $c+1
                                                        $FileTypeCount.Set_Item($extention, $c)
                                                    }
                                                    else{
                                                        $FileSize.Add($extention, $fileSizeMB)
                                                        $newTypeCount=1
                                                        $FileTypeCount.Add($extention, $newTypeCount)
                                                    }
                                                                         
                                                    if($item.File.TimeCreated -ge $Test_Freq){
                                                        $TotalRecAddCount = $TotalRecAddCount + 1;
                                                        $tempData= $item.File | Select-Object -Property Name, DocumentLibrary, Web, Url, ServerRelativeUrl, ParentFolder, Title, Author, ModifiedBy, TimeCreated, TimeLastModified, Length, UniqueId
                                                        $tempStr = $tempData | ForEach-Object { 'SPDocAndPages~REC ADDED~' + $_.Name + '~!~' + $_.DocumentLibrary + '~!~' + $_.Web + '~!~' + $_.Url + '~!~' + $_.ServerRelativeUrl + '~!~' + $_.ParentFolder + '~!~' + $_.Title + '~!~' + $_.Author + '~!~' + $_.ModifiedBy + '~!~' + $_.TimeCreated + '~!~' + $_.TimeLastModified + '~!~' + $_.Length + '~!~' + $_.UniqueId }
                                                        if($TotalRecAddCount -le $rptTopNDD){
                                                            Write-Host $tempStr
                                                        }
                                                        if($writecsv){
                                                            WriteToCSV -fileName $RecAddedFileName -data $tempData    
                                                        }
                                                    }

                                                    if($item.File.TimeLastModified -ge $Test_Freq -and $item.File.TimeCreated -ne $item.File.TimeLastModified){
                                                        $TotalRecUpdCount = $TotalRecUpdCount + 1;
                                                        $tempData= $item.File | Select-Object -Property Name, DocumentLibrary, Web, Url, ServerRelativeUrl, ParentFolder, Title, Author, ModifiedBy, TimeCreated, TimeLastModified, Length, UniqueId
                                                        $tempStr = $tempData | ForEach-Object { 'SPDocAndPages~REC UPDATED~' + $_.Name + '~!~' + $_.DocumentLibrary + '~!~' + $_.Web + '~!~' + $_.Url + '~!~' + $_.ServerRelativeUrl + '~!~' + $_.ParentFolder + '~!~' + $_.Title + '~!~' + $_.Author + '~!~' + $_.ModifiedBy + '~!~' + $_.TimeCreated + '~!~' + $_.TimeLastModified + '~!~' + $_.Length + '~!~' + $_.UniqueId }
                                                        if($TotalRecUpdCount -le $rptTopNDD){
                                                            Write-Host $tempStr
                                                        }
                                                        if($writecsv){
                                                            WriteToCSV -fileName $RecUpdatedFileName -data $tempData    
                                                        }
                                                    }

                                                    if($item.File.TimeCreated -le $Dormant_Freq){
                                                        $TotalDormCount = $TotalDormCount + 1;
                                                        $tempData= $item.File | Select-Object -Property Name, DocumentLibrary, Web, Url, ServerRelativeUrl, ParentFolder, Title, Author, ModifiedBy, TimeCreated, TimeLastModified, Length, UniqueId
                                                        $tempStr = $tempData | ForEach-Object { 'SPDocAndPages~IN_ACTIVE~' + $_.Name + '~!~' + $_.DocumentLibrary + '~!~' + $_.Web + '~!~' + $_.Url + '~!~' + $_.ServerRelativeUrl + '~!~' + $_.ParentFolder + '~!~' + $_.Title + '~!~' + $_.Author + '~!~' + $_.ModifiedBy + '~!~' + $_.TimeCreated + '~!~' + $_.TimeLastModified + '~!~' + $_.Length + '~!~' + $_.UniqueId }
                                                        if($TotalDormCount -le $rptTopNDD){
                                                            Write-Host $tempStr
                                                        }
                                                        if($writecsv){
                                                            WriteToCSV -fileName $DormantFileName -data $tempData
                                                        }
                                                    }
                                                } 
                                            }                                     
    		                            }
                                    }Catch{
                                        Write-Host "catch block >>> Error Occured while processing file types and document counts >>>>> " $_.Exception.Message
                                    }
    	                        }
                            }
                        }
                    }

                }
                if($spweb -ne $null){
                    $spweb.dispose()
                }
            Write-Host 'Documents --->>> ' $DocLibraryCount ' -- ' $DocCount ' -- ' $DocSize ' -- ' $VerCount

            #Below function is to return the Size of the Site and it's Sub-sites in MB.
            function GetWebSizes ($StartWeb){
                $web = Get-SPWeb $StartWeb
                [long]$total = 0
                $total += GetWebSize -Web $web
                $total += GetSubWebSizes -Web $web
                $totalInMb = ($total/1024)/1024
                $totalInMb = "{0:N4}" -f $totalInMb
                $web.Dispose()
                $totalInMb = [Math]::Round($totalInMb,4)
                #write-host $StartWeb "which is" $totalInMb "MB"
                return $totalInMb
            }

            #Below function is to get the Size of the Site.
            function GetWebSize ($Web){
    	        [long]$subtotal = 0
    	        foreach ($folder in $Web.Folders){
    		        $subtotal += GetFolderSize -Folder $folder
    	        }
                return $subtotal
            }

            #Below function is to get the Size of the SubSites under the site.
            function GetSubWebSizes ($Web){
                [long]$subtotal = 0
    	        foreach ($subweb in $Web.GetSubwebsForCurrentUser()){
    		        [long]$webtotal = 0
    		        foreach ($folder in $subweb.Folders){
                       $webtotal += GetFolderSize -Folder $folder
    		        }
    		        $subtotal += $webtotal
    		        $subtotal += GetSubWebSizes -Web $subweb
    	        }
                return $subtotal
            }

            #Below function to Get the Folder size of the SubWebSizes.
            function GetFolderSize ($Folder){
                [long]$folderSize = 0  
                foreach ($file in $Folder.Files){
    		        $folderSize += $file.Length;
    	        }
                foreach ($fd in $Folder.SubFolders){
    		        $folderSize += GetFolderSize -Folder $fd
    	        }
                return $folderSize
            }

            try{
                if($SPSCURL -ne $null){
                    $SiteSize += GetWebSizes -StartWeb $SPSCURL
                }
            }catch{
                Write-Host "catch block >>> Error Occured while assigning site size >>>>> " $_.Exception.Message

            }
        }
    }


    # Calculate the Average Document per document library and average document size 
    try { $AvgDocPerDocLibrary = $DocCount/$DocLibraryCount } catch { $AvgDocPerDocLibrary=0 }
    try { $AvgSizeofDocument = $DocSize / $DocCount  } catch { $AvgSizeofDocument=0  }

    # Get the Totals 
    $TotalListCount = $TotalListCount + $ListCount        
    $TotalDocLibraryCount =$TotalDocLibraryCount + $DocLibraryCount
    $TotalDocCount = $TotalDocCount + $DocCount
    $TotalUserCount = $TotalUserCount + $UserCount
    $TotalSCCount = $TotalSCCount + $SCCount
    $TotalSiteCount = $TotalSiteCount + $SiteCount
    $TotalDocSize = $TotalDocSize + $DocSize 
    $TotalAttachments = $TotalAttachments + $AttachmentCount
    $TotalSiteCollSize=$TotalSiteCollSize + $SCSize
    $TotalVerCount =$TotalVerCount+$VerCount;
    $TotalSiteSize = $TotalSiteSize +$SiteSize;

    # Rounding the values to 4 decimals 
    $SCSize=[Math]::Round($SCSize,4) 
    $DocSize=[Math]::Round($DocSize,4) 
    $AvgDocPerDocLibrary=[Math]::Round($AvgDocPerDocLibrary,4)


#    if($run -eq 1){
        Write-Host  "$($webs.Name)|$ListCount|$DocLibraryCount|$DocCount|$UserCount|$SCCount|$SiteCount|$DocSize|$VerCount|$AvgDocPerDocLibrary|$AttachmentCount|$SCSize|$ContentDBCount|$WebAppConentDBName"
 #   }
    if(($run -eq 0) -and ($SCCount -gt 0)){
        Write-Host 'inside SCCount -gt 0'
        if($ListNotAccess.Length -le 0){
            $ListNotAccess=$webs.Name
        }
        else{
            $ListNotAccess=$ListNotAccess+" ,"+$webs.Name
        }
    }
    elseif(($SCCount -eq 0)){
        Write-Host 'inside SCCount -eq 0'
        if($NoSitesCoAvailable.Length -le 0){
            $NoSitesCoAvailable=$webs.Name
        }
        else{
            $NoSitesCoAvailable=$NoSitesCoAvailable+" ,"+$webs.Name
        }
    }
    $UserCount=$null;
}#end of try
    finally{

        try
        {
            if($SPSC -ne $null)
            {
                $SPSC.Dispose();
            }
        }
        catch
        {
             $ErrorMessage = $_.Exception.Message
             write-host "catch block >>> foreach(webs in webApp) ErrorMessage ::" $ErrorMessage -ForegroundColor Red
        }

    }
}# end of loop

# Rounding the Total values to 4 decimals 
if($TotalDocCount -ne 0){
    $TotAvgDocPerDocLibrary = [Math]::Round($TotalDocCount/$TotalDocLibraryCount,4) 
}
$TotalDocSize = [Math]::Round($TotalDocSize,4) 
$TotalSiteCollSize = [Math]::Round($TotalSiteCollSize,4)

Write-host  "Total $TotalListCount|$TotalDocLibraryCount|$TotalDocCount|$TotalUserCount|$TotalSCCount|$TotalSiteCount|$TotalDocSize|$TotalVerCount|$TotAvgDocPerDocLibrary|$TotalAttachments|$TotalSiteCollSize|$SiteSize|$TotalRecAddCount|$TotalRecUpdCount|$TotalDormCount"

if($ListNotAccess.Length -gt 0){
    Write-Host "User := " $USER_INPUT " does not have required access to the following web application(s) - " $ListNotAccess
}

if($NoSitesCoAvailable.Length -gt 0){
    Write-Host "User := " $USER_INPUT " No SiteCollection(s) for the following web application(s) - " $NoSitesCoAvailable
}

$TotalFilesSize=0
          
foreach ($h in $FileTypeCount.GetEnumerator()){
    $fileType=$h.Name
    $FileCount=$h.Value
    $Size=$FileSize.Get_Item($fileType)
    $TotalFilesSize=$TotalFilesSize+$Size

    Write-Host 'FileTypeTest~' $("."+$fileType) '~' $FileCount '~' $Size
}

write-host "FileSizeMB~"$TotalFilesSize