﻿
Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Applications = Get-XAApplication -EA 0 | sort-object FolderPath, DisplayName 
if($? -and $Applications)
{
	foreach($Application in $Applications)
	{
		$AppServerInfoResults = $False
		$AppServerInfo = get-XAApplicationReport -BrowserName $Application.BrowserName -EA 0
		If( $? )
		{
			$AppServerInfoResults = $True
		}
		$streamedapp = $False
		If($Application.ApplicationType -Contains "streamedtoclient" -or $Application.ApplicationType -Contains "streamedtoserver")
		{
			$streamedapp = $True
		}
		#name properties starts
		Write-Host "#====name properties starts====#"
		Write-Host "Prelaunch : " $AppServerInfo.PreLaunch
		Write-Host "Display name : "  $AppServerInfo.DisplayName
		Write-Host "Application name : " $AppServerInfo.BrowserName
		if($AppServerInfo.Enabled -eq "True")
		{
			Write-Host "Disable application : false"
		}
		else
		{
			Write-Host "Disable application : true"
		}
		Write-Host "Hide disabled application: " $AppServerInfo.HideWhenDisabled
		Write-Host "Application description: " $AppServerInfo.Description
		
		# name properties ends
		Write-Host "#====name properties ends====#"
		
		
		#type properties starts
		Write-Host "#====type properties starts====#"
		
		Write-Host "Application Type: " $AppServerInfo.ApplicationType
		Write-Host "Folder path: " $AppServerInfo.FolderPath
		Write-Host "Content Address: " $AppServerInfo.ContentAddress
		
		#if a streamed app
		if($streamedapp)
		{
				Write-Host "Citrix streaming application profile address: " $AppServerInfo.ProfileLocation
				Write-Host "Application to launch from the Citrix streaming application profile: " $AppServerInfo.ProfileProgramName
				Write-Host "Extra command line parameters: " $AppServerInfo.ProfileProgramArguments
				#if streamed, Offline access properties
				If($AppServerInfo.OfflineAccessAllowed)
				{
					Write-Host "Enable offline access: " $AppServerInfo.OfflineAccessAllowed
				}
				If($AppServerInfo.CachingOption)
				{
					Write-Host "Cache preference: " $AppServerInfo.CachingOption
				}		
		}
		#type properties ends
		Write-Host "#====type properties ends====#"
		
		
		#location properties starts
		Write-Host "#====location properties starts====#"
		If(!$streamedapp)
		{
			Write-Host "Command line: " $AppServerInfo.CommandLineExecutable
			Write-Host "Working directory: " $AppServerInfo.WorkingDirectory
		}
		#location properties ends
		Write-Host "#====location properties ends====#"
		
		#servers properties starts
		Write-Host "#====servers properties starts====#"
			
		If(!$streamedapp)
		{	
			If($AppServerInfoResults)
			{
				Write-Host -NoNewline "Servers:"
				Write-Host $AppServerInfo.ServerNames -Separator ","
				
				Write-Host -NoNewline "Workergroups:"
				Write-Host $AppServerInfo.WorkerGroupNames -Separator ","
			}
			else
			{
				Write-Host "Servers: None"
				Write-Host "Workergroups: None"
			}
		}
		#servers properties ends
		Write-Host "#====servers properties ends====#"
		
		#users properties starts
		Write-Host "#====users properties starts====#"
		
		If($Application.AnonymousConnectionsAllowed)
		{
			Write-Host "Allow anonymous users: " $Application.AnonymousConnectionsAllowed
		}
		Else
		{
			If($AppServerInfoResults)
			{
				Write-Host -NoNewline "Users:"
				Write-Host $AppServerInfo.Accounts -Separator ","
			}
			else
			{
				Write-Host "Users: None"
			}
		}
		#users properties ends
		Write-Host "#====users properties ends====#"
		
		#shortcut presentation properties starts
		Write-Host "#====shortcut presentation properties starts====#"
		
		Write-Host "Client application folder: " $Application.ClientFolder
		If($Application.AddToClientStartMenu)
		{
			Write-Host "Add to client's start menu: " $Application.AddToClientStartMenu
		}
		If($Application.StartMenuFolder)
		{
			Write-Host "Start menu folder: " $Application.StartMenuFolder
		}
		If($Application.AddToClientDesktop)
		{
			Write-Host "Add shortcut to the client's desktop: " $Application.AddToClientDesktop
		}
		#shortcut presentation properties ends
		Write-Host "#====#shortcut presentation properties ends====#"
		
		#access control properties starts
		Write-Host "#====access control properties starts====#"
		
		If($Application.ConnectionsThroughAccessGatewayAllowed)
		{
			Write-Host "Allow connections made through AGAE: " $Application.ConnectionsThroughAccessGatewayAllowed
		}
		If($Application.OtherConnectionsAllowed)
		{
			Write-Host "Any connection: " $Application.OtherConnectionsAllowed
		}
		If($Application.AccessSessionConditionsEnabled)
		{
			Write-Host "Any connection that meets any of the following filters: " $Application.AccessSessionConditionsEnabled
			Write-Host -NoNewline "Access Gateway Filters:"
			Write-Host $Application.AccessSessionConditions
		}
		
		#access control properties ends
		Write-Host "#====access control properties ends====#"
		
		#content redirection properties starts
		Write-Host "#====content redirection properties starts====#"
		If($AppServerInfoResults)
		{
			If($AppServerInfo.FileTypes)
			{
				Write-Host -NoNewline "File type associations:"
				Write-Host $AppServerInfo.FileTypes
			}
			else
			{
				Write-Host "File type associations: 0 file type associations(s)"
			}
			
		}

		#if streamed app, Alternate profiles
		If($streamedapp)
		{
			If($Application.AlternateProfiles)
			{
				Write-Host "Primary application profile location: " $Application.AlternateProfiles
			}
		
			#if streamed app, User privileges properties
			If($Application.RunAsLeastPrivilegedUser)
			{
				Write-Host "Run application as a least-privileged user account: " $Application.RunAsLeastPrivilegedUser
			}
		}
		#content redirection properties ends
		Write-Host "#====content redirection properties ends====#"
		
		#limits properties starts
		Write-Host "#====limits properties starts====#"
		
		Write-Host "Limit instances allowed to run in server farm: " -NoNewLine
		
		If($Application.InstanceLimit -eq -1)
		{
			Write-Host "No limit set"
		}
		Else
		{
			Write-Host $Application.InstanceLimit
		}
		
		Write-Host "Allow only one instance of application for each user: " -NoNewLine
	
		If ($Application.MultipleInstancesPerUserAllowed) 
		{
			Write-Host "False"
		} 
		Else
		{
			Write-Host "True"
		}
		
		If($Application.CpuPriorityLevel)
		{
			Write-Host "Application importance: " $Application.CpuPriorityLevel
		}
		
		#limits properties ends
		Write-Host "#====limits properties ends====#"
		
		#client options properties starts
		Write-Host "#====client options properties starts====#"
		
		If($Application.AudioRequired)
		{
			Write-Host "Enable legacy audio: " $Application.AudioRequired
		}
		If($Application.AudioType)
		{
			Write-Host "Minimum requirement: " $Application.AudioType
		}
		If($Application.SslConnectionEnable)
		{
			Write-Host "Enable SSL and TLS protocols: " $Application.SslConnectionEnabled
		}
		If($Application.EncryptionLevel)
		{
			Write-Host "Encryption: " $Application.EncryptionLevel
		}
		If($Application.EncryptionRequire)
		{
			Write-Host "Minimum requirement: " $Application.EncryptionRequired
		}
	
		Write-Host "Start this application without waiting for printers to be created: " -NoNewLine
		If ($Application.WaitOnPrinterCreation) 
		{
			Write-Host "False"
		} 
		Else
		{
			Write-Host "True"
		}
		#client options properties ends
		Write-Host "#====client options properties ends====#"
		
		#appearance properties starts
		Write-Host "#====appearance properties starts====#"
		
		If($Application.WindowType)
		{
			Write-Host "Session window size: " $Application.WindowType
		}
		If($Application.ColorDepth)
		{
			Write-Host "Maximum color quality: " $Application.ColorDepth
		}
		If($Application.TitleBarHidden)
		{
			Write-Host "Hide application title bar: " $Application.TitleBarHidden
		}
		If($Application.MaximizedOnStartup)
		{
			Write-Host "Maximize application at startup: " $Application.MaximizedOnStartup
		}
		#appearance properties ends
		Write-Host "#====appearance properties ends====#"
	}
}
else
{
	Write-Host "Does not exists"
}
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands

