﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

$TestInputs=$args
$reportingname=$TestInputs[0]
$username=$TestInputs[1]
$password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxyCrdlserver=$TestInputs[3].ToString().Split('#')
$proxyUser=$proxyCrdlserver[0]
$proxyPass=Eg-O365Dcr -EncStr $proxyCrdlserver[1]
$proxyserverip=$proxyCrdlserver[2]
$inputRptDat=$TestInputs[4]
$proxyserver=$proxyserver='http://'+$proxyserverip

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver
$azureVal=Eg-GetAzureEnv -UserName $username -subject 'O365_Graph'
$azureEnvArr=$azureVal.Split(',')

$rptPath=$egurkhaPath+'\agent\SBO\'+$reportingname
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

$WriteLog=$true
$LogFile = $rptPath+"\sboreports.log"
$LogFile1 = $rptPath+"\sboreports1.log"
$isFrstTimLog=$true

# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)

	[string]$date = Get-Date -Format G
	
    if ($WriteLog) {
       ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append } 

    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }

}

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath
        
    )

    Process
    {
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($Resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $query = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$query = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
        $query=$query.Replace('ï»¿','')
        $query=$query.Replace(' ','')

        $resultarray = ConvertFrom-Csv -InputObject $query
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json

        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){  
            $reports.Usage[$i] |Export-Csv $filePath -Encoding $encTyp -Append -NoTypeInformation -Force
        } 
    }
}

Write-Log ".........Started Running the Script........."
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$deviceusagecsv = $rptPath+'\DeviceUsagereport'+$timenow+'.csv'
try{
$authString=$azureEnvArr[0]+$domain
$Resource=$azureEnvArr[1]
$msGraphPath=$egurkhaPath+"\agent\O365\MsGraph"
$keyFileNam = '\GraphDetailsKey.dat'

$unProtPath= $msGraphPath+'\GraphDetails.dat'
$kvalue= Get-Content -Path $msGraphPath$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'

$SkypeInput=$msGraphPath+"\GraphDetails.txt"
$GetInput = Get-Content -Path $SkypeInput
}catch{
    Write-Log "File not found. The $GetInput location does not contain GraphDetails "
}
$flag=$false

    foreach($inp in $GetInput){
        if($inp.StartsWith('[') -and $inp.Contains($domain)){
            $flag=$true
        }
        if($flag){
            if($inp.Contains("client_id")){
                $appId =$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("client_secret")){
                $appSecret =$inp.ToString().Substring($inp.IndexOf('~')+1)
                $flag=$false
            }
            if($inp.Contains("TenantName")){
                $tenantID=$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("Authority")){
                $authString = $inp.ToString().Substring($inp.IndexOf('~')+1)
                $authString=$authString+$domain
            }
            if($inp.Contains("Resource")){
                $Resource =$inp.ToString().Substring($inp.IndexOf('~')+1)
                $flag=$false
            }
        }
    }

#$sysDate = (Get-Date).AddDays($ReportRefreshDate).ToString("yyyy-MM-dd")
#$sysDate = (Get-Date).AddDays(-2).ToString("yyyy-MM-dd")
$path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $path
<#
$actvtcntsurl = "https://graph.microsoft.com/v1.0/reports/getSkypeForBusinessActivityCounts(period='D7')"
Eg-InvokeUrl -Url $actvtcntsurl -filePath $activecntcsv
try{
$SkyActcnt= import-csv $activecntcsv -Encoding $encTyp
}catch{
Write-Log "File not found. The $reportingname location does not contain Activecount report"
}
    $Totpeertopeercnt = 0
    $Totorganizedcnt = 0
    $TotParticipatedcnt = 0

    foreach($skypeActivecnt in $SkyActcnt){
        if($skypeActivecnt.ReportDate -eq $inputRptDat){
            $Totpeertopeercnt += $skypeActivecnt.'Peer-to-peer'
            $Totorganizedcnt += $skypeActivecnt.Organized
            $TotParticipatedcnt += $skypeActivecnt.Participated
        }
    }
#>
$devicusgeurl = $azureEnvArr[2]+"reports/getSkypeForBusinessDeviceUsageDistributionUserCounts(period='D7')"
Eg-InvokeUrl -Url $devicusgeurl -filePath $deviceusagecsv
[System.GC]::GetTotalMemory($true) | out-null
try{
    $SkyDevUsg= import-csv $deviceusagecsv -Encoding $encTyp
    Write-Log "created the deviceusagecsv file and processing"
}catch{
    Write-Log "File not found. The $reportingname location does not contain deviceusage report "
}

<#
$usrdetilurl = "https://graph.microsoft.com/v1.0/reports/getSkypeForBusinessActivityUserDetail(Date=$inputRptDat)"   #Date=$sysDate
Eg-InvokeUrl -Url $usrdetilurl -filePath $userdetilcsv
Write-Log ("Eg-InvokeUrl  usrdetilurl>>>>>" + $usrdetilurl + "<<<<<" )

try{
$SkyUsrDetail= import-csv $userdetilcsv -Encoding $encTyp
}catch{
	Write-Log "File not found. The $reportingname location does not contain userdetial report "
}

    $peertopimcnt = 0
    $peertopAudcnt = 0
    $peertopAudmincnt = 0
    $peertopvidcnt = 0
    $peertopvidmincnt = 0
    $peertopAppcnt = 0
    $peertopFletracnt = 0

    $orgconimcnt = 0
    $orgconAudvidcnt = 0
    $orgconAudvidmincnt = 0
    $orgconwebcnt = 0
    $orgcondial3partcnt = 0
    $orgcondialmscnt = 0
    $orgcondialinmsmincnt = 0
    $orgcondialoutmsmincnt = 0
    $orgconAppcnt = 0

    $parconimcnt = 0
    $parconAudvidcnt = 0
    $parconAudvidmincnt = 0
    $parconwebcnt = 0
    $parcondial3partcnt = 0
    $parconAppcnt = 0


    $SBOUsgReptHash = @{}

    $SBOUsgReptHash.Add('Peer-to-peerIM',@{})
    $SBOUsgReptHash.Add('Peer-to-peerAudio',@{})
    $SBOUsgReptHash.Add('Peer-to-peerAudioMinutes',@{})
    $SBOUsgReptHash.Add('Peer-to-peerVideo',@{})
    $SBOUsgReptHash.Add('Peer-to-peerVideoMinutes',@{})
    $SBOUsgReptHash.Add('Peer-to-peerAppSharing',@{})
    $SBOUsgReptHash.Add('Peer-to-peerFileTransfer',@{})

    $SBOUsgReptHash.Add('OrganizedConferenceIM',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceAudio/Video',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceAudio/VideoMinutes',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceWeb',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-in/out3rdParty',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-in/outMicrosoft',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-inMicrosoftMinutes',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-outMicrosoftMinutes',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceAppSharing',@{})

    $SBOUsgReptHash.Add('ParticipatedConferenceIM',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceAudio/Video',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceAudio/VideoMinutes',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceWeb',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceDial-in/out3rdParty',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceAppSharing',@{})
    $reportDte=''
    $isTrue=$true
foreach($skypedetil in $SkyUsrDetail){ 
        #if($isTrue){
            $isTrue=$false
            $rptDat = $skypedetil.ReportRefreshDate
            $rplcCnt=$reportingname+'='+$inputRptDat
            $sboFilePath=$egurkhaPath+'/agent/SBO/'+$reportingname+'/SBODataFile.ini'
            if($rptDat -ne ''){    
                if(Test-Path $sboFilePath -PathType Leaf){
                    $val=''
                    Get-Content $sboFilePath | ForEach-Object{$rptVal=$_ -split '=';if($rptVal[0] -eq $reportingname){$val=$_}} 
                    if($val -ne ''){
                        (Get-Content $sboFilePath).replace($val,$rplcCnt) | Set-Content $sboFilePath
                    }
                }
            }
       # }
       
       $peertopimcnt += $skypedetil.'Peer-to-peerIMCount'
       $peertopAudcnt += $skypedetil.'Peer-to-peerAudioCount'
       $peertopAudmincnt += $skypedetil.'Peer-to-peerAudioMinutes'
       $peertopvidcnt += $skypedetil.'Peer-to-peerVideoCount'
       $peertopvidmincnt += $skypedetil.'Peer-to-peerVideoMinutes'
       $peertopAppcnt += $skypedetil.'Peer-to-peerAppSharingCount'
       $peertopFletracnt += $skypedetil.'Peer-to-peerFileTransferCount'

       $orgconimcnt += $skypedetil.'OrganizedConferenceIMCount'
       $orgconAudvidcnt += $skypedetil.'OrganizedConferenceAudio/VideoCount'
       $orgconAudvidmincnt += $skypedetil.'OrganizedConferenceAudio/VideoMinutes'
       $orgconwebcnt += $skypedetil.'OrganizedConferenceWebCount'
       $orgcondial3partcnt += $skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount'
       $orgcondialmscnt += $skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount'
       $orgcondialinmsmincnt += $skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes'
       $orgcondialoutmsmincnt += $skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes'
       $orgconAppcnt += $skypedetil.'OrganizedConferenceAppSharingCount'

       $parconimcnt += $skypedetil.ParticipatedConferenceIMCount
       $parconAudvidcnt += $skypedetil.'ParticipatedConferenceAudio/VideoCount'
       $parconAudvidmincnt += $skypedetil.'ParticipatedConferenceAudio/VideoMinutes'
       $parconwebcnt += $skypedetil.ParticipatedConferenceWebCount
       $parcondial3partcnt += $skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount'
       $parconAppcnt += $skypedetil.ParticipatedConferenceAppSharingCount

       $reportrefdte = $skypedetil.ReportRefreshDate
       $username = $skypedetil.UserPrincipalName
       $PeerLastActivityDate = $skypedetil.'Peer-to-peerLastActivityDate'
       $OrganizedConferenceLastActivityDate = $skypedetil.OrganizedConferenceLastActivityDate
       $ParticipatedConferenceLastActivityDate = $skypedetil.ParticipatedConferenceLastActivityDate
       $LastActivityDate = $skypedetil.LastActivityDate
       $IsDeleted = $skypedetil.IsDeleted
       $DeletedDate = $skypedetil.DeletedDate
       $AssignedProducts = $skypedetil.AssignedProducts

       if([int]$skypedetil.'Peer-to-peerIMCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerIMCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerIM'].Add($dd,[int]($skypedetil.'Peer-to-peerIMCount'))
       }
       if([int]$skypedetil.'Peer-to-peerAudioCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerAudioCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerAudio'].Add($dd,[int]($skypedetil.'Peer-to-peerAudioCount'))
       }
       if([int]$skypedetil.'Peer-to-peerAudioMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerAudioMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerAudioMinutes'].Add($dd,[int]($skypedetil.'Peer-to-peerAudioMinutes'))
       }
       if([int]$skypedetil.'Peer-to-peerVideoCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerVideoCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerVideo'].Add($dd,[int]($skypedetil.'Peer-to-peerVideoCount'))
       }
       if([int]$skypedetil.'Peer-to-peerVideoMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerVideoMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerVideoMinutes'].Add($dd,[int]($skypedetil.'Peer-to-peerVideoMinutes'))
       }
       if([int]$skypedetil.'Peer-to-peerAppSharingCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerAppSharingCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerAppSharing'].Add($dd,[int]($skypedetil.'Peer-to-peerAppSharingCount'))
       }
       if([int]$skypedetil.'Peer-to-peerFileTransferCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerFileTransferCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerFileTransfer'].Add($dd,[int]($skypedetil.'Peer-to-peerFileTransferCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceIMCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceIMCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceIM'].Add($dd,[int]($skypedetil.'OrganizedConferenceIMCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceAudio/VideoCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceAudio/VideoCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceAudio/Video'].Add($dd,[int]($skypedetil.'OrganizedConferenceAudio/VideoCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceAudio/VideoMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceAudio/VideoMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceAudio/VideoMinutes'].Add($dd,[int]($skypedetil.'OrganizedConferenceAudio/VideoMinutes'))
       }
       if([int]$skypedetil.'OrganizedConferenceWebCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceWebCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceWeb'].Add($dd,[int]($skypedetil.'OrganizedConferenceWebCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-in/out3rdParty'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-in/outMicrosoft'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-inMicrosoftMinutes'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-outMicrosoftMinutes'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes'))
       }
       if([int]$skypedetil.'OrganizedConferenceAppSharingCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceAppSharingCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceAppSharing'].Add($dd,[int]($skypedetil.'OrganizedConferenceAppSharingCount'))
       }
       if([int]$skypedetil.ParticipatedConferenceIMCount -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.ParticipatedConferenceIMCount+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceIM'].Add($dd,[int]($skypedetil.ParticipatedConferenceIMCount))
       }
       if([int]$skypedetil.'ParticipatedConferenceAudio/VideoCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'ParticipatedConferenceAudio/VideoCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceAudio/Video'].Add($dd,[int]($skypedetil.'ParticipatedConferenceAudio/VideoCount'))
       }
       if([int]$skypedetil.'ParticipatedConferenceAudio/VideoMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'ParticipatedConferenceAudio/VideoMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceAudio/VideoMinutes'].Add($dd,[int]($skypedetil.'ParticipatedConferenceAudio/VideoMinutes'))
       }
       if([int]$skypedetil.ParticipatedConferenceWebCount -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.ParticipatedConferenceWebCount+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceWeb'].Add($dd,[int]($skypedetil.ParticipatedConferenceWebCount))
       }
       if([int]$skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceDial-in/out3rdParty'].Add($dd,[int]($skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount'))
       }
       if([int]$skypedetil.ParticipatedConferenceAppSharingCount -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.ParticipatedConferenceAppSharingCount+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceAppSharing'].Add($dd,[int]($skypedetil.ParticipatedConferenceAppSharingCount))
       }

}
    #Write-Host 'ReportDate:'$reportDte
    Write-Host '-------------Peet to Peer Sessions-------------'
    Write-Host 'peermeasure~' $peertopimcnt'~'$peertopAudcnt'~'$peertopAudmincnt'~'$peertopvidcnt'~'$peertopvidmincnt'~'$peertopAppcnt'~'$peertopFletracnt'~'$Totpeertopeercnt

        foreach($peer in $SBOUsgReptHash['Peer-to-peerIM'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#peerInstantsMsgsdd~!~'$peer.Key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerAudio'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerAudiocalldd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerAudioMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerAudiomindd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerVideo'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peervideocalldd~!~'$peer.Key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerVideoMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peervideomindd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerAppSharing'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerAppsharedd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerFileTransfer'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerfiletransdd~!~'$peer.key
	    }

    Write-Host '-------------Organized Confereneces-------------'
    Write-Host 'orgconmeasures~' $orgconimcnt'~'$orgconAudvidcnt'~'$orgconAudvidmincnt'~'$orgconwebcnt'~'$orgcondial3partcnt'~'$orgcondialmscnt'~'$orgcondialinmsmincnt'~'$orgcondialoutmsmincnt'~'$orgconAppcnt'~'$Totorganizedcnt

        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceIM'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgInstantsMsgsdd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceAudio/Video'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgAudiovideocalldd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceAudio/VideoMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgAudiovideomindd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceWeb'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgwebdd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-in/out3rdParty'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialinout3dd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-in/outMicrosoft'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialinoutmsdd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-inMicrosoftMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialinmsmindd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-outMicrosoftMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialoutmsmindd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceAppSharing'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgAppsharedd~!~'$orgcon.key
	    }

    Write-Host '-------------participated Confereneces-------------'
    Write-Host 'parconmeasures~' $parconimcnt'~'$parconAudvidcnt'~'$parconAudvidmincnt'~'$parconwebcnt'~'$parcondial3partcnt'~'$parconAppcnt'~'$TotParticipatedcnt
        
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceIM'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parInstantsMsgsdd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceAudio/Video'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parAudiovideocalldd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceAudio/VideoMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parAudiovideomindd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceWeb'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parwebdd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceDial-in/out3rdParty'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parDialinout3dd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceAppSharing'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parAppsharedd~!~'$parcon.key
	    }
      $SBOUsgReptHash =$null
  #>  
    Write-Host '-------------Device Usage-------------'
   
   foreach($dev in $SkyDevUsg){
        $isFlag=$false
        $dev.PSObject.Properties | ForEach-Object{
            if($_.Name -eq 'ReportPeriod'){break}
            
            if($isFlag){
                $write='deviceinfo~ '+$_.Name+' ~ '+$_.Value
                Write-Host $write  
            }

            if($_.Name -eq 'ReportRefreshDate'){$isFlag=$true}
        }
  }

<#

    if(Test-Path -Path $SkypeInput){
    Write-Log (" inside SkypeInput csv remove path" )
        Remove-Item $SkypeInput -Force
    }

    if($Error){ Write-Log $Error ;$Error.Clear()}
     
    if(Test-Path -Path $userdetilcsv){
    Write-Log (" inside userdetails csv remove path" )
        Remove-Item $userdetilcsv -Force
    }
    
    if($Error){ Write-Log $Error ;$Error.Clear()}
    
    if(Test-Path -Path $activecntcsv){
    Write-Log (" inside activecntcsv csv remove path" )
        Remove-Item $activecntcsv -Force
    }
  #>  
    if($Error){ Write-Log 'Error.... $Error' ;$Error.Clear()}
    
    if(Test-Path -Path $deviceusagecsv){
        Write-Log (" Removing the  deviceusagecsv file" )
        Remove-Item $deviceusagecsv -Force
    }
    if($Error){ Write-Log ('Error.... '+$Error ) ;$Error.Clear()} 
    Write-Log (".............Script completed.............." )
    [System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUZ9MoEcdq5g8IaXMpdMsSbOTp
# CKSgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFJc2I0j8KAIE9Ot0
# ej/Cg6mXZtatMA0GCSqGSIb3DQEBAQUABIICAAbIJLH42rk8aRHssLzF/L4Y0Ow3
# UIDE3kGOxVdMGvIb/pE8xeN4ChvjrMt/MXa/Rn1kt8pE4uRUPHZi0VviKa3aB52N
# tFK/h1fVjQTj4wGsmTDBl2WNsvdWwKcll1YqgA0ftM4zcMGIzHr8ZFTXD1NT7av6
# r44LXvTgVX0YSQ1nz6TZM1DrQ1q85ZRpxtU36sajUHwm2o3YCHSASXiTrhr8U0Ct
# JF8to8UfQvKX35PBKVNvB7DMBI0tmm+rqQlgeP0YtOxLxrQLT0HUfcKU25zXZqAH
# fhDwLF7KX77MUpWysoUpU454DSobX4bB5OZR8ziD2FnDIcw0A2pwU8b92efD68ka
# fP5jdARe2G8OHW91GRNfpmluOsgrDvBdplkqvGDX9eSqvr6z+qKxwuBO2TApqdan
# lk09B6qadV/pO+O2vaOIHG8Spaa3LUm+9PsvAZO4KU23i9msiI8GMpijH1FdlAfA
# +6/U6tiHjtacEkYiV7Lw9xWCMJb99iMNCpJZP/Z9ctPG916ijPRTEk0ZG9W5Rv+q
# 9mXPjTBadksRol1VtjS3MxuHa73o/qIwvHF3svEF/JWyocVIpy9wY4DTLl4aHiS2
# 1s23KWM5mG2HFdRPcm5vufgLNS+DR6KqVz7equGa/v/dX/XD86XWzcWYcVnPtRw5
# ArjBE+86uGfc2bn6oYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM2NTBaMC8GCSqGSIb3DQEJBDEiBCDTUE/EKQM6bYIk58nbPB4+o6PB
# TTNrdftu+zYzfIasRjANBgkqhkiG9w0BAQEFAASCAQCxyXqfEFginknQjQ9/AS/l
# Z1GQ/bmDTIQr83ynzetmlMMBONyHobJX/4Zn+ULc+m4t7AaG44RcUYgM9XIYRnnC
# 0AsoygQdNE+cm/DKweRLyuwTpDqF8ocJQgMctm86VIJ9aqxgeYci5zs1X6ZZiQLE
# hnbfQC9NVNT77ZPAxX3sFb6Yq8j9FeLvMuuq2ETtctI+fDGg/ltd7nfYHSLCccH3
# QceSoU8QLBkHbGzif/tnqMiU3Psj7IjkD0mkTEWR/WVvDuyVrtUnGYXgP17xynSO
# c1/Du3hk0RxL5JOK5oPNFUaGRgis0UhAYMW6Lir6JvqgOp7iue4ngkId1NGcntBM
# SIG # End signature block
