﻿#
#
clear
#Set LOG Location
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$logDir=$egurkhaPath+'\agent\O365'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$logFile=$logDir+'\O365_prerequisites.log'
#Remove-Item -Path $logFile

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$osNam='N/A';$csdVersion='N/A';$sysType='N/A'
Try{
    $os=[String](Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).Name
    $osNam=$os.Substring(0,$os.IndexOf('|')).Trim() #(Microsoft Windows 7 Professional |C:\Windows|\Device\Harddisk0\Partition2)
    $csdVersion=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).CSDVersion #(Service Pack 1)
    $sysType=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).OSArchitecture #(64-bit)
    Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
}Catch{Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType}
$stTim=Get-Date
O365-WriteLog -writString "******************************************** O365_setup_prerequisites ********************************************" -LogPath $logFile -ReportingName 'Script'
O365-WriteLog -writString "O365_setup_prerequisites started at $stTim" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString $osNam ' -- ' $csdVersion '--' $sysType -LogPath $logFile -ReportingName 'SYSTEM INFO'

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExistURP=$false
$isO365MailSR='false'
foreach($line in $lines){  
    if($isExistURP){
        if($line.StartsWith('Monitor_O365_Mail_Sender_Receiver')){
           $isO365MailSR=$line.Replace('Monitor_O365_Mail_Sender_Receiver=','')
        }
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExistURP=$true
    }
}

$tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
$iniContent=get-content -Path $tstIniPath
$lineStr=''
$isReadStrt=$false
$isMASupport=$false
foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('Modern_Auth_Supported=')){
        if($line -match 'true'){
            $isMASupport=$true
            $isReadStrt=$false
        }
    }
    if($line.StartsWith('[Modern_Auth_Support')){
        $isReadStrt=$true
    }
}

if($isMASupport){
    $certBasedRes=[system.windows.forms.messagebox]::show(("Connect to O365 using `"Modern Authentication`"?" -join "`n"),"O365_Prerequisites",'YesNo')
}else{
    $certBasedRes='No'
}

foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('CertBased_Scripts') -and $certBasedRes -eq 'Yes'){
        $lineStr=$line
        break
    }
    if($isReadStrt -and $line.StartsWith('CredBased_Scripts') -and $certBasedRes -eq 'No'){
        $lineStr=$line
        break
    }
    
    if($line.StartsWith('[O365_Setup_Prerequisites')){
        $isReadStrt=$true
    }
}
if($certBasedRes -eq 'Yes'){
    O365-WriteLog -writString "connect to O365 using Modern Authentication" -LogPath $logFile -ReportingName 'INFO'
    $lineStr=$lineStr.Replace('CertBased_Scripts=','')
}else{
    O365-WriteLog -writString "connect to O365 using Basic Authentication" -LogPath $logFile -ReportingName 'INFO'
    $lineStr=$lineStr.Replace('CredBased_Scripts=','')
}

$scriptArr=$lineStr.Split('~')
$scriptDir=$egurkhaPath+'\lib\'


$chkins=[ordered]@{}
foreach($obj in $scriptArr){
    $arr=$obj.Split('@')
    if($chkins[$arr[0]]){
        $val=$chkins[$arr[0]]+'~'+$arr[1]
        $chkins.Remove($arr[0])
        $chkins.add($arr[0],$val)
    }else{
        $chkins.Add($arr[0],$arr[1])
    }
}

foreach($key in $chkins.Keys){
    if($chkins[$key] -eq 'O365LimitAccessToMailFlowUsers.ps1'){
        if($isO365MailSR -eq 'true'){
            $res=[system.windows.forms.messagebox]::show(($key -join "`n"),"O365_Prerequisites",'YesNo')
        }
    }else{
        $res=[system.windows.forms.messagebox]::show(($key -join "`n"),"O365_Prerequisites",'YesNo')
    }
    
    if($res -eq 'Yes'){ 
        $scptArr=([String]$chkins[$key]).Split('~')
        foreach($script in $scptArr){
            $scptSrt=$scriptDir+$script

            if($certBasedRes -eq 'Yes' -and $script -match 'O365_Step2_ModulesDwnldnInstall.ps1'){
                Try{
                    Write-Host "$script has started to run..." -ForegroundColor Green
                    O365-WriteLog -writString "script has started to run..." -LogPath $logFile -ReportingName $script
                    & $scptSrt 'Yes'
                    Write-Host "$script ran successfully" -ForegroundColor Green
                    O365-WriteLog -writString "$script ran successfully" -LogPath $logFile -ReportingName $script
                }Catch{
                    Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                    O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                }

            }elseif($script -match 'SBONtwrkAssmnt.ps1'){
                $nwAssesTool=Get-Childitem "C:\*\Microsoft Skype for Business Network Assessment Tool"
                if($nwAssesTool -ne $null -and $nwAssesTool -ne ''){
                    $stTim4=Get-Date
                    O365-WriteLog -writString "******************************************** SBONtwrkAssmnt ********************************************" -LogPath $logFile -ReportingName 'Script'
                    O365-WriteLog -writString "SBONtwrkAssmnt started at $stTim4" -LogPath $logFile -ReportingName 'INFO'

                    Try{
                        Write-Host "$script has started to run..." -ForegroundColor Green
                        & $scptSrt
                        Write-Host "$script ran successfully" -ForegroundColor Green
                    }
                    Catch{
                        Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                        O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                    }
                    $edTim4=Get-Date
                    O365-WriteLog -writString "SBONtwrkAssmnt ended at $edTim4" -LogPath $logFile -ReportingName 'INFO'
                    O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

                }
            }
			elseif($script -match 'MTMCallQualityPrerequisites.ps1'){
                $nwAssesTool=Get-Childitem "C:\*\Microsoft Teams Network Assessment Tool"
                if($nwAssesTool -ne $null -and $nwAssesTool -ne ''){
                    $stTim4=Get-Date
                    O365-WriteLog -writString "******************************************** MTMCallQualityPrerequisites ********************************************" -LogPath $logFile -ReportingName 'Script'
                    O365-WriteLog -writString "MTMCallQualityPrerequisites started at $stTim4" -LogPath $logFile -ReportingName 'INFO'

                    Try{
                        Write-Host "$script has started to run..." -ForegroundColor Green
                        & $scptSrt
                        Write-Host "$script ran successfully" -ForegroundColor Green
                    }
                    Catch{
                        Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                        O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                    }
                    $edTim4=Get-Date
                    O365-WriteLog -writString "MTMCallQualityPrerequisites ended at $edTim4" -LogPath $logFile -ReportingName 'INFO'
                    O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

                }
            }
            elseif($script -match 'O365LimitAccessToMailFlowUsers.ps1'){
                if($isO365MailSR -eq 'true'){
                    Try{
                        Write-Host "$script has started to run..." -ForegroundColor Green
                        O365-WriteLog -writString "script has started to run..." -LogPath $logFile -ReportingName $script
                        & "$scptSrt"
                        Write-Host "$script ran successfully" -ForegroundColor Green
                        O365-WriteLog -writString "$script ran successfully" -LogPath $logFile -ReportingName $script
                    }
                    Catch{
                        Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                        O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                    }
                }
            }
			else{
                Try{
                    Write-Host "$script has started to run..." -ForegroundColor Green
                    O365-WriteLog -writString "script has started to run..." -LogPath $logFile -ReportingName $script
                    & "$scptSrt"
                    Write-Host "$script ran successfully" -ForegroundColor Green
                    O365-WriteLog -writString "$script ran successfully" -LogPath $logFile -ReportingName $script
                }
                Catch{
                    Write-Host "Exception occurred in $script - "$_.Exception.Message -ForegroundColor Red
                    O365-WriteLog -writString "Exception occurred in $script - "$_.Exception.Message -LogPath $logFile -ReportingName $script
                }
            }
        }
    }else{
        $msg=$key.Replace('?','')
        $str='you have cancelled the '+'"'+$msg+'"'+' script'
        Write-Host $str
        O365-WriteLog -writString $str -LogPath $logFile -ReportingName $script
    }
}
$edTim=Get-Date
O365-WriteLog -writString "O365_setup_prerequisites ended at $edTim" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'


# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUcYEyTUkqQGarvukOePskQ/yY
# q4Cggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhADyzT9Pf8SETOf8HxL
# IVfHMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwODMwMDAwMDAwWhcNMjMwODI5
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAC0UyaEGSS3d
# imxaHgXjrMnYnjeKsKYhIj9EyjE9ywwM33xT5ZRqdiX3Isk7nEIElPWCRN5u4oTo
# 7k5EGGktx3ZsrHpzf0siEEmEdDfygtNBlXYxLvlZab8HVrslWfexM+66XRCFK19P
# gSnudu0gC3XaxWbC6eAeWmgBTLRktDRpqbY9fj1d6REtuXxf4RNrN0MDT+kVDdt1
# BVTHDTlfGDbA6HAXR1Vc+khF8cv4RMJ8vvP3p6z05qFttPe3RMWPCC+d8hKtJI+2
# C3hBwdKChzJizkfq60Vrqqj+dEeBnrUYhUcYIIz6WeVYk72r/31a9SowYPuTzNCk
# tU59LF6Y2/bMPIpHeHhsBAvg2RMxDzH4TfzgKkGM8F8VDpTAKUXe8vlzzsNjJ4m+
# oeGi72Kj6if/M07iiT4kMEQV5Fg8BotKdIqx7a1Cf+aqpZq5+DAcFhPwo4uoKtSL
# AWY0aIACxRKSFqIHngiuc2t9n+vB/oM/rtlQNnnlt8E2hvC3yQl5+M/7sqzX4vI3
# BBv6ASmOsDaYOGrb90BA77kpxccgavKscb/UdmJ+yGZjMyuuUzjPpKpGxMG95S9A
# TieDVuDFi68taSY81PJVmxBD/MrBbfTZ9JBLS5F1s0ecKEr6OOY1PvLIry+8Trgn
# FUP5KT019GjiRV2GVCOBx9aBB9M+oTliMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFO4DbRcAswQlRBQO
# jKghXXiMBrikMA0GCSqGSIb3DQEBAQUABIICAGZCitKI7Pt/8MN2r5s6U7nj/WUs
# ZWv1cIuTFj4LtL1bqb10SG/tdD9CwEhYe+dta968ypyn/IsR1ylI+3ATWiGwnHJu
# kd3KTNN7wLQIi1GlLo4G2/PthRhGimJsjbC55VJ7fP+30kBfQTp3dVSOpoWO7qUZ
# M/G5jy2no5l/wOqSWrx8Lh/wyUZaUujaFIV9zvm2KQhzhTjYWhuI1jsXfSDVRYdP
# LPdDYX0DCe09LDwIJvrWjneOkQW1rw0N3eRpJ9A8HP4wT3cr0xYQIFf+DnDZlZwp
# YhLUmkK35+1i54o31YW1QzpZQA4h6V/nei4kuKAc9yvLv/ClGnP/V+6r/To6+guX
# S8NtqsxBpXKRl/Htqe/v/INd7ZGhULnSEQP7cM1IhJ3Yj1E2sy1gCpQLPOn2rI+n
# eFj5B3BkTbe/7LWUa8gESfNY4j6rGLPEbTE10WlKejYTEFa2ZASMRIqVNBAAcNKE
# JijI1pMAWIBfjZxb4Ppfv8sqM+nv+LnlladY4k97gpVGsbpDPICIngb1ePlYEO9b
# ruFDoiWcCub11iBR6hwR6xhNGRAusYRzlP9zVs5RiqnVCWjOioU1WJml9qmlHymm
# dS4jjG/4Q0XbhT3HbaWeBb+x3nYRTt/3cKpeAX2sPo3QJWHBkQPSXdfQSGVHy88G
# YitiI01pMFPsMn5CoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQA8s0/T3/EhEzn/B8SyFXxzANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxNTExNTQxNVowLwYJ
# KoZIhvcNAQkEMSIEIHriD9YgP8F0qSRs8Dad2kS/FxWljebSt0Q8rIRc+ZbHMA0G
# CSqGSIb3DQEBAQUABIICAEaeWEWXjjnAot285QUQ66zAQeTpUWEl+0HSCpB7EfNj
# bZ73nn6zgZI4H2sjlJ5a8Ta6q+RNclGNDF0IikmRF05r5jgIN3WRmmuZqAolTEzQ
# Sa3LaAGG5XUno1uWd/6b+/exL5V1CPR5fOdRLR5IA8Kxt7WkDaLkMo9rm259+9Im
# 2OmBGZsCmCC7hC91Kl8Mvm9NISssT/JjFZK/vSO+o6do0Dd8C88GcrBw2y/EL1Gi
# jbvSyGaGLbcpx2vQ9nJ9cGOLzojaA/1TsWPC5mexbOMR0ISOF4dacAGxokH5R+/e
# a60vmBm8lBUhOoIErh3xVMtMuVkjGgAOnNlH6NXjsw6WHIrPMKGfhmzv+F+IJ6Vr
# EvGA7zfbFxXWzc2tv2GPRmeCopKfd2QYqSxoQ2DVwroyoUF1ZM+dOxKyDNoB1KAZ
# PyW6u5UVc+QYukZhjLH/PJf1tB0UO5VF9GUKwrh0TLECd6jz/w0SNZMGHLyRrRQt
# ZlLlGXlSkokN5xBtNilG4QSo9zlpMJMaFRdlpS/+FVy0eookLLMlOcrl4lBEunoP
# dtfxmeNIcqmek7Mf/e57pKEzf/cthhe+Fsj60aTdCFMSZdnhgjEIVfAptQvg/mBz
# iOsRFok0U52T/Vfn9bOLa6nSAVLgUqCRiKBX2FVkfitUaDUbc/XAmewqLEWfyABi
# SIG # End signature block
