﻿#$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
#$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath=Split-Path -parent $MyInvocation.MyCommand.Definition

$isEnableCBA=$False
$TestInputs=$args
if($TestInputs[0] -eq 'Yes'){
    $isEnableCBA=$true
}

function Get-INIContent(){
    [CmdletBinding()]
    Param (
    [Parameter(Mandatory=$true, Position=1)]
    [String]$subject, 
    [Parameter(Mandatory=$true, Position=2)]
    [String]$appNam
    )
    Process
    {
        $appVal=''
        $hashAppVal=@{}
        $ischk=$false
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
        $iniContent=get-content -Path $tstIniPath
        $isFound=$false
        for($i=0;$i -lt $iniContent.Length;$i++ ){
            if($appNam -eq 'none'){
                if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                    $ischk=$true
                    #Write-Host '88888 ' $iniContent[$i]
                    $subNam=($iniContent[$i] -split '-')[1]
                    $val=$subNam.Substring(0,($subNam.length-1)).Trim()
                    $i++
                    $key=($iniContent[$i] -split '=')[1]
                    $hashAppVal.Add($key,$val)
                }
            }else{
                if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                    $i++
                    while($true){
                        try{
                            $iniArr=$iniContent[$i].Split('=')
                            if($appNam -eq $iniArr[0]){
                                $appVal=$iniArr[1]
                                $isFound=$true
                                break;    
                            }
                        }catch{$isFound=$true;break;}
                            $i++  
                    }
                }
                if($isFound){break;}
            }
        }
        if($ischk){
            return $hashAppVal
        }
        else{
            return $appVal
        }
    }
}
function Check-DotNETversion(){
    [CmdletBinding()]
    Param (
        [Parameter(Mandatory=$true, Position=1)]
        [String]$FolderName1, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$FolderName2,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$ReleaseNo
    )
    Process{
        $getPaths=Get-ChildItem -Path 'HKLM:SOFTWARE\Microsoft\NET Framework Setup\NDP' |select *
        foreach($path in $getPaths){
            if($path.Name.EndsWith($FolderName1)){
                $path1=$path.Name.Replace('HKEY_LOCAL_MACHINE\','HKLM:')
                $secndPaths=Get-ChildItem -Path $path1
                foreach($secPath in $secndPaths){
                    if($secPath.Name.EndsWith($FolderName2)){
                        $getProps=$secPath.Name.Replace('HKEY_LOCAL_MACHINE\','HKLM:')
                        if((Get-ItemProperty $getProps).Release -ge $ReleaseNo){
                            return $true
                        }
                        else{
                            return $false
                        }
                    }
                }
            }
        }
    }
}

Try{
    $os=[String](Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).Name
    $osNam=$os.Substring(0,$os.IndexOf('|')).Trim() #(Microsoft Windows 7 Professional |C:\Windows|\Device\Harddisk0\Partition2)
    $csdVersion=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).CSDVersion #(Service Pack 1)
    $sysType=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).OSArchitecture #(64-bit)
    Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
}Catch{
    $osNam=[String](Get-ComputerInfo).WindowsProductName
    $csdVersion=(Get-ComputerInfo).OsCSDVersion
    $sysType=(Get-ComputerInfo).OsType
    Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
}

#Set Download Location
$dwnld=Get-INIContent -subject 'Location' -appNam 'Download'
if($dwnld -ne 'none' -and (Test-Path $dwnld)){
    $DownloadLocation=$dwnld   
}else{
    $DownloadLocation = $env:USERPROFILE+'\downloads\O365\'
}
if(!(Test-Path -Path $DownloadLocation)){
    $null=New-Item -ItemType directory -Path $DownloadLocation
}
Write-Host 'Download Location - ' $DownloadLocation

#Set LOG Location
$lgf=Get-INIContent -subject 'Location' -appNam 'Log'
if($lgf -ne 'none' -and (Test-Path $lgf)){
    $logDir=$lgf   
}else{
	$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
	$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
    $logDir=$egurkhaPath+'\agent\O365'
}
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$logFile=$logDir+'\O365_prerequisites.log'
#Remove-Item -Path $logFile

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

function Unzip{
    param([string]$zipfile, [string]$outpath)
    #[System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
    $shell_app=new-object -com shell.application
    $zip_file = $shell_app.namespace($zipfile)
    $destination = $shell_app.namespace($outpath)
    $destination.Copyhere($zip_file.items())
}

function Chk-OSTypes(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$OSStr       
    )
    Process
    {
        if($OSStr -eq 'AllOS'){
            return $true
        }else{
            $chkOS=$false
            $osArr=$OSStr -split '!'
            foreach($osTyp in $osArr){           
                if($osTyp -match '#' -and $osTyp -notmatch '-'){
                    $osVerArr=$osTyp -split '#'
                    if($osNam -match $osVerArr[0] -and $osNam -match $osVerArr[1]){$chkOS=$true}
                }elseif($osTyp -match '#' -and $osTyp -match '-'){
                    $osVerArr=$osTyp -split '#'
                    $osHyArr=$osVerArr[1] -split '-'
                    if($osNam -match $osVerArr[0] -and $osNam -match $osHyArr[0] -and $csdVersion -match $osHyArr[1]){$chkOS=$true}
                }elseif($osTyp -notmatch '#' -and $osTyp -match '-'){
                    $osVerArr=$osTyp -split '-'
                    if($osNam -match $osVerArr[0] -and $csdVersion -match $osVerArr[1]){$chkOS=$true}
                }else{
                    if($osNam -match $osTyp){$chkOS=$true}
                }
                if($chkOS){
                    return $true
                }
            }
            return $false   
        }
    }
}

function Chk-Registry(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$RegStr       
    )
    Process
    {
        if($RegStr -eq 'NIL'){
            return $true
        }else{
            $regArr=$RegStr -split '#'
            $regValuesArr=$regArr[1] -split '!'
            $regValues=Get-ItemProperty -Path $regArr[0]
            foreach($regValue in $regValuesArr){
                $valArr=$regValue -split '-'
                $regStr=$valArr[0]
                $curval=[int]$regValues."$regStr"
                $val=[int]$valArr[1]
                if(!($curval -ge $val)){
                    return $true
                    break;
                }
            }
            return $false
        }
    }
}


function Proceed-Download(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$APPName, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$APPFile
    )
    Process
    {
        Try{
            if($APPFile -match '#'){
                $arr=$APPFile -split '#'
                $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
                $dest=$DownloadLocation+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($arr[0],$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Download started...' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading started' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $arr[0] -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Download completed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading completed' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Download not completed or failed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading not completed or failed' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }
                Unzip -zipfile $dest -outpath $DownloadLocation
                #$dest=$dest.Replace(".zip",$arr[1])
                #$installHash.Add($dest,$APPName)
            }else{
                $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
                $dest=$DownloadLocation+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($APPFile,$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Download started...' -ForegroundColor Green
                            O365-WriteLog -writString 'Download started...' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $APPFile -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Download completed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Download completed!' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Download not completed or failed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Download not completed or failed!' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }       
            }
        }Catch{
                Write-Host "Download Failed" $Exception.Message -ForegroundColor Red
        }
    }      
}

$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
if($chkWinrm -notmatch 'Basic=true'){
    Write-Host 'WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE...' -ForegroundColor Red
    O365-WriteLog -writString ("WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE..."+$chkWinrm) -LogPath $logFile -ReportingName 'ERROR'
    exit
}

$stTim2=Get-Date
O365-WriteLog -writString "******************************************** O365_Step2_ModulesDwnldnInstall ********************************************" -LogPath $logFile -ReportingName 'Script'
O365-WriteLog -writString "O365_Step2_ModulesDwnldnInstall started at $stTim2" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString $osNam ' -- ' $csdVersion '--' $sysType -LogPath $logFile -ReportingName 'SYSTEM INFO'
O365-WriteLog -writString $DownloadLocation -LogPath $logFile -ReportingName 'Download Location'

$preDwnldHash=[ordered]@{}
$installHash=[ordered]@{}
$moduleHash=[ordered]@{}

$options=@{}
$options=Get-INIContent -subject 'APPs' -appNam 'none'
$onames =$options.Keys
$chkBxStr=''
$isRunNetwrkAssmnt=$False
$cbaChkBxStr=''
######***GUI****#######
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")
$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button
$textbox1=New-Object System.Windows.Forms.TextBox
$label1=New-Object System.Windows.Forms.Label
$textbox2=New-Object System.Windows.Forms.TextBox
$label2=New-Object System.Windows.Forms.Label

$textbox3=New-Object System.Windows.Forms.TextBox
$label3=New-Object System.Windows.Forms.Label
$textbox4=New-Object System.Windows.Forms.TextBox
$label4=New-Object System.Windows.Forms.Label
$label5=New-Object System.Windows.Forms.Label

$O365DtlsLbl=New-Object System.Windows.Forms.Label
$O365UsrLbl=New-Object System.Windows.Forms.Label
$O365UsrTxtBx=New-Object System.Windows.Forms.TextBox
$O365PassLbl=New-Object System.Windows.Forms.Label
$O365PassTxtBx=New-Object System.Windows.Forms.TextBox

$compLbl=New-Object System.Windows.Forms.Label
   
$totalvalues = ($onames.count)

$formsize = 290 + (30 * $totalvalues)
$flowlayoutsize = 10 + (30 * $totalvalues)
$buttonplacement = 245 + (30 * $totalvalues)

$script:CheckBoxArray = @()

$form_Load = {
    foreach($user in $onames){
        $DynamicCheckBox = New-object System.Windows.Forms.CheckBox
        $DynamicCheckBox.Margin = '10, 8, 0, 0'
        $DynamicCheckBox.Name = $user
        $DynamicCheckBox.Size = '200, 22'
        $DynamicCheckBox.Text = "" + $user
        $DynamicCheckBox.TextAlign = 'MiddleLeft'
        $flowlayoutpanel.Controls.Add($DynamicCheckBox)
        $script:CheckBoxArray += $DynamicCheckBox
    }       
}
$form.Controls.Add($O365DtlsLbl)
$form.Controls.Add($O365UsrLbl)
$form.Controls.Add($O365UsrTxtBx)
$form.Controls.Add($O365PassLbl)
$form.Controls.Add($O365PassTxtBx)
$form.Controls.Add($label5)
$form.Controls.Add($label1)
$form.Controls.Add($textbox1)
$form.Controls.Add($label2)
$form.Controls.Add($textbox2)
$form.Controls.Add($label3)
$form.Controls.Add($textbox3)
$form.Controls.Add($label4)
$form.Controls.Add($textbox4)
$form.Controls.Add($compLbl)
$form.Controls.Add($flowlayoutpanel)
$form.Controls.Add($buttonOK)
$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "360 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'Install O365 PowerShell Modules and Packages'
$form.add_Load($($form_Load))
    
$flowlayoutpanel.BorderStyle = 'FixedSingle'
$flowlayoutpanel.Location = '38, 220'
$flowlayoutpanel.Margin = '4, 4, 4, 4'
$flowlayoutpanel.Name = 'flowlayoutpanel1'
$flowlayoutpanel.AccessibleName = 'flowlayoutpanel1'
$flowlayoutpanel.Size = "270, $flowlayoutsize"
$flowlayoutpanel.TabIndex = 1

$O365DtlsLbl.Location="38,15"
$O365DtlsLbl.Anchor="Bottom, Left"
$O365DtlsLbl.Text="&O365 Details :"
$O365DtlsLbl.Size="100,20"

$O365UsrLbl.Location="38,38"
$O365UsrLbl.Anchor="Bottom, Left"
$O365UsrLbl.Text="&Username"
$O365UsrLbl.Size="60,20"

$O365UsrTxtBx.Location="105,38"
$O365UsrTxtBx.Name="O365User"
$O365UsrTxtBx.Size="200,20"
$O365UsrTxtBx.Text="none"

$O365PassLbl.Location="38,67"
$O365PassLbl.Anchor="Bottom, Left"
$O365PassLbl.Text="&Password"
$O365PassLbl.Size="60,20"

$O365PassTxtBx.Location="105,67"
$O365PassTxtBx.Name="O365Pass"
$O365PassTxtBx.Size="200,20"
$O365PassTxtBx.Text="none"
$O365PassTxtBx.PasswordChar='*'

if($isEnableCBA){
    $O365DtlsLbl.Enabled=$False
    $O365UsrLbl.Enabled=$False
    $O365UsrTxtBx.Enabled=$False
    $O365PassLbl.Enabled=$False
    $O365PassTxtBx.Enabled=$False
}else{
    $O365DtlsLbl.Enabled=$true
    $O365UsrLbl.Enabled=$true
    $O365UsrTxtBx.Enabled=$true
    $O365PassLbl.Enabled=$true
    $O365PassTxtBx.Enabled=$true
}

$label5.Location="38,95"
$label5.Anchor="Bottom, Left"
$label5.Text="&Proxy Details :"
$label5.Size="100,20"

$label1.Location="38,118"
$label1.Anchor="Bottom, Left"
$label1.Text="&Host IP"
$label1.Size="60,20"

$textbox1.Location="105,118"
$textbox1.Name="ProxyHost"
$textbox1.Size="120,20"
$textbox1.Text="none"

$label2.Location="228,118"
$label2.Anchor="Bottom, Left"
$label2.Text="&Port"
$label2.Size="25,20"

$textbox2.Location="255,118"
$textbox2.Name="Port"
$textbox2.Size="50,20"
$textbox2.Text="none"

$label3.Location="38,145"
$label3.Anchor="Bottom, Left"
$label3.Text="&Username"
$label3.Size="60,20"

$textbox3.Location="105,145"
$textbox3.Name="ProxyUser"
$textbox3.Size="200,20"
$textbox3.Text="none"

$label4.Location="38,171"
$label4.Anchor="Bottom, Left"
$label4.Text="&Password"
$label4.Size="60,20"

$textbox4.Location="105,171"
$textbox4.Name="ProxyPass"
$textbox4.Size="200,20"
$textbox4.Text="none"
$textbox4.PasswordChar='*'

$compLbl.Location="38,200"
$compLbl.Anchor="Bottom, Left"
$compLbl.Text="&Components to be monitored :"
$compLbl.Size="180,20"

$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "135, $buttonplacement"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'

$frmDialog=$form.ShowDialog()
$isChkdOption=$false
foreach($cbox in $CheckBoxArray){
    if($cbox.CheckState -eq 'Checked'){
        $isChkdOption=$true
        $chkBxStr=$chkBxStr+'~'+$options[$cbox.Name]
    }   
}  
Remove-Variable checkbox*
if($frmDialog -eq 'OK' -and $isChkdOption){
    $proxyHost=$textbox1.Text
    $proxyPort=$textbox2.Text
    $proxyUsr=$textbox3.Text
    $proxyPass=$textbox4.Text
    $userName=$O365UsrTxtBx.Text
    $password=$O365PassTxtBx.Text

    $chkVerError=$false
    foreach($opt in $options.Values){
        if($chkBxStr -match $opt){
            $cbaChkBxStr+=$opt+'~'
            $subject='APPs-'+$opt
            $cntNam=$opt+'_ChkDotNetVer'
            $chkVerArr=Get-INIContent -subject $subject -appNam $cntNam
            if($chkVerArr -ne $null -and $chkVerArr -ne '') {
                $verArr=$chkVerArr.Split('~')
                $chkVersion=Check-DotNETversion -FolderName1 $verArr[0] -FolderName2 $verArr[1] -ReleaseNo $verArr[2]
                if($chkVersion -eq $false){
                    $chkVerError=$true
                    $chkSub='APPs-'+$opt;$chkNam=$opt+'_Name'
                    $nam=Get-INIContent -subject $chkSub -appNam $chkNam
                    Write-Host 'Please upgrade your .NET Framework to '$verArr[3]'v to monitor '$nam -ForegroundColor Red
                }
            }
        }  
    }
    if($chkVerError){
        Write-Host 'Error! Exiting...'
        exit
    }
   
    $cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','O365China')
    $com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','O365Default')
    $de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','O365GermanyCloud')
    $us=@('USGovernment','None','O365USGovDoD')
    $azureCloud=$userName.Substring($userName.LastIndexOf('.')+1) 
    $azureCloudArr=@()
    if($azureCloud -eq 'com'){$azureCloudArr=$com}
    elseif($azureCloud -eq 'cn'){$azureCloudArr=$cn}
    elseif($azureCloud -eq 'de'){$azureCloudArr=$de}
    elseif($azureCloud -eq 'us'){$azureCloudArr=$us}  
    else{$azureCloudArr=$com}

    if($userName -ne '' -and $userName -ne $null -and $userName -ne 'none' -and $password -ne '' -and $password -ne $null -and $password -ne 'none'){
        $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    }
    $sessionOption = New-PSSessionOption -SkipRevocationCheck
    if($proxyHost -ne '' -and $proxyHost -ne $null -and $proxyHost -ne 'none' -and $proxyPort -ne '' -and $proxyPort -ne $null -and $proxyPort -ne 'none'){
        $proxyserver='http://'+$proxyHost+':'+$proxyPort
        O365-WriteLog -writString 'Proxy Available in this System '$proxyserver -LogPath $logFile -ReportingName 'SYSTEM'
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne '' -and $proxyUsr -ne $null -and $proxyUsr -ne 'none' -and $proxyPass -ne '' -and $proxyPass -ne $null -and $proxyPass -ne 'none'){
            O365-WriteLog -writString 'Proxy credentials are Available in this System ' -LogPath $logFile -ReportingName 'SYSTEM'
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
            $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
        }
    }

    $moduleNam=Get-InstalledModule
    $availModules=''
    <#
    foreach($nam in $moduleNam){
        $availModules=$availModules+'~'+$nam.Name
    }
    #>
    
    Try{
        Set-PSRepository -Name PSGallery -InstallationPolicy Trusted -ErrorAction Stop
    }Catch{}

    foreach($opt in $options.Values){
        $subject='APPs-'+$opt
        if($chkBxStr -match $opt){
            if($chkBxStr -match 'SBO' -or $chkBxStr -match 'MTM'){$isRunNetwrkAssmnt=$true}
            $subject='APPs-'+$opt
            $cntNam=$opt+'_Ins'
            $appsOptArr=Get-INIContent -subject $subject -appNam $cntNam
            $appsOpts=$appsOptArr -split '~'
            foreach($appOpt in $appsOpts){
                if($appOpt -ne 'none'){
                    $appOptArr=$appOpt -split '@'
                    $chkOS=Chk-OSTypes $appOptArr[1]
                    $chkReg=Chk-Registry $appOptArr[2]
                    if($chkOS -and $chkReg){
                        $APPName=$appOptArr[0]
                        $APPFile=$appOptArr[3]
                        if($APPFile -match '#'){
                            $arr=$APPFile -split '#'
                            $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
                            $dest=$DownloadLocation+$appDst
                            $isPresent=Test-Path $dest -PathType Leaf
                            if(!$isPresent){
                                Try{
                                    $preDwnldHash.add($APPName,$APPFile)
                                }Catch{}
                            }
                            $dest=$dest.Replace(".zip",$arr[1])
                        }else{
                            $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
                            $dest=$DownloadLocation+$appDst
                            $isPresent=Test-Path $dest -PathType Leaf
                            if(!$isPresent){
                                Try{
                                    $preDwnldHash.add($APPName,$APPFile)
                                }Catch{}
                            }
                        } 
                        Try{
                            $installHash.Add($dest,$APPName) 
                        }Catch{}
                    }
                }
            }
        }

        $appNAm=$opt+'_PG'
        $APPsPGArr=Get-INIContent -subject $subject -appNam $appNAm
        $pgArr=$APPsPGArr -split '~'
        $i=0
        foreach($pg in $pgArr){
            Try{
                if($availModules -notmatch $pg){
                    $moduleHash.add($pg,$i)
                }
            }Catch{}
            $i++
        }
    }
}
else{
    Write-Host 'you clicked cancel or did not select options...'
    exit
}

#DOWNLOAD
$proceedInstal1=$False
if($preDwnldHash.Count -ne 0){
    $message = @("Download the below?")
    $message+=" "
    foreach($key in $preDwnldHash.Keys){
    $message+=' -> '+$key
    }
    $res=[system.windows.forms.messagebox]::show(($message -join "`n"),"Download",'YesNo')
    if($res -eq 'Yes'){
        foreach($key in $preDwnldHash.Keys){
            Proceed-Download -APPName $key -APPFile $preDwnldHash[$key]
        } 
        $proceedInstal1=$true    
    }else{
        Write-Host 'You cancelled the download...'
    }
}else{
    $msg = @("Downloads available in")
    $msg+=$DownloadLocation
    $msg+=" "
    $msg+="Proceed with installation?"
    $procdIns=[system.windows.forms.messagebox]::show(($msg -join "`n"),"Download",'YesNo')
    if($procdIns -eq 'Yes'){
        $proceedInstal1=$true
    }else{
        Write-Host 'You cancelled the installation ....'
    }
}

#INSTALLATION
if($proceedInstal1){
    if($installHash.Count -ne 0){
        $insMsg=@("Install the below?")
        $insMsg+=" "
        foreach($key in $installHash.Keys){
            $insMsg+=' -> '+$installHash[$key]
        }
        $insRes=[system.windows.forms.messagebox]::show(($insMsg -join "`n"),"Installation",'YesNo')
        if($insRes -eq 'Yes'){
            foreach($key in $installHash.Keys){
                Try{
                    Write-Host $installHash[$key]' Installation Started...' -ForegroundColor Yellow
                    O365-WriteLog -writString 'Installation started' -LogPath $logFile -ReportingName $installHash[$key]
                    Start-Process $key -Wait -ErrorAction Stop
                    Write-Host $installHash[$key]' Installation process completed!' -ForegroundColor Yellow
                    O365-WriteLog -writString 'Installation process completed' -LogPath $logFile -ReportingName $installHash[$key]
                }Catch{
                    Write-Host 'Installation failed!' -ForegroundColor Red
                    O365-WriteLog -writString 'Installation process not completed or failed' -LogPath $logFile -ReportingName $installHash[$key]
                }  
            } 
            
            foreach($key in $moduleHash.Keys){
                Try{
                    if($key.IndexOf('#') -ne -1){
                        $keyArr=$key.Split('#')
                        Install-Module $keyArr[0] -RequiredVersion $keyArr[1] -Scope AllUsers -AllowClobber -Force
                    }else{
                        Install-Module $key -Scope AllUsers -AllowClobber -Force
                    }
                    Write-Host $key ' modules installed successfully!' -ForegroundColor Green
                    O365-WriteLog -writString $pg ' modules are installed Successfully' -LogPath $logFile -ReportingName $key
                }
                Catch{
                    Write-Host $key ' - Exception occured - '$_.Exception.Message -ForegroundColor Red
                    O365-WriteLog -writString 'Excepton occured in'$key $_.Exception.Message -LogPath $logFile -ReportingName $key
                }
            }          
        }else{
            Write-Host 'You cancelled installation process...'
        }
    }else{
       [system.windows.forms.messagebox]::show("All Prerequisites are in place","Installation",'Ok')
    }
}
<#
if($isRunNetwrkAssmnt){
    $egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
    $ntwrkAssmntFile=$egurkhaPath+'\lib\SBONtwrkAssmnt.ps1'
    $nwAssesTool=Get-Childitem "C:\*\Microsoft Skype for Business Network Assessment Tool"
    if($nwAssesTool -ne $null -and $nwAssesTool -ne ''){
        & $ntwrkAssmntFile
        write-host 'Network Assessment Tool config updated!'
    }  
}
#>

if(!$isEnableCBA){
    #TESTING
    #-------
    Write-Host 'Checking...'
    O365-WriteLog -writString 'Testing started ' -LogPath $logFile -ReportingName 'Testing'
    if($credential -ne $null -and $credential -ne ''){
        foreach($opt in $options.Values){
            $subject='APPs-'+$opt
            if($chkBxStr -match $opt){ 
                $appNAm=$opt+'_Name'
                $nam=Get-INIContent -subject $subject -appNam $appNAm

                if($nam -eq 'Office 365'){
             
                    #MSOnline
                    Write-host "Trying to connect to Microsoft Online..." -ForegroundColor Yellow
                    O365-WriteLog -writString 'trying to connect Microsoft Online.....' -LogPath $logFile -ReportingName 'TESTING - MSOnline'
                    try{
                        Connect-MsolService -Credential $Credential -ErrorAction Stop
                        $Tenant = Get-MsolAccountSku
                        $domainNam = $Tenant | select -First 1
                        Write-Host 'Microsoft Online connected successfully!' -ForegroundColor Green
                        O365-WriteLog -writString 'Microsoft Online connected successfully' -LogPath $logFile -ReportingName 'TESTING - MSOnline'
                    }Catch{
                        Write-Host "Failed - unable to connect to Microsoft Online!" -ForegroundColor Red
                        O365-WriteLog -writString 'Failed - Cannot connect to Microsoft Online' -LogPath $logFile -ReportingName 'TESTING - MSOnline'
                    }

                    #Exchange Online
                    Write-host "Trying to connect to Exchange Online..." -ForegroundColor Yellow
                    O365-WriteLog -writString 'trying to connect Exchange Online...' -LogPath $logFile -ReportingName 'TESTING - Exchange Online'
                    try {
                        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureCloudArr[2] -ConnectionUri $azureCloudArr[1] -Credential $Credential -PSSessionOption $sessionOption -WarningAction SilentlyContinue -InformationAction SilentlyContinue -ShowBanner:$false
                        $domain = Get-AcceptedDomain | where {$_.Name -like "*.onmicrosoft.com" -and $_.Name -notlike "*.mail.onmicrosoft.com"} | select name
                        $domainFullNam=$domain.Name   
                        Write-Host 'Exchange Online connected successfully!' -ForegroundColor Green
                        O365-WriteLog -writString 'Exchange Online connected successfully' -LogPath $logFile -ReportingName 'TESTING - Exchange Online'
                        $getSession=Get-PSSession -ErrorAction SilentlyContinue
                        if($getSession -ne $null -and $getSession -ne ''){
	                        Disconnect-ExchangeOnline -Confirm:$false
                        }
                    } Catch {
                        Write-Host "Failed - Unable to connect to Exchange Online" -ForegroundColor Red
                        O365-WriteLog -writString 'Failed - Cannot connect to Exchange Online' -LogPath $logFile -ReportingName 'TESTING - Exchange Online'
                    }             
                }

                if($nam -eq 'SharePoint Online / OneDrive'){
                    $domainNam =""
                    try{
                        Connect-MsolService -Credential $Credential -ErrorAction Stop
                        $Tenant = Get-MsolAccountSku
                        $domainNam = $Tenant | select -First 1
                        $domainNam=($domainNam.AccountName).ToString().Trim()
                        O365-WriteLog -writString $domainNam -LogPath $logFile -ReportingName 'TESTING - SharePoint Online'
                    }catch{}
                    if($domainNam -ne $null -and $domainNam -ne ""){
                        Write-host "Trying to connect to SharePoint Online..." -ForegroundColor Yellow
                        O365-WriteLog -writString 'trying to connect SharePoint Online...' -LogPath $logFile -ReportingName 'TESTING - SharePoint Online'
                        try{     
                            $url='https://'+$domainNam+'-admin.sharepoint.com'
                            Connect-SPOService -Url $url -Credential $credential -ErrorAction Stop
                            Write-Host 'SharePoint Online connected successfully' -ForegroundColor Green
                            O365-WriteLog -writString 'SharePoint Online connected successfully' -LogPath $logFile -ReportingName 'TESTING - SharePoint Online'
                            Disconnect-SPOService
                        }Catch{
                            Write-Host "Failed - Cannot connect to SharePoint Online" -ForegroundColor Red
                            O365-WriteLog -writString 'Failed - Cannot connect to SharePoint Online' -LogPath $logFile -ReportingName 'TESTING - SharePoint Online'
                        }
                    }else{
                        Write-Host "[$domainNam is null or empty] - SharePoint Online" -ForegroundColor Red
                    }
                }

                if($nam -eq 'Skype for Business Online'){
                    $domainFullNam=''
                    try{
                        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureCloudArr[2] -ConnectionUri $azureCloudArr[1] -Credential $Credential -PSSessionOption $sessionOption -WarningAction SilentlyContinue -InformationAction SilentlyContinue -ShowBanner:$false
                        $domain = Get-AcceptedDomain | where {$_.Name -like "*.onmicrosoft.com" -and $_.Name -notlike "*.mail.onmicrosoft.com"} | select name
                        $domainFullNam=$domain.Name
                        O365-WriteLog -writString $domainFullNam -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                    }catch{}
                    $getSession=Get-PSSession -ErrorAction SilentlyContinue
                    if($getSession -ne $null -and $getSession -ne ''){
	                    Disconnect-ExchangeOnline -Confirm:$false
                    }
                    if($domainFullNam -ne $null -and $domainFullNam -ne ""){
                        Write-host "Trying to connect Skype for Business Online..." -ForegroundColor Yellow
                        O365-WriteLog -writString 'trying to connect Skype for Business Online.....' -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                        <#
                        try {
                            $SfBSession = New-CsOnlineSession -Credential $Credential -OverrideAdminDomain $domainFullNam -SessionOption $sessionOption -ErrorAction Stop 
                            Import-PSSession $SfBSession -ErrorAction Stop -AllowClobber -DisableNameChecking | Out-Null
                            Write-Host "Skype for Business Online connected successfully!" -ForegroundColor Green
                            O365-WriteLog -writString 'Skype for Business Online connected successfully' -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                            Get-PSSession | Remove-PSSession
                        }catch{
                            Write-Host "Failed - Unable to connect to Skype for Business Online" -ForegroundColor Red
                            O365-WriteLog -writString 'Failed - Cannot connect to Skype for Business Online' -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                        } 
                        #>
                        try{
                            $ConneTeams=Connect-MicrosoftTeams -Credential $Credential
                            if($ConneTeams.Account -ne $null){
                                Write-Host "Skype for Business Online connected successfully!" -ForegroundColor Green
                                O365-WriteLog -writString 'Skype for Business Online connected successfully' -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                            }else{
                                Write-Host "Failed - Unable to connect to Skype for Business Online" -ForegroundColor Red
                                O365-WriteLog -writString 'Failed - Cannot connect to Skype for Business Online' -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                            }
                            Disconnect-MicrosoftTeams
                         }catch{
                            Write-Host "Failed - Unable to connect to Skype for Business Online" -ForegroundColor Red
                            O365-WriteLog -writString 'Failed - Cannot connect to Skype for Business Online' -LogPath $logFile -ReportingName 'TESTING - Skype for Business Online'
                            Disconnect-MicrosoftTeams
                         }
                    }else{
                        Write-Host "[$domainFullNam is null or empty] - SharePoint Online" -ForegroundColor Red
                    }
                }

                if($nam -eq 'Microsoft Teams'){
				    <#
                    try{
                        Connect-MsolService -Credential $Credential -ErrorAction Stop
                        $Tenant = Get-MsolAccountSku
                        $domainNam = $Tenant | select -First 1
                        Write-Host 'Microsoft Online connected successfully' -ForegroundColor Green
                        O365-WriteLog -writString 'Microsoft Online connected successfully' -LogPath $logFile -ReportingName 'TESTING - MSOnline'
                    }Catch{
                        Write-Host "Failed - Unable to connect to Microsoft Online" -ForegroundColor Red
                        O365-WriteLog -writString 'Failed - Cannot connect to Microsoft Online' -LogPath $logFile -ReportingName 'TESTING - MSOnline'
                    }
				    #>
                    try{
                        $ConneTeams=Connect-MicrosoftTeams -Credential $Credential
                        if($ConneTeams.Account -ne $null){
                            Write-Host 'Microsoft Teams connected successfully' -ForegroundColor Green
                        }else{
                            Write-Host 'Failed to connect Microsoft Teams ' -ForegroundColor Red
                        }
                        Disconnect-MicrosoftTeams
                     }catch{
                        Write-Host 'Exception Occured in  Connect-MicrosoftTeams - ' $_.Exception.Message -ForegroundColor Red
                        Disconnect-MicrosoftTeams
                     }               
                }
            }
        }
     }
}
else{
    O365-WriteLog -writString "CBA Module options@$cbaChkBxStr" -LogPath $logFile -ReportingName 'INFO'
}

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

$edTim2=Get-Date
O365-WriteLog -writString "O365_Step2_ModulesDwnldnInstall ended at $edTim2" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU4LAV3QdlLSZ/qj7HzrrQ4ieE
# QqKggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFHtyLbcI
# 4sWo18PFjtZ9rj7z+4EWMA0GCSqGSIb3DQEBAQUABIICAF1eqZoyIkoZtgDxy4T5
# wmIZoEIIO3KwtmRrpfYxxUAbQLmOFS7keupJMUaDMsbjI1q3BWeFWQcep2CFQPl3
# 5gYSpc22guDIQVuPLWdxhsmqespw0kGk0eBjOuN4lEELp0V9/rAZUjRkiQYm1rEs
# HLckenoSq09jwkETLLKcoj/uNaz57Q6BRTn5RFcFvpZ+w9C0C4uWXPITz+/5XeKd
# TgAf+kj0DOgeIOOErHetiWQl6lMBm+rCRF5+M7hiK5yN1A+bJ72/t1n5SMGCXycE
# vpAfydiZLxrCbnMg/iA8e3EOSQlatbclrehNmUHVRza+zMA5O8242YrgrtUkZ45N
# DeAO9S0VhW4nFlG+HL+cPiCP9Ckw4ri9oO1fsyfLOCpVijzSreie6Yubf/jDZA5d
# yVk7aOmRdhZ+7gBo9agyLmizU4zSqvwtAGhSZK+4YNe/AfSnrWLnFmaOUsdNCYqu
# ZTXfUDligeLDDWD/CuL0FdiHZ/LMMxsS2FR+P7dwGf1QDvWu+MWM7ocSO+2C0+Ap
# IBRxmQsXiQm+TZBW1GCNf3qZQc2AO80elI3/NXAWsG/GcFrgNkmdL0XwS0tLGWHz
# iYmC+78qbqFMpD4hvip+UfQ9Evq2yTmpo4ISUrAzsfu7GiQj3/6gmxlC7toHLFQ9
# iYeTnT1Lxs5dypUm80utXknIoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDgyMzExMDEy
# OVowLwYJKoZIhvcNAQkEMSIEIMrifNMgW45bqhEtjD2SvHGzKnsvLRLKUZUBSzGH
# SM6vMA0GCSqGSIb3DQEBAQUABIICAGNtrPrR7+mXyO5VHsnx/b5lJ1XN9/OJhsJ7
# N0VqK7TUO2f1x5tfUG7zrUguP+yB7Na8Iso+CZ4+n/HZqIrFKlgzzaTB+jIpP/cO
# Ym4Mxb6iteeEELYLZmmyMsnDGwAvufwBjV5o/orr7z1neGCm/KWnGCoresSQUqJW
# q2DbGSFa4LW312rGNDV1U+tZbudRHf9LhA9Jn5tpoUWDvUJ8Xr2SyTHBZ31BBF+7
# TcBbQ97lXysfgJjtLIywXieiGdCbUPHXZq7UpDz1/r/IwIOyl5u568Bd3zHrEXm1
# /DniB9EAkgPi9gqQXNZ57ZI/RVOMtSBQqRdIvSCio6Mc8nuJ2o+jpZLfPHwI/F2N
# GAaefhESeA8hMeAfw48oX6BxbHvWhqmoM/eLnTb4X92ZVhDwhwp5mWjrchbDnrFx
# vgxuqlJMG5RhVDX1H9U3JG3mh1Dpkc9fHCaBsXyvfBojeAUvqTV5M1QctLkG+Smx
# p7LxaGLRMm31X5wkjvKRTMHkqJYxLP/p2nQ+tnk3aXtn2B3uQxpvNrBtjYP1lGY8
# YC7rHio25DELyZiCLc5eEyXN/8yYAJYn/hy1objzYMzqReHx/V5VMoTPnEYOtCD3
# G+AP6Z7b/e/2ELKs3vKN4roHYFUdI4dBv3YtnFFPf61/+/6jYsRaD2SqHRRCcbfV
# Pmbr3wgy
# SIG # End signature block
