﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$rptNMea=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$rptNMea[0].Trim()
$rptNam=$rptNMea[1].Trim()
$lastRptConfId=$TestInputs[3]
$prxyDtls=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyDtls[0].Trim()
$proxyPass=Eg-O365Dcr -EncStr $prxyDtls[1]
$proxyserverip=$prxyDtls[2].Trim()
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$poorStmsPath=$dir+'\poorStrms'+ $timenow +".csv"

$measures='Measures.Audio Poor Stream Count','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count','Measures.Video Poor Stream Count','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Frame Rate','Measures.VBSS Poor Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count'
$Dimentions='AllStreams.Is Teams','AllStreams.Poor','AllStreams.Unclassified','AllStreams.Start Time','AllStreams.End Time','AllStreams.First UPN','AllStreams.Second UPN','AllStreams.Organizer UPN','AllStreams.Duration (Minutes)','AllStreams.Media Type','AllStreams.Poor Reason','AllStreams.Conference Id','AllStreams.First Inside Corp','AllStreams.Second Inside Corp','AllStreams.First Network Connection Detail','AllStreams.Second Network Connection Detail','AllStreams.First VPN','AllStreams.Second VPN','AllStreams.Transport','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.First Reflexive Local IP','AllStreams.Second Reflexive Local IP','AllStreams.First Feedback Rating','AllStreams.Second Feedback Rating','AllStreams.First Capture Dev Name','AllStreams.Second Capture Dev Name','AllStreams.First Render Dev Name','AllStreams.Second Render Dev Name','AllStreams.First User Agent','AllStreams.Second User Agent','AllStreams.First CPU Name','AllStreams.Second CPU Name','AllStreams.First OS','AllStreams.Second OS','AllStreams.First Virtualization Flag','AllStreams.Second Virtualization Flag','AllStreams.First Capture Dev','AllStreams.Second Capture Dev','AllStreams.First Capture Dev Driver','AllStreams.Second Capture Dev Driver','AllStreams.First Render Dev','AllStreams.Second Render Dev','AllStreams.First Render Dev Driver','AllStreams.Second Render Dev Driver','AllStreams.First MAC Address','AllStreams.Second MAC Address','AllStreams.First Client Endpoint Name','AllStreams.Second Client Endpoint Name','AllStreams.First ASN Country','AllStreams.Second ASN Country','AllStreams.First ASN City','AllStreams.Second ASN City','AllStreams.First ASN State','AllStreams.Second ASN State','AllStreams.Region','AllStreams.First Connectivity Ice','AllStreams.Second Connectivity Ice','AllStreams.First Link Speed','AllStreams.Second Link Speed','AllStreams.Bandwidth Est','AllStreams.Inside Corp Pair','AllStreams.First Tenant Id','AllStreams.Second Tenant Id','AllStreams.Is Federated','AllStreams.First Is Caller','AllStreams.Stream Direction','AllStreams.Audio and Video Call','AllStreams.First Domain','AllStreams.Second Domain','AllStreams.Conference Type','AllStreams.First Client App Version','AllStreams.Second Client App Version','AllStreams.Meeting Id','AllStreams.Error Report Sender','AllStreams.Is Media Error','AllStreams.Media Failure Type','AllStreams.Call Setup Failure Reason','AllStreams.Session Type','AllStreams.CDR Response Reason','AllStreams.First Video Duration Seconds','AllStreams.Second Video Duration Seconds','AllStreams.Audio Degradation Avg','AllStreams.Jitter','AllStreams.Packet Loss Rate','AllStreams.Send Listen MOS','AllStreams.Overall Avg Network MOS','AllStreams.Ratio Concealed Samples Avg','AllStreams.Ratio Stretched Samples Avg','AllStreams.Round Trip','AllStreams.Packet Utilization','AllStreams.Jitter Buffer Size Avg','AllStreams.Relative OneWay Gap Duration','AllStreams.Audio Post FECPLR','AllStreams.Network Jitter Avg','AllStreams.Video Post FECPLR','AllStreams.Video Local Frame Loss Percentage Avg','AllStreams.Recv Frame Rate Average','AllStreams.Low Frame Rate Call Percent','AllStreams.Video Packet Loss Rate','AllStreams.Video Frame Rate Avg','AllStreams.Dynamic Capability Percent','AllStreams.Spoiled Tile Percent Total','AllStreams.First Network Bandwidth Low Event Ratio','AllStreams.Second Network Bandwidth Low Event Ratio','AllStreams.Video Poor Due to Freeze','AllStreams.Video Poor Due To VideoPostFecplr','AllStreams.Video Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.Video Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.First Feedback Tokens','AllStreams.Second Feedback Tokens','AllStreams.First Feedback Has Audio Issue','AllStreams.Second Feedback Has Audio Issue','AllStreams.First Feedback Has Video Issue','AllStreams.Second Feedback Has Video Issue','AllStreams.First Feedback Has AppSharing Issue','AllStreams.Second Feedback Has AppSharing Issue','AllStreams.First Feedback Text','AllStreams.Second Feedback Text'
Try{
    Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 | Export-Csv $poorStmsPath -Encoding $encTyp #-Descending
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
}
[System.GC]::GetTotalMemory($true) | out-null


$allStrms= import-csv $poorStmsPath -Encoding $encTyp
if($poorStmsPath -ne $null -and $poorStmsPath -ne ''){
    if(Test-Path -Path $poorStmsPath -PathType Leaf){
        Remove-Item $poorStmsPath -Force
    }
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$mdifyStmsPath=$dir+'\MdifyStrms'+ $timenow +".csv"
foreach($strms in $allStrms){
    $strmsHash =[ordered] @{}
    $isOccur=$false;$isFirst=$true
    foreach( $property in $strms.psobject.properties.name)
    {
        if($property -eq 'First CPU Name'){$isOccur=$true}
        if($property -eq 'Audio Poor Stream Count'){$isOccur=$false}
        if($isOccur -and $isFirst){
            $isFirst=$false
            $sysDtls=$strms.'First CPU Name'+'~#~'+$strms.'Second CPU Name'+'~#~'+$strms.'First OS'+'~#~'+$strms.'Second OS'+'~#~'+$strms.'First Virtualization Flag'+'~#~'+$strms.'Second Virtualization Flag'+'~#~'+$strms.'First Capture Dev'+'~#~'+$strms.'Second Capture Dev'+'~#~'+$strms.'First Capture Dev Driver'+'~#~'+$strms.'Second Capture Dev Driver'+'~#~'+$strms.'First Render Dev'+'~#~'+$strms.'Second Render Dev'+'~#~'+$strms.'First Render Dev Driver'+'~#~'+$strms.'Second Render Dev Driver'+'~#~'+$strms.'First MAC Address'+'~#~'+$strms.'Second MAC Address'+'~#~'+$strms.'First Client Endpoint Name'+'~#~'+$strms.'Second Client Endpoint Name'
            $netWrkDtls=$strms.'First ASN Country'+'~#~'+$strms.'Second ASN Country'+'~#~'+$strms.'First ASN City'+'~#~'+$strms.'Second ASN City'+'~#~'+$strms.'First ASN State'+'~#~'+$strms.'Second ASN State'+'~#~'+$strms.'Region'+'~#~'+$strms.'First Connectivity Ice'+'~#~'+$strms.'Second Connectivity Ice'+'~#~'+$strms.'First Link Speed'+'~#~'+$strms.'Second Link Speed'+'~#~'+$strms.'Bandwidth Est'+'~#~'+$strms.'Inside Corp Pair'
            $callDtls=$strms.'First Tenant Id'+'~#~'+$strms.'Second Tenant Id'+'~#~'+$strms.'Is Federated'+'~#~'+$strms.'First Is Caller'+'~#~'+$strms.'Stream Direction'+'~#~'+$strms.'Audio and Video Call'+'~#~'+$strms.'First Domain'+'~#~'+$strms.'Second Domain'+'~#~'+$strms.'Conference Type'+'~#~'+$strms.'First Client App Version'+'~#~'+$strms.'Second Client App Version'+'~#~'+$strms.'Meeting Id'+'~#~'+$strms.'Error Report Sender'+'~#~'+$strms.'Is Media Error'+'~#~'+$strms.'Media Failure Type'+'~#~'+$strms.'Call Setup Failure Reason'+'~#~'+$strms.'Session Type'+'~#~'+$strms.'CDR Response Reason'+'~#~'+$strms.'First Video Duration Seconds'+'~#~'+$strms.'Second Video Duration Seconds'
            $metricsDtls=$strms.'Audio Degradation Avg'+'~#~'+$strms.'Jitter'+'~#~'+$strms.'Packet Loss Rate'+'~#~'+$strms.'Send Listen MOS'+'~#~'+$strms.'Overall Avg Network MOS'+'~#~'+$strms.'Ratio Concealed Samples Avg'+'~#~'+$strms.'Ratio Stretched Samples Avg'+'~#~'+$strms.'Round Trip'+'~#~'+$strms.'Packet Utilization'+'~#~'+$strms.'Jitter Buffer Size Avg'+'~#~'+$strms.'Relative OneWay Gap Duration'+'~#~'+$strms.'Audio Post FECPLR'+'~#~'+$strms.'Network Jitter Avg'+'~#~'+$strms.'Video Post FECPLR'+'~#~'+$strms.'Video Local Frame Loss Percentage Avg'+'~#~'+$strms.'Recv Frame Rate Average'+'~#~'+$strms.'Low Frame Rate Call Percent'+'~#~'+$strms.'Video Packet Loss Rate'+'~#~'+$strms.'Video Frame Rate Avg'+'~#~'+$strms.'Dynamic Capability Percent'+'~#~'+$strms.'Spoiled Tile Percent Total'+'~#~'+$strms.'First Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Second Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Video Poor Due to Freeze'+'~#~'+$strms.'Video Poor Due To VideoPostFecplr'+'~#~'+$strms.'Video Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'Video Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'VBSS Poor Due To VideoPostFecplr'+'~#~'+$strms.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'VBSS Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'AppSharing Poor Due To SpoiledTilePercentTotal'+'~#~'+$strms.'AppSharing Poor Due To RelativeOneWayAverage'+'~#~'+$strms.'AppSharing Poor Due To RDPTileProcessingLatencyAverage'+'~#~'+$strms.'Audio Poor Due To Jitter'+'~#~'+$strms.'Audio Poor Due To RoundTrip'+'~#~'+$strms.'Audio Poor Due To PacketLoss'+'~#~'+$strms.'Audio Poor Due To Degradation'+'~#~'+$strms.'Audio Poor Due To ConcealedRatio'
            $feedBackDtls=$strms.'First Feedback Tokens'+'~#~'+$strms.'Second Feedback Tokens'+'~#~'+$strms.'First Feedback Has Audio Issue'+'~#~'+$strms.'Second Feedback Has Audio Issue'+'~#~'+$strms.'First Feedback Has Video Issue'+'~#~'+$strms.'Second Feedback Has Video Issue'+'~#~'+$strms.'First Feedback Has AppSharing Issue'+'~#~'+$strms.'Second Feedback Has AppSharing Issue'+'~#~'+$strms.'First Feedback Text'+'~#~'+$strms.'Second Feedback Text'
            
            $strmsHash.Add('Video Frame Rate Avg',$strms.'Video Frame Rate Avg')
            $strmsHash.Add('First Transport Protocol',$strms.'First Transport Protocol')
            $strmsHash.Add('Second Transport Protocol',$strms.'Second Transport Protocol')
            $strmsHash.Add('Session Type',$strms.'Session Type')
            $strmsHash.Add('Stream Direction',$strms.'Stream Direction')
            $strmsHash.Add('Jitter',$strms.'Jitter')
            $strmsHash.Add('Packet Loss Rate',$strms.'Packet Loss Rate')
            $strmsHash.Add('Round Trip',$strms.'Round Trip')

            $strmsHash.Add('System Details',$sysDtls)
            $strmsHash.Add('Network Details',$netWrkDtls)
            $strmsHash.Add('Call Details',$callDtls)
            $strmsHash.Add('Metrics Details',$metricsDtls)
            $strmsHash.Add('Feedback Details',$feedBackDtls)

        }
        if(!$isOccur){
            $strmsHash.Add($property,$strms.$property)
        } 
    }
    [pscustomobject]$strmsHash | Export-Csv $mdifyStmsPath -Encoding $encTyp -Append 
}


$poorStrms= import-csv $mdifyStmsPath -Encoding $encTyp | Sort-Object -Property 'End Time'
if($mdifyStmsPath -ne $null -and $mdifyStmsPath -ne ''){
    if(Test-Path -Path $mdifyStmsPath -PathType Leaf){
        Remove-Item $mdifyStmsPath -Force
    }
}
if($poorStrms.Count -gt 0){
    $writPath=$dir+'\MTMStrms'+ $timenow +".csv"
    $iswrite=$false
    $obj=$poorStrms| select -Last 1
    #$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
    $rptLastConfID=([String]$obj.'Conference Id').Trim()

    if($lastRptConfId -ne 'none'){
        $isChkTim=$true
        foreach($strms in $poorStrms){
            if($iswrite){
                $strms| Export-Csv $writPath -Encoding $encTyp -Append
            }
            if($isChkTim){
                $chkConfIdNam=([String]$strms.'Conference Id').Trim()
                if($lastRptConfId -eq $chkConfIdNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $poorStrms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }

    $confIdStr='LastConferenceID#'+$rptLastConfID
    Write-Host $confIdStr
    Write-Host 'LastReporting WritePath#'$writPath

    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAD  -AzureEnvironmentName $azureEnvArr[0] -Credential $credential |select *
    $iniDomainDtls=Get-AzureADDomain | select *
    Write-Host 'TenantDomains#'$iniDomainDtls.Name
    Disconnect-AzureAD

}

[System.GC]::GetTotalMemory($true) | out-null












# SIG # Begin signature block
# MIIldgYJKoZIhvcNAQcCoIIlZzCCJWMCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU6TvkUqG+6a/+jMyvTxKX1BTO
# CfOggh6cMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFsTCC
# BJmgAwIBAgIQASQK+x44C4oW8UtxnfTTwDANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwNjA5MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBXjCCAVowDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsGAQUF
# BwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMG
# CCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwIAYDVR0g
# BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEBDAUAA4IBAQCa
# FgKlAe+B+w20WLJ4ragjGdlzN9pgnlHXy/gvQLmjH3xATjM+kDzniQF1hehiex1W
# 4HG63l7GN7x5XGIATfhJelFNBjLzxdIAKicg6okuFTngLD74dXwsgkFhNQ8j0O01
# ldKIlSlDy+CmWBB8U46fRckgNxTA7Rm6fnc50lSWx6YR3zQz9nVSQkscnY2W1ZVs
# RxIUJF8mQfoaRr3esOWRRwOsGAjLy9tmiX8rnGW/vjdOvi3znUrDzMxHXsiVla3R
# y7sqBiD5P3LqNutFcpJ6KXsUAzz7TdZIcXoQEYoIdM1sGwRc0oqVA3ZRUFPWLvdK
# RsOuECxxTLCHtic3RGBEMIIGMzCCBRugAwIBAgIQCJp0nrgtw+wn6mXq2/g1MTAN
# BgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQg
# SW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
# dCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4XDTIxMDUyNTAwMDAw
# MFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBK
# ZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMs
# IEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMuMIICIjANBgkqhkiG
# 9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7JDxOs7sySHvaQ3wGR
# 2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJIk0AZXDTMvXr/mEvm
# KxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+f9I4EgTo9OcdVeIN
# XhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuKifgxL2i8d5FDzkhZ
# SZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZyyaRURtlx11pYfJ/K
# NYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgRADe3/k0NtiVwJIo0
# ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yKf4kpRFmClYfK5Lst
# GQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3VhN+aV56kR/efo8e
# D81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRvIID/l+yDJogDBpae
# 3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug3F2CVJpNbzb1HmAH
# 6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4KTAg7ROmGkwdLhmXo
# PCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsqCqOl6nEDwGD5LfZl
# dQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAOBgNVHQ8BAf8EBAMC
# B4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1oDOgMYYvaHR0cDov
# L2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwNaAzoDGG
# L2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3Js
# MEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAC
# hkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
# ZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
# AAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuChsgkv1PmQpgfypxC
# 3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5NAxDGuIczAIeXOc5k
# RRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9ndCmGSsqcxjG2ud8O6
# Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKRLAUu6IgD6WJKMVfZ
# XWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwoevxbIWh0SenZOUrA
# q9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9
# KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERp
# Z2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMY
# RGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3MDMy
# MjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRp
# bWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMaG
# NQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjzaPp9
# 85yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3EF3+r
# GSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpX
# evA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7LeSn3O9TkSZ+8OpWNs
# 5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymW
# Jy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP29p7mO1vsgd4iFNmC
# KseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaz
# nTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0UfM2
# SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YS
# UZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ14mCjWAkB
# KAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGjggFdMIIBWTASBgNV
# HRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57IbzAf
# BgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMCAYYw
# EwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMG
# A1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG
# /WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAYLhBN
# E88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb122H+oQgJTQxZ822
# EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequFzUNf7WC2
# qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQsl3p/yhUifDVinF2
# ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7+6ad
# cq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJD5TN
# OXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOr
# pgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJGnXUs
# HicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJig
# K+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInwAM1dwvnQI38AC+R2
# AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4
# GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhNhpedMA0GCSqGSIb3
# DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7
# MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1l
# U3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
# CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG0Rp
# Z2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx5DxArvurxON4XX5c
# Nur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJx
# bKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIjQVr4YNNlLD5+
# Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJHGVvimC6P0Mo//8Zn
# zzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz4Di9or16
# cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vICNEyu4P6IzzZ/9KM
# u/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03ShL7BU
# dsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2xwafEDsTvQD4ZOgLU
# MalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
# CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2QT3nr6caKMmtYbCg
# QRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGj
# ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8E
# DDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
# HwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYEFI1kt4kh
# /lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3Rh
# bXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1l
# U3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
# 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4qOVo5TtiEWaW8G5iq
# 6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJ
# T4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8y/pc9+RTv24KfH7X
# 3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEip
# tucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSiZZQR+24y8fW7
# OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp43UZ3Lht6wDOK+Eoo
# jBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q+A8GQp3f
# BmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVrNQ6F1uAszOAMJLh8
# UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/Tf8u+
# wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdjOEcXW28T2moQbh9J
# t0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmlu
# ZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIB
# DDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFLUXDWSPCUwcp/bcB9ELjLb5
# cL3eMA0GCSqGSIb3DQEBAQUABIICAL3JG3xZ1Es3LNh97hgmHs/SjayfVjlL81RQ
# RmpLt1ZCnOocZa+4P+8Q0QG+eJvEm+hnOEdSvvYLVD/cnNIXMZU0SEf5N3WhkwCY
# ztA9YouDCPajNaUANL53csRo/MxVJAWX1gAuS5uzriYWbvuAgEsuiNa13LijrpSR
# LMTMsMdKMDftYXTRvfNL1/XOapFVnFgSMMItsPKRDdIq8SaMBloYkNb82e5otyv+
# 60aXBNmkAYGLn+1avdVZlVrronYzFTaG+Fjpgt+vB2MBWNHNkyDECWNKFTVdFRld
# HWERztdppw/bJVnRwHuSv9zO44+WX+8UiWwIm5ghWKYTLJI2U9YV4e9fd4vE7edb
# 03CtK7Z+5qglCTDJ/9NFkQeQ2SxMQlW4dZoLPiByEIp9nFlSbCt6C9TFA/E6JXzD
# 6uk3eub3LQAhixVUKhlvtblsZTHgqaD+VvzZxU5YN/sptAeHZCK3ynvvYhUPkwER
# ffFNHmcweMB+8JXzrwQXip4Eqx63G6bdDGUR18aeDvLhBVg1FiX5SC14eNxDB3NH
# JYajdWF8mneIzeUMx1ZIJYnvsKJ5VzAlomIOo9chINRB50t+e7sMupC3ba+Nt2Ch
# 6jtu6QnnbUeumCD4Cqt4MptwnyVIKbrOQnA65Uf8TvaChdkmYA1LM5UGOeKCA7Do
# 9rc3LX6toYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQCnpK
# iJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkq
# hkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDcyMjE0NTkwMVowLwYJKoZIhvcN
# AQkEMSIEIIDnDiUEm/eXlgmV0yrDhKB6tTpNwwerwIUF8LZzYH51MA0GCSqGSIb3
# DQEBAQUABIICAFY7AsO8NzlSqce6i4sMqi5jRK9EZEuOXsxA4jr2eKvIaUKGxNdM
# gog1LmEXuLB6/N1XgDtl3hurkXZs+UxzYqNjqeszqqfYkKtlt4b7tbDxjnDk7Iuf
# iN6LMbYubbFR0gmzuqwqa68D2AcbOei2gcrWEUtgn7KOvlL+zheU9xmqf7nx20fn
# ZFlJCLtapIxlZ0Y01EIL0LQ5jZXwm4Ixy2/lYR9ickZ0prWane5NEKIZO5jDThp1
# TNvCiBBrgJpO50Snj7CbiXXx+E236vtjQuU4hFD10q2spxCpvY1CdQimlwN1yENO
# jGKsWzI9uLtkYrjA7AkKEEYISHPZ1rekv735/ZGZ0XGT3aw62DXucYf78xbfQIAU
# oFN7yesGo8QQiZIJwk+f7UEWDecRAcyaSWEQnqXLVqXhxpc7V5GrL66Z6c1jGnoP
# yHCdG4pJ4hppN+JdfrAZQ2uba0o2RXxnix3huzMXCdUnH0jb0pRx5siG4upR0aOT
# lTCpKZM555NjUdY1zlVu96jb2eznJIrxpfXp/P7xp3HjHbqCblND+sOC/wtUbYXy
# UA2uZxb5RSwPNOqtI8cwCIdkL0kgS6aleleHd4P3f4dExxl5dHJxmzESUOTq8HQG
# HoJgTjMT4xTjZbpx3y9spB1rW86h0N+YqwENw4seWlDbR1vRMRWF2EgM
# SIG # End signature block
