﻿#$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
#$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
$mediaDuration='30'
$nwrkAssessDir=''
$drives =gdr -PSProvider 'FileSystem' | select name
foreach($drv in $drives){
    $path=$drv.Name+':\*\Microsoft Teams Network Assessment Tool'
    Try{
        $nwAsses=Get-Childitem $path -Recurse
        $nwrkAssessDir=$nwAsses.Directory[0].ToString()
        if($nwrkAssessDir -ne '' -and $nwrkAssessDir -ne $null){
            break
        }
    }Catch{}
}

if($nwrkAssessDir -ne '' -and $nwrkAssessDir -ne $null){
try {
    $filePath=$nwrkAssessDir+'\NetworkAssessmentTool.exe.config'
    $writPath=$nwrkAssessDir+'\NetworkAssessmentTool.exe.config1'
    $userNam=$env:UserDomain+'\'+$env:UserName
    [System.GC]::GetTotalMemory($true) | out-null

    #FOLDER PERMISSION
    $acl = Get-Acl $nwrkAssessDir
    $acl.setOwner([System.Security.Principal.NTAccount]$userNam)
    $permission = $userNam,"FullControl","Allow"
    $accessRule = New-Object System.Security.AccessControl.FileSystemAccessRule $permission
    $acl.SetAccessRule($accessRule)
    $acl | Set-Acl $nwrkAssessDir
    #Set-ItemProperty $nwrkAssessDir -name IsReadOnly -value $false

    #FILE PERMISSION
    $acl = Get-Acl $filePath
    $acl.setOwner([System.Security.Principal.NTAccount]$userNam)
    $permission = $userNam,"FullControl","Allow"
    $accessRule = New-Object System.Security.AccessControl.FileSystemAccessRule $permission
    $acl.SetAccessRule($accessRule)
    $acl | Set-Acl $filePath
    Set-ItemProperty $filePath -name IsReadOnly -value $false

    get-content $filePath|ForEach-Object{$val='';if($_.Contains('value') -and $_.Contains('"/>')){$val=$_.Substring($_.IndexOf('value="')+7); $val=$val.Substring(0,$val.IndexOf('"/>'));$val=$val.ToString()}if($_.Contains('MediaDuration') -and $mediaDuration -ne '' -and $val -ne ''){$_ -replace $val,$mediaDuration}else{$_}}|set-content $writPath -Force
    if(Test-Path -Path $filePath -PathType Leaf) {
        Remove-Item $filePath
    }
    if(Test-Path -Path $writPath -PathType Leaf) {
        Rename-Item $writPath $filePath
    }
    write-host '***Permissions provided successfully ********'
} catch {
    Write-Error $_
}
}else{
    write-host '***Operation failed ********'
}
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIfwQYJKoZIhvcNAQcCoIIfsjCCH64CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUPtC9jroc+GdpL4yYIT8qRbwT
# yD2gghjnMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIGMzCC
# BRugAwIBAgIQCJp0nrgtw+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA
# xGUJ0prjbfxcmgZGjd7JDxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bn
# NViY/zF4Pbo0ZkYtMzJIk0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvc
# NSa0zII2a5jiQJFy85j+f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26J
# clOaed0L5Vs7+CbGzZuKifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCN
# RisIPGB7mg+Rln2XvUZyyaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj
# 4xLyt7poQBG+b0uzCjgRADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi
# 8clAwfBYc2XhSuUcX3yKf4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rma
# MywZFVLHEpmpYZePz7M3VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2
# uhL2MXb/uRshVDSOkFRvIID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDv
# ANZw7mptzHn0Blmw5lug3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2
# byttF7cQPJyl7UI9Cu4KTAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8G
# A1UdIwQYMBaAFFrEuXsqCqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gT
# SS8aBNa1r34MMA42SjAOBgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUH
# AwMwdwYDVR0fBHAwbjA1oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3No
# YTItYXNzdXJlZC1jcy1nMS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0
# LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9
# bAMBMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAI
# BgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29j
# c3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdp
# Y2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQw
# DAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7
# bHbtiVl+uumfRj2YrFuChsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnf
# phLhEwYc2+0Qs/Nlib5NAxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7B
# oUAyqRXsMPdWbTkN/9ndCmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5Q
# TrM49nbIU8QGuRYNXZKRLAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397
# T+BVQrDWMOG8+GeRiJwoevxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS
# 3zCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAw
# YjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
# d3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290
# IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMC
# VVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBU
# cnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJ
# KoZIhvcNAQEBBQADggIPADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh
# 1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+Feo
# An39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1
# decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxnd
# X7RUCyFobjchu0CsX7LeSn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6
# Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPj
# Q2OAe3VuJyWQmDo4EbP29p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlREr
# WHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JM
# q++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh
# 3pP+OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8j
# u2TjY+Cm4T72wnSyPx4JduyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnS
# DmuZDNIztM2xAgMBAAGjggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1Ud
# DgQWBBS6FtltTYUvcyl2mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzf
# Lmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgw
# dwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2Vy
# dC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9E
# aWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6
# Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAG
# A1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOC
# AgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp
# /GnBzx0H6T5gyNgL5Vxb122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40B
# IiXOlWk/R3f7cnQU1/+rT4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2d
# fNBwCnzvqLx1T7pa96kQsl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibB
# t94q6/aesXmZgaNWhqsKRcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7
# T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZA
# myEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdB
# eHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnK
# cPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/
# pNHzV9m8BPqC3jLfBInwAM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yY
# lvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgEC
# AhAKekqInsmZQpAGYzhNhpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVT
# MRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1
# c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5
# MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
# RGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIy
# IC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knw
# FYIY9DPuzFxs4+AlLtIx5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFEN
# MQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW
# 2Nq867Lxg9GfzQnFuUFqRUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjl
# RDRSXw9Q3tRZLER0wDJHGVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200k
# heiClOEvA+5/hQLJhuHVGBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZ
# mCbO4O2ufyguwp7gC0vICNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siu
# gSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9d
# RLNDHSNQzZHXL537/M2xwafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuG
# Z1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcF
# aPfUcONCleieu5tLsuK2QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHN
# P8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMC
# B4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
# GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3Mp
# dpovdYxqII+eyG8wHQYDVR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1Ud
# HwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRy
# dXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUF
# BwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20w
# WAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZI
# hvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVw
# Eb+EGYs/XeWGT76TOt4qOVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs
# 1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h
# 7x44ip/vEckxSli23zh8y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZb
# NZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7p
# x6A+TxC5MDbk86ppCaiLfmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7
# cDBVeNaY/lRtf3GpSBp43UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpR
# oJWCjihrpM6ddt6pc6pIallDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs
# 8QcVfjW05rUMopml1xVrNQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWu
# FL+Kcd/Kl7HYR+ocheBFThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKY
# pl0rl+CL05zMbbUNrkdjOEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIG
# RDCCBkACAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
# YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
# U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1
# MTAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwG
# CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZI
# hvcNAQkEMRYEFEN9azsgcm/+/pJqgDX7fMGScB5SMA0GCSqGSIb3DQEBAQUABIIC
# AF1AnZBeNfR0/qS28rd+qS2XAerA9LmSv9ifdBdDcORnh0CvStudCC7ClMljEMRj
# a+Mk1rsSmDP/DxGwgp5csrtqJANb0nem0WAf+s8PXr9FLaZ01QmIktq8+LHAm+jy
# EjvJAhdzPkEcaSb4Adxwa09oJFU7RySo4oyHI0vonqZeo0zbhRLAqfYJOZMNkp9r
# rJZwIXUwH8ujyfTJHy9vskIIl7j98xsKo5gDY5jrlWVABOTTiGn856WDqM1TJsX1
# fwFy6Y74EOeOKGqLOfU2n8ujoTMVqeaBlm1XlhZmlxqnqt91bSvznPGaBHSHChXz
# MdH37eWubVPN4X6I54L3EcCrW4K6FCXOI/FQ+T2W1Ic3PsmjWORcvpdLgnWmCpm9
# rJCH4Nbx76aIkvDAgzKChUflOFJ+5BbGGKclVLMjgs3GC53LV0FNcdiMA9lCqVtW
# tKIPvFueBER38zPlmmujSUvC/gXKVC15xJhTmR2HpX+RkHq7d1+Npv+OXyslXzLv
# 0ZLXDWp/i0LJPpv99/UYzJ6XHFbSXEhIq0fVr8IzkHPDVaQEVOMWgUPqJeSVrIq6
# GDPtttqiFa9NXAgyfIo0ItgGYgh2uFCK7KnoWJJa3GdAgUvURHsA2HWJ0DsFyD90
# nQH0eN8v54WXBwyL8ew8TrM2IfqIGdZTPediIVaypQL8oYIDIDCCAxwGCSqGSIb3
# DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lD
# ZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYg
# U0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgB
# ZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkF
# MQ8XDTIyMDYwNDA1MTU0NFowLwYJKoZIhvcNAQkEMSIEIKx6RAkaHpbh2bxTUW2U
# 3RYhp9pKZpi3TsTRWgnErES9MA0GCSqGSIb3DQEBAQUABIICAG25OF4g1mpjpxDx
# iPpNXyRrWNRpR2KtYGGB5eiKAHsyVkqkrpCr1R+bcmPptyMSgfEIhTYkOorJmYBI
# JjcOTUC8W9KQ2rkYYZvNNVDc5ufHsNtDk1QVqvSu1YFDeGJTrJCUEjlJ3lKY7CWY
# 7UFSC2BGjNW+58W/vhrXClPHVCiC51Qk4fW9V4LSMJY7c6BV0ufAy4GFL26Vi+BM
# UEgTp/JRV+aF1dlpafp3HaWInb+MlueLzDSCJpm6xy2oiI0oy8vAZX+K7kS4kEGj
# DadoKTQIKa5+VFjjswWcnkymziMXgsnH9txZl5eB/+QW00+KTEDFrTInwGVgFQwF
# Ynbm5ElVIKNa+sbA36agCtVXIfcW9TxXjfmEv2dx/Gh8sO7++ztfAOywKQmWOwlP
# qX/UQkz1EAoxS6y2LmuQ1+u280mx1WlJP13iuqNPmfLD7zRgKwlEYPMkKHpg409k
# KT4kYRXaSg4tqmO2YtdNKhAKGZrodqbwAQ/rvbc1KseNLF+46H4R5qnFme5XMK74
# UauNDbmhcL3/oeEjAoZB7EGAEjVPH3dXZAAljjO8a2AafUtOV7/i8EGgqiw8pJai
# ENHhHOLe5TJIjV221VKVvbg2OzKw/dOWQ2x4yixmqAv5u+6Sjyp+xS55t/69riTd
# /MizeEmRBDCeyaRIu1txWYoJUuR9
# SIG # End signature block
