$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

# Finding XenDektop Broker
$ips = @{}
$count = 0
$tips = ""

Write-Host "XenDesktop Controller"
Write-Host "-----------------------"
$DDCServer = get-itemproperty hklm:\software\citrix\virtualdesktopagent\state
if($DDCServer)
{
    $ips = @(([net.dns]::GetHostEntry($DDCServer.RegisteredDdcFqdn)).AddressList)
    if($? -and $ips)
    {
        foreach($ip in $ips)
                {
                    if($ip.AddressFamily -eq "InterNetwork")
                            {
                                if($count -eq 0)
                                        {
                                            $tips = $ip.IPAddressToString
                                        }
                                        else
                                        {
                                            $tips = $tips + "," + $ip.IPAddressToString
                                        }
                                        $count = $count + 1
                            }       
                        
                }       
                Write-Host $tips
    }
}
Write-Host
$ips = @{}
$count = 0
$tips = ""

# Finding RDS License Server
Write-Host "RDS License Server"
Write-Host "------------------------"
$key = 'HKLM:\SOFTWARE\Policies\Microsoft\Windows NT\Terminal Services'
$server = (Get-ItemProperty -Path $key -Name LicenseServers -ErrorAction silentlycontinue).LicenseServers 
if($? -and $server)
{
    $ips = @(([net.dns]::GetHostEntry($server)).AddressList)
    if($? -and $ips)
    {
        foreach($ip in $ips)
                {
                    if($ip.AddressFamily -eq "InterNetwork")
                            {
                                if($count -eq 0)
                                        {
                                            $tips = $ip.IPAddressToString
                                        }
                                        else
                                        {
                                            $tips = $tips + "," + $ip.IPAddressToString
                                        }
                                        $count = $count + 1
                            }       
                        
                }       
                Write-Host $tips
    }
            
}
