$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#Import-modules
$CitrixProp = Get-ItemProperty -Path 'HKLM:\SOFTWARE\Citrix\Citrix Desktop Delivery Controller' -Name InstallDir
$CitrixInstallDir =  $CitrixProp.InstallDir
$psmFile = "\Telemetry Service\TelemetryModule\Citrix.GroupPolicy.Commands.psm1"
$ImportCmd = $CitrixInstallDir + $psmFile
Import-Module $ImportCmd

$FQDN = [System.Net.Dns]::GetHostEntry([System.Net.Dns]::GetHostName()).HostName
New-PSDrive -Name LocalFarmGpo -PSProvider CitrixGroupPolicy -Root \ -Controller $FQDN -Scope Global | Out-Null

$CtxGroupPolicy = Get-CtxGroupPolicy
foreach ($Policy in $CtxGroupPolicy)
{
	$PolicyName = $Policy.PolicyName
	$Type = $Policy.Type
	$Enabled = $Policy.Enabled
	$Desciption = $Policy.Description
	$Priority = $Policy.Priority
	if ($Desciption -eq $null -and $Desciption.length -eq 0)
	{
		$Desciption = "-"
	}

	$CtxGPConfig = Get-CtxGroupPolicyConfiguration -PolicyName $PolicyName -Type $Type
	if ($CtxGPConfig -ne $null)
	{
		foreach ($GPConfig in $CtxGPConfig)
		{
			foreach ($GPConfigProperty in @($GPConfig | Get-Member -Type NoteProperty | Select -Expand Name))
			{
				$Config = $GPConfig.$GPConfigProperty
				if ($Config.State -ne "NotConfigured")
				{
					$CTXconfPolicy = New-Object PSObject
					if (Get-Member -InputObject $Config -Name Value)
					{
						$CtxConfPolicy | Add-Member -MemberType NoteProperty -Name ConfiguredSetting -Value "$($Config.Path)" -PassThru | Add-Member -MemberType NoteProperty -Name ConfiguredValue "$($Config.Value)" -PassThru | Out-Null
						$ConfiguredSetting = $CtxConfPolicy.ConfiguredSetting.Trim()
						$ConfiguredValue = $CtxConfPolicy.ConfiguredValue.Trim()
					}
					else
					{
						$CtxConfPolicy | Add-Member -MemberType NoteProperty -Name ConfiguredSetting -Value "$($Config.Path)" -PassThru | Add-Member -MemberType NoteProperty -Name ConfiguredValue "$($Config.State)" -PassThru | Out-Null
						$ConfiguredSetting = $CtxConfPolicy.ConfiguredSetting.Trim()
						$ConfiguredValue = $CtxConfPolicy.ConfiguredValue.Trim()
					}

					if ($ConfiguredSetting.Length -gt 0)
					{
						if ($GPConfig -ne $null)
						{
							$GPFilter = Get-CtxGroupPolicyFilter -PolicyName $PolicyName
							$FilterName = $GPFilter.FilterName
							$FilterType = $GPFilter.FilterType
							$FilterValue = $GPFilter.FilterValue
							$Mode = $GPFilter.Mode
						}
						Write-Host ($PolicyName,$Type,$Enabled,$Desciption,$Priority,$ConfiguredSetting,$ConfiguredValue,
							    $FilterName,$FilterType,$FilterValue,$Mode) -Separator "#~#"
					}
				}
			}
		}
	}
}

Write-Host "#EG_SCRIPT_DONE#"



