﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

$TestInputs=$args

$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyHost=$TestInputs[2]
$proxyPort=$TestInputs[3]
$proxyUsr=$TestInputs[4]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[5]
$appDetails=$TestInputs[6]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}

$azureVal=Eg-GetAzureEnv -UserName $userName -subject 'O365_AzureEnvironment'
$azureEnvArr=$azureVal.Split(',')

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if($proxyHost -ne 'none' -and $proxyPort -ne 'none'){
    $proxyserver='http://'+$proxyHost+':'+$proxyPort
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
}
if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
    $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
    [System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred	
    [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
}

if($appDetails -ne 'none'){
    $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
    if($?){
        Write-Host 'success'
        Disconnect-AzureAD
    }else{
        Write-Host 'failure'
    }
}else{
    Connect-MsolService -Credential $credential -AzureEnvironment $azureEnvArr[0] -ErrorAction SilentlyContinue
    if($?){
        Write-Host 'success'
    }else{
        Write-Host 'failure'
    }
}

[System.GC]::GetTotalMemory($true) | out-null
