﻿##/*****************************************************************************
##Author                :               Guravareddy.T
##Purpose               :               O365 Distributed Groups Tyoes And Count
##Created               :               11/1/2017
##Modified By		: 
##/*****************************************************************************
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$reportingname='EXO/'+$testargs[0]
$testFrequency=$testargs[1]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

function Convert-UnixTime {
Param(
[Parameter(Mandatory=$true)][int32]$udate
)
 
    # Retrieve start of UNIX Format
    $orig = (Get-Date -Year 1970 -Month 1 -Day 1 -hour 0 -Minute 0 -Second 0 -Millisecond 0)
 
    # Return final time
return $orig.AddSeconds($udate)
}

    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
    if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
	
try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "distgroups" -keyFileName "kdistgroups" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $disbtedgrp= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'distgroups' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kdistgroups' -InputFile $readfiles[4]
        Write-Host "ReadFile:"$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    [System.GC]::GetTotalMemory($true) | out-null
        try{
            $datpos = $readfiles[3].IndexOf(".dat")
	        $length='distgroups'.Length  
            $tmpvalue = $readfiles[3].toString().substring($length,($datpos-$length))
    		$readtime= Convert-UnixTime $tmpvalue
    		$readfiledif=NEW-TIMESPAN –Start $readtime –End (Get-Date) | Select-Object TotalMinutes
    		$dfnmb=[int]($readfiledif.TotalMinutes/(-$testFrequency))
    		$dfnmb=$dfnmb+1
    	}
    	catch{
    		$dfnmb=1
    	}
	$LastMsmtTime = ((Get-Date).AddMinutes($dfnmb*($testfrequency))).ToUniversalTime()



    try{
        $filepath=$egurkhaPath+'/agent/'+$reportingname+'/'
	    $fileread2=Get-ChildItem -Path $filepath |Where-Object {$_.Name -like 'distgroups*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -index 1|Select Name
        if($fileread2 -ne $null){
	        $filepath2=$filepath+$fileread2.Name
	        $datpos = $fileread2.name.IndexOf(".dat")
	        $length='distgroups'.Length
	        $tmpvalue = $fileread2.name.toString().substring($length,($datpos-$length)) 
	        $kfileval2 = "kdistgroups"+$tmpvalue+".dat"
   	        $kfile2=Get-ChildItem -Path $filepath |Where-Object {$_.Name -eq $kfileval2}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
	        $kfilename2=([String]$kfile2.Name).Trim()
	        $kvalue2=Get-Content -Path $filepath$kfilename2 -Encoding $encTyp
	        $decrypPath2=$filepath2 -replace (".csv",".dat") 
	        $recpFile2=Unprotect-File $decrypPath2 -Algorithm AES -KeyAsPlainText $kvalue2	
	        $recipnt2= import-csv $recpFile2 -Encoding $encTyp
            if([System.IO.File]::Exists($recpFile2) -eq 'True'){
	            Remove-Item $recpFile2
            }
        }
    }
    catch{
        $recpFile2=""
        $errmsg=$_.Exception.Message
        Write-Host $errmsg
    }


	$dsgrp_groups=@{}

	foreach($total in $disbtedgrp)
	{
	    $grouptype=($total.GroupType).Trim()
	    if($grouptype.StartsWith('Universal,'))
	    {

		$grouptype=$grouptype.Substring(('Universal,'.Length)).Trim()
	    }
	    if($dsgrp_groups.ContainsKey($grouptype))
	    {
	    }
	    else
	    {
		Write-Host 'grouptype##' $grouptype
		$dsgrp_groups[$grouptype]=@{}
		$dsgrp_groups[$grouptype]['dsgrp_changedcnt'] = 0
		$dsgrp_groups[$grouptype]['dsgrp_createdcnt'] = 0
		$dsgrp_groups[$grouptype]['dsgrp_totalcnt'] = 0
		$dsgrp_groups[$grouptype]['dsgrp_ownlesscnt'] = 0
		$dsgrp_groups[$grouptype]['dsgrp_emptycnt'] = 0
		$dsgrp_groups[$grouptype]['dsgrp_softdetedcnt']=0

	    }
	}


	foreach($total in $disbtedgrp)
	{
       $totChangedUTC=([String]$total.WhenChangedUTC.Replace('??','')).Trim()
	   $totCreatedUTC=([String]$total.WhenCreatedUTC.Replace('??','')).Trim()
       try{
        if($totChangedUTC -ne $null -and $totChangedUTC -ne ''){
            $total.WhenChangedUTC=Eg-ParseExact -dateStr $totChangedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
        }
        if($totCreatedUTC -ne $null -and $totCreatedUTC -ne ''){
            $total.WhenCreatedUTC=Eg-ParseExact -dateStr $totCreatedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
        }
        #$total.WhenChangedUTC=[DateTime]::ParseExact(($total.WhenChangedUTC),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        #$total.WhenCreatedUTC=[DateTime]::ParseExact(($total.WhenCreatedUTC),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
       }catch{
            $exp=$_.Exception.Message
            Write-Error 'error occures while changing data format in 1st loop' $exp 
       }

	    $grouptype=($total.GroupType).Trim()
        $intialgrptype=$grouptype
	    if($grouptype.StartsWith('Universal,'))
	    {

		$grouptype=$grouptype.Substring(('Universal,'.Length)).Trim()
        

	    }
	    if($dsgrp_groups.ContainsKey($grouptype))
	    {

		$status=$total.isvalid
		if($status -eq 'True')
		{
			$status='Active'
		}
		else
		{
			$status='Inactive'
		}
	     
		$dsgrp_groups[$grouptype]['dsgrp_totalcnt']++
		if($total.ManagedBy -eq "" -or $total.ManagedBy -eq $Null )
		{
		    Write-Host $grouptype 'dsgrp_orphndgrp#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['dsgrp_ownlesscnt']++
		}
		if ($total.WhenChangedUTC -ne "" -and [DateTime]($total.WhenChangedUTC) -gt $LastMsmtTime)  
		{
		    Write-Host $grouptype 'dsgrp_changedutc#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['dsgrp_changedcnt']++
		}

		if ($total.WhenCreatedUTC -ne "" -and [DateTime]($total.WhenCreatedUTC) -gt $LastMsmtTime)  
		{
		    Write-Host $grouptype 'dsgrp_createdutc#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['dsgrp_createdcnt']++
		}

		if ($total.GroupMemberscount -eq 0)
		{
		    Write-Host $grouptype 'dsgrp_emptygrp#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' '-5' '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		    $dsgrp_groups[$grouptype]['dsgrp_emptycnt']++
		}

        if($intialgrptype.StartsWith('Universal,'))
        {
            $grouptype='Universal'
		    $dsgrp_groups[$grouptype]['dsgrp_totalcnt']++
		    if($total.ManagedBy -eq "" -or $total.ManagedBy -eq $Null )
		    {
		        Write-Host $grouptype 'dsgrp_orphndgrp#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		        $dsgrp_groups[$grouptype]['dsgrp_ownlesscnt']++
		    }
		    if ($total.WhenChangedUTC -ne "" -and [DateTime]($total.WhenChangedUTC) -gt $LastMsmtTime)  
		    {
		        Write-Host $grouptype 'dsgrp_changedutc#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		        $dsgrp_groups[$grouptype]['dsgrp_changedcnt']++
		    }

		    if ($total.WhenCreatedUTC -ne "" -and [DateTime]($total.WhenCreatedUTC) -gt $LastMsmtTime)  
		    {
		        Write-Host $grouptype 'dsgrp_createdutc#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		        $dsgrp_groups[$grouptype]['dsgrp_createdcnt']++
		    }

		    if ($total.GroupMemberscount -eq 0)
		    {
		        Write-Host $grouptype 'dsgrp_emptygrp#'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status'~!~' '-5' '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		        $dsgrp_groups[$grouptype]['dsgrp_emptycnt']++
		    }            
	    }

       }
	}

    if($recipnt2 -ne "" -and $recipnt2 -ne $null){
      foreach($total2 in $recipnt2)
      {
        $tot2ChangedUTC=([String]$total2.WhenChangedUTC.Replace('??','')).Trim()
	    $tot2CreatedUTC=([String]$total2.WhenCreatedUTC.Replace('??','')).Trim()
        try{
            if($tot2ChangedUTC -ne $null -and $tot2ChangedUTC -ne ''){
                $total2.WhenChangedUTC=Eg-ParseExact -dateStr $tot2ChangedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }
            if($tot2CreatedUTC -ne $null -and $tot2CreatedUTC -ne ''){
                $total2.WhenCreatedUTC=Eg-ParseExact -dateStr $tot2CreatedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }
            #$total2.WhenChangedUTC=[DateTime]::ParseExact(($total2.WhenChangedUTC),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            #$total2.WhenCreatedUTC=[DateTime]::ParseExact(($total2.WhenCreatedUTC),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        }catch{
            $exp=$_.Exception.Message
            Write-Error 'error occures while changing data format in 2nd loop' $exp 
        }
        $grouptype=($total2.GroupType).Trim()
        $intialgrptype=$grouptype
	    if($grouptype.StartsWith('Universal,'))
	    {

		$grouptype=$grouptype.Substring(('Universal,'.Length)).Trim()
	    }

		$status=$total2.isvalid
		if($status -eq 'True')
		{
			$status='Active'
		}
		else
		{
			$status='Inactive'
		}        


        $smtpadrs=$total2.PrimarySmtpAddress
        $bolean=$false
        foreach($total in $disbtedgrp)
	    {
        
            if($smtpadrs -eq $total.PrimarySmtpAddress)
            {
                $bolean=$true
	        }
        }

        if($recipnt2 -ne "" -and $recipnt2 -ne $null -and $bolean -eq $false)
        {
		    Write-Host $grouptype 'dsgrp_softdetedgrp#'$total2.DisplayName'~!~'$total2.PrimarySmtpAddress'~!~'$total2.Alias'~!~'$status'~!~' $total2.GroupMemberscount '~!~'$total2.WhenChangedUTC'~!~'$total2.WhenCreatedUTC           
		    $dsgrp_groups[$grouptype]['dsgrp_softdetedcnt']++

            if($intialgrptype.StartsWith('Universal,'))
            {
              $grouptype='Universal'
              Write-Host $grouptype 'dsgrp_softdetedgrp#'$total2.DisplayName'~!~'$total2.PrimarySmtpAddress'~!~'$total2.Alias'~!~'$status'~!~' $total2.GroupMemberscount '~!~'$total2.WhenChangedUTC'~!~'$total2.WhenCreatedUTC           
		      $dsgrp_groups[$grouptype]['dsgrp_softdetedcnt']++
  
            }
	    }
       }
     }



	foreach($grup  in $dsgrp_groups.Keys)
	{
	    foreach($key in $dsgrp_groups[$grup].Keys)
	    {
		Write-Host $grup$key  $dsgrp_groups[$grup][$key]
	    }
	}
[System.GC]::GetTotalMemory($true) | out-null

