﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=(($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()
$shwTopNDD=[int]$TestInputs[5]
$fetchDomains=$TestInputs[6].ToString().Trim()
$rptNam=$TestInputs[7]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.Avg Audio Degradation','Measures.Avg Jitter','Measures.Avg Jitter Max','Measures.Avg Packet Loss Rate','Measures.Avg Packet Loss Rate Max','Measures.Avg Send Listen MOS','Measures.Avg Overall Avg Network MOS','Measures.Avg Ratio Concealed Samples','Measures.Avg Ratio Stretched Samples','Measures.Avg Round Trip','Measures.Avg Round Trip Max'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Date','AllStreams.Hour','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
#####################################################
$componentnam='Microsoft_Teams_domain'
$ps1FileName=$MyInvocation.MyCommand.Name
$isRunMainset=$false
$sprsetNam=Domains-GetSuperset -UserName $userName -Password $password -ProxyServerIP $proxyserverip -ProxyUser $proxyUsr -ProxyPassword $proxyPass

$ticks_dtlsArr= Domains-ReadFrmINI -ps1FileName $ps1FileName -RptName $rptNam -ComponentName $componentnam -EncType $encTyp
if($ticks_dtlsArr -eq $null -or $ticks_dtlsArr.Count -eq 0){
    $curTicks=(get-Date).Ticks
    Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $rptNam -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
    $isRunMainset=$true
}else{
    $curTicks=(get-Date).Ticks
    $stTicks=[long]$ticks_dtlsArr[2]
    $TimeFromTicks = [datetime]$stTicks
    $diff=((get-Date)-$TimeFromTicks)
    if($mPeriodInMin -le $diff.Minutes){
        Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $rptNam -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
        $isRunMainset=$true
    }  
}

$superSetPath='MTM/'+$sprsetNam
$superSetDir=$egurkhaPath+'/agent/MTM/'+$sprsetNam
if(!(Test-Path -Path $superSetDir )){
    New-Item -ItemType directory -Path $superSetDir
}
##################################################
if($isRunMainset){
    $sNetwrkSum=Eg-WriteFile -ComntRptPath $superSetPath -FileName "MTDNetwrkQtySummary" -keyFileName "kMTDNetwrkQtySummary" -EgPath $egurkhaPath
    Try{
        Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled} | Sort-Object -Property 'End Time' -Descending |  Export-Csv $sNetwrkSum[1] -Encoding $encTyp #-Descending
    }
    Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg
    }
    $null=Protect-File  $sNetwrkSum[1] -Algorithm AES -KeyAsPlainText $sNetwrkSum[0] -RemoveSource
    [System.GC]::GetTotalMemory($true) | out-null
}

$readfiles=Eg-ReadFile -ComntRptPath $superSetPath -FileName "MTDNetwrkQtySummary" -keyFileName "kMTDNetwrkQtySummary" -EgPath $egurkhaPath
if([System.IO.File]::Exists($readfiles[1]) -eq 'True'){
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $NwQtySummryCSV=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $mtdNwQtySummry= import-csv $NwQtySummryCSV -Encoding $encTyp
    Remove-Item $NwQtySummryCSV
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTDNetwrkQtySummary' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTDNetwrkQtySummary' -InputFile $readfiles[4]

    $NtwkQltySmryStrms=@()
    $rptPath='MTM/'+$rptNam
    $MyDir=$egurkhaPath+'/agent/MTM/'+$rptNam
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
    Try{
        $mtdNwSmmryStm = Eg-WriteFile -ComntRptPath $rptPath -FileName "MTDNetwrkQtySummary" -keyFileName "kMTDNetwrkQtySummary" -EgPath $egurkhaPath
        foreach($resStrms in $mtdNwQtySummry){  
            $frstUPNDomain=([String]$resStrms.'First UPN').Trim()
            $secUPNDomain=([String]$resStrms.'Second UPN').Trim()
            if($frstUPNDomain -ne $null -and $frstUPNDomain -ne ''){$frstUPNDomain=$frstUPNDomain.Split('@')[1]}
            if($secUPNDomain -ne $null -and $secUPNDomain -ne ''){$secUPNDomain = $secUPNDomain.Split('@')[1]}
            if(($frstUPNDomain -ne $null -and $frstUPNDomain -ne '' -and $fetchDomains -match $frstUPNDomain) -or ($secUPNDomain -ne $null -and $secUPNDomain -ne '' -and $fetchDomains -match $secUPNDomain)){
                $NtwkQltySmryStrms+=$resStrms
                $resStrms| Export-Csv $mtdNwSmmryStm[1] -Encoding $encTyp -Append
            }
        }
        $null=Protect-File  $mtdNwSmmryStm[1] -Algorithm AES -KeyAsPlainText $mtdNwSmmryStm[0] -RemoveSource
    }
    Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "fetchdomain Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg
    }

    #############################################

    $NtwkQltySmryOutput=@()
    if($rptTimNUPN -ne 'none'){
        foreach($strms in $NtwkQltySmryStrms){
	    if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
            if($iswrite){
                $NtwkQltySmryOutput+=$strms
            }
            $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
            if($rptTimNUPN -eq $chktimNam){
                $iswrite=$true
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $NtwkQltySmryStrms){
	    if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $NtwkQltySmryOutput+=$strms 
                }
            }
        }
    }
    $lastObj=$NtwkQltySmryStrms |Select-Object -First 1
    $rptEdTimNUPN='LastReporting EndTime and UPN#'+$lastObj.'End Time'+'~'+$lastObj.'First UPN'+'~'+$lastObj.'Second UPN'
    Write-Host $rptEdTimNUPN

    if($NtwkQltySmryOutput){
        $AvgAudioDegradation = 0
        $AvgJitter = 0
        $AvgJitterMax = 0
        $AvgPacketLossRate = 0
        $AvgPacketLossRateMax = 0
        $AvgSendListenMOS = 0
        $AvgOverallAvgNetworkMOS = 0
        $AvgRatioConcealedSamples = 0
        $AvgRatioStretchedSamples = 0
        $AvgRoundTrip = 0
        $AvgRoundTripMax = 0

        if($NtwkQltySmryOutput){
            Write-host '*********************  AvgAudioDegradation measure***********************'
            $AvgAudioDegradationlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Audio Degradation')  -and $_.'Avg Audio Degradation' -ne 'NaN' -and $_.'Avg Audio Degradation' -gt 0.0001}
            $AvgAudioDegradation = ($AvgAudioDegradationlist | Measure-Object "Avg Audio Degradation" -Average | select Average).Average
            if(-not $AvgAudioDegradation){  $AvgAudioDegradation=0 }  else { $AvgAudioDegradation=$AvgAudioDegradation.ToString("#.##") }
            $AvgAudioDegradationlist=$null

            Write-host '*********************  AvgJitter measure ***********************'
            $AvgJitterlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Jitter')  -and $_.'Avg Jitter' -ne 'NaN' -and $_.'Avg Jitter' -gt 0.0001} 
            $AvgJitter = ($AvgJitterlist | Measure-Object "Avg Jitter" -Average | select Average).Average
            if(-not $AvgJitter){  $AvgJitter=0 } else { $AvgJitter=$AvgJitter.ToString("#.##") }
            if($AvgJitter){
                $ddlist = $AvgJitterlist | Where-Object { $_."Avg Jitter" -gt 0.0001 } | Sort-Object { $_."Avg Jitter" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddlist){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddAvgJitter#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Avg Jitter'
                }
                $ddlist=$null
            }
            $AvgJitterlist=$null

            Write-host '********************* AvgJitterMax measure ***********************'
            $AvgJitterMaxlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Jitter Max')  -and $_.'Avg Jitter Max' -ne 'NaN' -and $_.'Avg Jitter Max' -gt 0.0001} 
            $AvgJitterMax = ($AvgJitterMaxlist | Measure-Object "Avg Jitter Max" -Average | select Average).Average
            if(-not $AvgJitterMax){  $AvgJitterMax=0 } else { $AvgJitterMax=$AvgJitterMax.ToString("#.##") }
            $AvgJitterMaxlist=$null

            Write-host '*********************  AvgPacketLossRate measure ***********************'
            $AvgPacketLossRatelist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Packet Loss Rate')  -and $_.'Avg Packet Loss Rate' -ne 'NaN' -and $_.'Avg Packet Loss Rate' -gt 0.0001 } 
            $AvgPacketLossRate = ($AvgPacketLossRatelist | Measure-Object "Avg Packet Loss Rate" -Average | select Average).Average
            if(-not $AvgPacketLossRate){  $AvgPacketLossRate=0 } else { $AvgPacketLossRate=($AvgPacketLossRate*100).ToString("#.##") }
            $AvgPacketLossRatelist=$null

            Write-host '*********************  AvgPacketLossRateMax measure***********************'
            $AvgPacketLossRateMaxlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Packet Loss Rate Max')  -and $_.'Avg Packet Loss Rate Max' -ne 'NaN' -and $_.'Avg Packet Loss Rate Max' -gt 0.0001 } 
            $AvgPacketLossRateMax = ($AvgPacketLossRateMaxlist | Measure-Object "Avg Packet Loss Rate Max" -Average | select Average).Average
            if(-not $AvgPacketLossRateMax){  $AvgPacketLossRateMax=0 }  else { $AvgPacketLossRateMax=($AvgPacketLossRateMax*100).ToString("#.##") }
            $AvgPacketLossRateMaxlist=$null

            Write-host '*********************  AvgSendListenMOS measure***********************'
            $AvgSendListenMOSlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Send Listen MOS')  -and $_.'Avg Send Listen MOS' -ne 'NaN' -and $_.'Avg Send Listen MOS' -gt 0.0001 } 
            $AvgSendListenMOS = ($AvgSendListenMOSlist | Measure-Object "Avg Send Listen MOS" -Average | select Average).Average
            if(-not $AvgSendListenMOS){  $AvgSendListenMOS=0 } else { $AvgSendListenMOS=$AvgSendListenMOS.ToString("#.##") }
            $AvgSendListenMOSlist=$null

            Write-host '*********************  AvgOverallAvgNetworkMOS measure***********************'
            $AvgOverallAvgNetworkMOSlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Overall Avg Network MOS')  -and $_.'Avg Overall Avg Network MOS' -ne 'NaN' -and $_.'Avg Overall Avg Network MOS' -gt 0.0001 } 
            $AvgOverallAvgNetworkMOS = ($AvgOverallAvgNetworkMOSlist | Measure-Object "Avg Overall Avg Network MOS" -Average | select Average).Average
            if(-not $AvgOverallAvgNetworkMOS){  $AvgOverallAvgNetworkMOS=0 } else { $AvgOverallAvgNetworkMOS=$AvgOverallAvgNetworkMOS.ToString("#.##") }
            $AvgOverallAvgNetworkMOSlist=$null

            Write-host '*********************  AvgRatioConcealedSamples measure***********************'
            $AvgRatioConcealedSampleslist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Ratio Concealed Samples')  -and $_.'Avg Ratio Concealed Samples' -ne 'NaN' -and $_.'Avg Ratio Concealed Samples' -gt 0.0001} 
            $AvgRatioConcealedSamples = ($AvgRatioConcealedSampleslist  | Measure-Object "Avg Ratio Concealed Samples" -Average | select Average).Average
            if(-not $AvgRatioConcealedSamples){  $AvgRatioConcealedSamples=0 } else { $AvgRatioConcealedSamples=($AvgRatioConcealedSamples*100).ToString("#.##") }
            $AvgRatioConcealedSampleslist=$null

            Write-host '********************* AvgRatioStretchedSamples measure ***********************'
            $AvgRatioStretchedSampleslist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Ratio Stretched Samples')  -and $_.'Avg Ratio Stretched Samples' -ne 'NaN' -and $_.'Avg Ratio Stretched Samples' -gt 0.0001 } 
            $AvgRatioStretchedSamples = ($AvgRatioStretchedSampleslist  | Measure-Object "Avg Ratio Stretched Samples" -Average | select Average).Average
            if(-not $AvgRatioStretchedSamples){  $AvgRatioStretchedSamples=0 } else { $AvgRatioStretchedSamples=($AvgRatioStretchedSamples*100).ToString("#.##") }
            $AvgRatioStretchedSampleslist=$null

            Write-host '********************* AvgRoundTrip measure ***********************'
            $AvgRoundTriplist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Round Trip')  -and $_.'Avg Round Trip' -ne 'NaN' -and $_.'Avg Round Trip' -gt 0.0001 } 
            $AvgRoundTrip = ($AvgRoundTriplist  | Measure-Object "Avg Round Trip" -Average | select Average).Average
            if(-not $AvgRoundTrip){  $AvgRoundTrip=0 } else { $AvgRoundTrip=$AvgRoundTrip.ToString("#.##") }
            $AvgRoundTriplist=$null

            Write-host '********************* AvgRoundTripMax measure ***********************'
            $AvgRoundTripMaxlist =$NtwkQltySmryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg Round Trip Max')  -and $_.'Avg Round Trip Max' -ne 'NaN' -and $_.'Avg Round Trip Max' -gt 0.0001} 
            $AvgRoundTripMax = ($AvgRoundTripMaxlist  | Measure-Object "Avg Round Trip Max" -Average | select Average).Average
            if(-not $AvgRoundTripMax){  $AvgRoundTripMax=0 } else { $AvgRoundTripMax=$AvgRoundTripMax.ToString("#.##") }
            $AvgRoundTripMaxlist=$null

            Write-Host 'measures##' $AvgAudioDegradation ~ $AvgJitter ~ $AvgJitterMax ~ $AvgPacketLossRate ~ $AvgPacketLossRateMax ~ $AvgSendListenMOS ~ $AvgOverallAvgNetworkMOS ~ $AvgRatioConcealedSamples ~ $AvgRatioStretchedSamples ~ $AvgRoundTrip ~ $AvgRoundTripMax
        }
    }
}
[System.GC]::GetTotalMemory($true) | out-null