[CmdletBinding()]
param
(
    [Parameter(Mandatory=$True)] [string] $deliveryGroupName,
    [string] $VDAList,
    [Parameter(Mandatory=$True)] [string] $action
)
Function PingServer()
{
    param([string] $hostname)
    $result = ([System.Net.NetworkInformation.Ping]::new().Send($hostname)).Status
    if($result -ne 'Success') {return $false} else {return $true}
}
Add-PSSnapin Citrix.Broker.*
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$MaxRecordCount = 250
$VDAs = $VDAList -split ","
$allVMs = @()
do
{
    "Checking for registered managed powered on machines in the delivery group $deliveryGroupName"
    foreach($VDA in $VDAs)
    {
        $VMs = @(Get-BrokerMachine -DesktopGroupName $deliveryGroupName -RegistrationState UnRegistered -PowerState Unmanaged -PowerActionPending $false -MaxRecordCount $MaxRecordCount -InMaintenanceMode $true | ?{$_.DnsName -like "*$VDA*"} | select-object machinename)
        if($VMs.count -gt 0)
        {
            $allVMs += $VMs
        }
    }
} while ($VMs.count -ge $MaxRecordCount)
if($allVMs)
{
    foreach($item in $allVMs)
    {
        $computer = $item.machinename.split('\').item(1)
        $PingStatus = PingServer -hostname $computer
        if($PingStatus -eq $true)
        {
            try {
                if($action -eq 'Shutdown')
                {
                    New-BrokerHostingPowerAction -MachineName $computer -Action ‘ShutDown’ -ErrorAction stop
                    "Sent the Shutdown request to the computer $computer successfully using the hosting power action."
                }
                elseif ($action -eq 'Restart') {
                    New-BrokerHostingPowerAction -MachineName $computer -Action ‘Restart’ -ErrorAction stop
                    "Sent the Restart request to the computer $computer successfully using the hosting power action."
                }
            }
            catch {
                "Error in shutdown the machine $computer."
            }
        }
        else {
            "The machine $computer has shutdown already."
        }
    }
}
else {
    "No managed registered powered on machines matched with the given inputs."   
}
Remove-pssnapin Citrix.Broker.*