$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
$username = $args[0]
$Query = "*[EventData[Data[@Name='PrincipalSamName'] and (Data='$username')]] and *[System[(EventID='4001')]]"
try
{

    # Gets all the events matching the criteria by $Query
    [array]$Events = Get-WinEvent -ProviderName Microsoft-Windows-GroupPolicy -FilterXPath "$Query"
    $ActivityId = $Events[0].ActivityId.Guid
}
catch
{
    Write-Host "Could not find relevant events in the Microsoft-Windows-GroupPolicy/Operational log."
    Write-Host "The default log size (4MB) only supports user sessions that logged on a few hours ago."
    write-Host "Please increase the log size to support older sessions."
    Exit 1
}

try
{

    # Gets all events that match event id 4016,5016,6016 and 7016 and correlated with the activity id of event id 4001.
    [array]$CSEarray = Get-WinEvent -ProviderName Microsoft-Windows-GroupPolicy -FilterXPath @"
        *[System[(EventID='4016' or EventID='5016' or EventID='6016' or EventID='7016') and Correlation[@ActivityID='{$ActivityID}']]]
"@
}
catch
{
    Write-Host "Could not find relevant events in the Microsoft-Windows-GroupPolicy/Operational log"
    write-host "It's seems like there are no Client Side Extensions applied to your session."
    Exit 1
}

$Output = @()
foreach ($i in ($CSEarray | Where-Object {$_.Id -eq '4016'}))
{
     $obj = New-Object -TypeName psobject
     $obj | Add-Member -MemberType NoteProperty -Name Name -Value ($i.Properties[1] | Select-Object -ExpandProperty Value)
     $obj | Add-Member -MemberType NoteProperty -Name GPOs -Value (($i.Properties[5] | Select-Object -ExpandProperty Value).trimend("`n") -replace "`n",", ")
     # Every object in output has CSE Name and String of all the GPO Names.
     $Output += $obj
}

# Run only for for event id 5016,6016 and 7016 records.
foreach ($i in ($CSEarray | Where-Object {$_.Id -ne '4016'}))
{
     $Output | Where-Object {$_.Name -eq ($i.Properties[2] | Select-Object -ExpandProperty Value)} | Add-Member -MemberType NoteProperty -Name ErrorCode -Value ($i.Properties[1] | Select-Object -ExpandProperty Value)
}

write-host "CSEName","ErrorCode","GPOs" -separator "^^"
foreach($o in $Output)
{
	if($o.ErrorCode -eq 0)
	{
		$gstr = $o.GPOs -join ","
		write-host $o.Name,"None", $gstr -separator "^^" 		
	}
}

if (($Output.ErrorCode | Measure-Object -Sum).Sum -ne 0)
{
	#Write-Host "Group Policy Client Side Extenstions with an error"
	foreach($o in $Output)
	{
		$gstr = $o.GPOs -join ","
		write-host $o.Name,$o.ErrorCode, $gstr -separator "^^" 		
	}
}