﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[bool]$bCleanMgr = $false
[bool]$bVolumeShadowCopy = $false

if($args[0] -eq 'True')
{
    [bool]$bCleanMgr = $true
}
if($args[1] -eq 'True')
{
    [bool]$bVolumeShadowCopy = $true
}


#Keys to set CLEANMGR to clean, remove unwanted entries
[array]$arrSageSetKeys = @(
    'Active Setup Temp Folders',
    'BranchCache',
    'Compress System Disk',
    'Content Indexer Cleaner',
    'D3D Shader Cache',
    'Delivery Optimization Files',
    'Device Driver Packages',
    'Diagnostic Data Viewer database files',
    'Downloaded Program Files',
    'Internet Cache Files',
    'Offline Pages Files',
    'Old ChkDsk Files',
    'Previous Installations',
    'Recycle Bin',
    'RetailDemo Offline Content',
    'Service Pack Cleanup',
    'Setup Log Files',
    'System error memory dump files',
    'System error minidump files',
    'Temporary Files',
    'Temporary Setup Files',
    'Temporary Sync Files',
    'Thumbnail Cache',
    'Update Cleanup',
    'Upgrade Discarded Files',
    'User file versions',
    'Users Download Folder',
    'Windows Defender',
    'Windows Error Reporting Archive Files',
    'Windows Error Reporting Queue Files',
    'Windows Error Reporting System Archive Files',
    'Windows Error Reporting System Queue Files',
    'Windows Error Reporting Files',
    'Windows ESD installation files',
    'Windows Upgrade Log Files'
    
)

#Get current disk free space
[string]$SystemDriveLetter = [System.Environment]::ExpandEnvironmentVariables("%systemdrive%") -replace (':','')
$SystemDrive = Get-PSDrive -Name $SystemDriveLetter
[double]$FreeSpace = $SystemDrive.Free

#Keep track of files we can not delete the files
[long]$lSkippedFileCount = 0


If ($bCleanMgr)
{
    # Write-Host "bCleanMgr: $bCleanMgr "
    $CleanMgrPath = [System.Environment]::ExpandEnvironmentVariables("%systemroot%\System32\cleanmgr.exe")
    
    If (Test-Path ($CleanMgrPath))
    {
        [string]$strRegPath = 'HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches'
    
        Foreach ($key in $arrSageSetKeys)
        {

            try
            {
                # Check if the path actually exists before trying to set the key (keys exisitng can depend on OS< patch level etc)
                If (Test-Path "$strRegPath\$key")
                {
                    New-ItemProperty -Path "$strRegPath\$key" -Name 'StateFlags0066' -Value 2 -PropertyType DWORD -Force | Out-Null
                }
            }
            catch
            {
 
            }
        }
        # Run CLEANMGR as a Job, so a time out can be used because cleanmgr sometimes hangs if run silently
        try
        {
            # Set timeout 
            [int]$intTimeOut = 600

           #Write-Host "intTimeOut: $intTimeOut "
            $CodeBlock = {
                Start-Process $CleanMgrPath -Wait -ArgumentList '/SAGERUN:66'
            }
            # Start the job
            $Job = Start-Job -ScriptBlock $CodeBlock

            # Wait for the job to complete
            Wait-Job $Job -Timeout $intTimeOut | Out-Null

            # Has the job completed?
            If ($Job.State -ne 'Completed')
            {
                Write-Host "CLEANMGR did not complete in the specified time of $intTimeOut seconds. So killing it now."
                Stop-Process $CleanMgrPath -Force
            }

            # Cleanup
            Remove-Job $Job
        }
        catch
        {
        }
    }
    else
    {
        Write-Host "CleanMgr.exe is not available on this system. It can be installed by installing the Desktop Experience feature."
    }
}

# Clean Volume Shadow Copies if required

If ($bVolumeShadowCopy -eq $true)
{
   # Write-Host "bVolumeShadowCopy: $bVolumeShadowCopy "

    try
    {
        vssadmin.exe delete shadows /All /Quiet | Out-Null
    }
    catch
    {
        Write-Host "Volume Shadow Copies could not be deleted."
    }
}




#Write space gained to console
$SystemDrive = Get-PSDrive -Name $SystemDriveLetter
[double]$NewFreeSpace = $SystemDrive.Free
[double]$SpaceFreed = [math]::Round((($NewFreeSpace - $FreeSpace) /1MB),2)
Write-Host "$SpaceFreed MB of disk space freed"
