﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin "XDCommands"

Write-Host "Allocated virtaul Desktops"
Write-Host "-------------------------"
$dgroups = Get-XdDesktopGroup 
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		if($i.Folder.Name -ne "\")
		{
			$temp = $i.Folder.Name + "\" + $i.Name
			$vds = Get-XdVirtualDesktop -Group $i
			if($vds -ne $null)
			{
				foreach ($vd in $vds)
				{
					Write-Host($vd.Name,$temp,$vd.State) -Separator ";"	
				}
			}
		}
		else
		{
			$vds = Get-XdVirtualDesktop -Group $i
			if($vds -ne $null)
			{
				foreach ($vd in $vds)
				{
					Write-Host($vd.Name,$vd.GroupName,$vd.State) -Separator ";"	
				}
			}
		}
	}
}
Write-Host "Available Virtual Desktops"
Write-Host "----------------------------"
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		if($i.Folder.Name -ne "\")
		{
			$temp = $i.Folder.Name + "\" + $i.Name
			$hs = $i.HostingSettings.HostingServer
			$vms = Get-XdHostedMachine $hs
			if($vms -ne $null)
			{
				foreach($vm in $vms)
				{
					Write-Host($temp,$vm.HostingName,$vm.Name) -Separator ";"
				}
			}
		}
		else
		{
			$hs = $i.HostingSettings.HostingServer
			$vms = Get-XdHostedMachine $hs
			if($vms -ne $null)
			{
				foreach($vm in $vms)
				{
					Write-Host($i.Name,$vm.HostingName,$vm.Name) -Separator ";"
				}
			}	
		}
		
	}
}

Remove-PSSnapin "XDCommands"








