$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Admin Server"
	break
}

$adminServer = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$adminConn = New-XdAdminConnection -Name $adminServer
$xenFarm = Get-XdFarm -AdminConnection $adminConn

$dgroups = Get-XdDesktopGroup 
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		Write-Host($i.Name,$i.Enabled) -Separator ";" 
	}
}


Disconnect-XdAdminConnection -AdminConnection $adminConn
