# This Script gives Unregistered desktops for sitewide - Citrix XenDesktop 5
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-pssnapin "Citrix.Common.Commands"
Add-pssnapin "Citrix.Host.Admin.V1"
Add-pssnapin "Citrix.Broker.Admin.V1"


Write-Host "Desktop Groups"
Write-Host "--------------"
$DesktopGroups = Get-BrokerDesktopGroup -MaxRecordCount 2147483647
if($DesktopGroups -ne $null)
{
	foreach($DesktopGroup in $DesktopGroups)
	{
		Write-Host $DesktopGroup.Name
	}
}


Write-Host "Virtual Desktops"
Write-Host "----------------"
if($DesktopGroups -ne $null)
{
	foreach($DesktopGroup in $DesktopGroups)
	{
		$BrokerDesktops = Get-BrokerDesktop -DesktopGroupUid $DesktopGroup.Uid -SummaryState Unregistered -MaxRecordCount 2147483647
		if ($BrokerDesktops -ne $null)
		{
			foreach($BrokerDesktop in $BrokerDesktops)
			{
				$IPAddress = "-"
				$OSType = "-"
				$HostedMachineName = "-"
				$HostingServerName = "-"
				$HypervisorConnectionName = "-"
				$LastConnectionFailure = "-"
				$LastConnectionTime = "-"
				$LastConnectionUser = "-"
				$AssociatedUserName = "-"
				$ImageOutOfDate = "-"
				if ( $BrokerDesktop.IPAddress.length -gt 0)
				{
					$IPAddress = $BrokerDesktop.IPAddress
				}
				if ($BrokerDesktop.OSType.length -gt 0)
				{
					$OSType = $BrokerDesktop.OSType
				}
				if ($BrokerDesktop.HostedMachineName.length -gt 0)
				{
					$HostedMachineName = $BrokerDesktop.HostedMachineName
				}
				if ($BrokerDesktop.HostingServerName.length -gt 0)
				{
					$HostingServerName = $BrokerDesktop.HostingServerName
				}
				if ($BrokerDesktop.HypervisorConnectionName.length -gt 0)
				{
					$HypervisorConnectionName = $BrokerDesktop.HypervisorConnectionName
				}
				if ($BrokerDesktop.LastConnectionFailure -ne $null)
				{
					$LastConnectionFailure = $BrokerDesktop.LastConnectionFailure
				}
				if ($BrokerDesktop.LastConnectionTime -ne $null)
				{
					$LastConnectionTime = $BrokerDesktop.LastConnectionTime
				}
				if ($BrokerDesktop.LastConnectionUser -gt 0)
				{
					$LastConnectionUser = $BrokerDesktop.LastConnectionUser
				}
				if ($BrokerDesktop.AssociatedUserName -ne $null -and $BrokerDesktop.AssociatedUserName.length -gt 0)
				{
					$AssociatedUsers = $BrokerDesktop.AssociatedUserName
					$AssociatedUser = ""
					$count = 0
					foreach ($key in $AssociatedUsers)
					{
						if ($count -eq 0)
						{
							$AssociatedUser = $key
						}
						else
						{
							$AssociatedUser = $AssociatedUser + "," + $key
						}
						$count = $count + 1
					}
					if ($AssociatedUser -eq $null -or $AssociatedUser.length -eq 0)
					{
						$AssociatedUserName = "-"
					}
					else
					{
						$AssociatedUserName = $AssociatedUser
					}
				}
				if ($BrokerDesktop.ImageOutOfDate -ne $null)
				{
					$ImageOutOfDate = $BrokerDesktop.ImageOutOfDate
				}
				Write-Host ($BrokerDesktop.MachineName,$BrokerDesktop.DNSName,$IPAddress,$OSType,$BrokerDesktop.PowerState,
				$BrokerDesktop.SummaryState,$BrokerDesktop.DesktopGroupName,$BrokerDesktop.DesktopKind,
				$HostedMachineName,$HostingServerName,$HypervisorConnectionName,$BrokerDesktop.CatalogName,$LastConnectionFailure,
				$LastConnectionTime,$LastConnectionUser,$AssociatedUserName,$ImageOutOfDate) -Separator ";"
			}
		}
	}
}


Remove-pssnapin "Citrix.Common.Commands"
Remove-pssnapin "Citrix.Host.Admin.V1"
Remove-pssnapin "Citrix.Broker.Admin.V1"

