$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$queues = get-queue -ResultSize unlimited
if($queues -ne $null)
{
    foreach($queue in $queues)
    {
        $status = $queue.Status
        $msgcount = $queue.MessageCount
        $Id = $queue.Identity
        $deliverytype = $queue.DeliveryType
        $nexthopdomain = $queue.NextHopDomain
        $retrycount = $queue.RetryCount
        $lockedmsgcount = $queue.LockedMessageCount
        $incomingrate = $queue.IncomingRate
        $outgoingrate = $queue.OutgoingRate
        $velocity = $queue.Velocity
        write-host($Id,$status,$msgcount,$incomingrate,$outgoingrate,$velocity,$retrycount,$lockedmsgcount,$deliverytype,$nexthopdomain) -separator ";"
    }
}
remove-pssnapin Microsoft.Exchange.Management.PowerShell.SnapIn