﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

clear
    ######***GUI  form ****#######
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button
   
$crtDtlLbl=New-Object System.Windows.Forms.Label
$crtAppLbl=New-Object System.Windows.Forms.Label
$crtAppTxtBx=New-Object System.Windows.Forms.TextBox
$crtAppIdLbl=New-Object System.Windows.Forms.Label
$crtAppIdTxtBx=New-Object System.Windows.Forms.TextBox     
$crtOrgLbl=New-Object System.Windows.Forms.Label
$crtOrgTxtBx=New-Object System.Windows.Forms.TextBox
$crtTPrntLbl=New-Object System.Windows.Forms.Label
$crtTPrntTxtBx=New-Object System.Windows.Forms.TextBox
  
$formsize = 206

$form.Controls.Add($crtDtlLbl)
$form.Controls.Add($crtAppLbl)
$form.Controls.Add($crtAppTxtBx)
$form.Controls.Add($crtAppIdLbl)
$form.Controls.Add($crtAppIdTxtBx)
$form.Controls.Add($crtOrgLbl)
$form.Controls.Add($crtOrgTxtBx)
$form.Controls.Add($crtTPrntLbl)
$form.Controls.Add($crtTPrntTxtBx)

$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "428 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'Update CBA App Details'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

<#
$crtDtlLbl.Location="38,15"  
$crtDtlLbl.Anchor="Bottom, Left"
$crtDtlLbl.Text="&O365 Cert Details:"
$crtDtlLbl.Size="200,20"
#>

$crtAppLbl.Location="58,18"  
$crtAppLbl.Anchor="Bottom, Left"
$crtAppLbl.Text="&App Name"
$crtAppLbl.Size="115,20"
$crtAppTxtBx.Location="175,18"  
$crtAppTxtBx.Name="appName"
$crtAppTxtBx.Size="200,20"
$crtAppTxtBx.Text=""

$crtAppIdLbl.Location="58,48"  
$crtAppIdLbl.Anchor="Bottom, Left"
$crtAppIdLbl.Text="&App ID"
$crtAppIdLbl.Size="115,20"
$crtAppIdTxtBx.Location="175,48"  
$crtAppIdTxtBx.Name="appId"
$crtAppIdTxtBx.Size="200,20"
$crtAppIdTxtBx.Text=""

$crtOrgLbl.Location="58,77" 
$crtOrgLbl.Anchor="Bottom, Left"
$crtOrgLbl.Text="&Org Name"
$crtOrgLbl.Size="115,20"
$crtOrgTxtBx.Location="175,77"
$crtOrgTxtBx.Name="orgNam"
$crtOrgTxtBx.Size="200,20"
$crtOrgTxtBx.Text=""

$crtTPrntLbl.Location="58,106" 
$crtTPrntLbl.Anchor="Bottom, Left"
$crtTPrntLbl.Text="&Cert Thumbprint"
$crtTPrntLbl.Size="115,20"
$crtTPrntTxtBx.Location="175,106"   
$crtTPrntTxtBx.Name="crtTPrnt"
$crtTPrntTxtBx.Size="200,20"
$crtTPrntTxtBx.Text=""
    
$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "175, 148"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'
$frmDialog=$form.ShowDialog()

if($frmDialog -eq 'OK' ){
    $appName=$crtAppTxtBx.Text
    $appId=$crtAppIdTxtBx.Text
    $orgNam=$crtOrgTxtBx.Text
    $crtTPrnt=$crtTPrntTxtBx.Text
    if($appName -eq "" -or $appId -eq "" -or $orgNam -eq "" -or $crtTPrnt -eq ""){
        Write-Host "Re-run the script with all the inputs...." -ForegroundColor Red
        Exit
    }else{
        $certDir=$egurkhaPath+'\agent\O365\AppInfo'
        if(!(Test-Path -Path $certDir)){
            $null=New-Item -ItemType directory -Path $certDir
        }

        $keyPath=$certDir+'\AppKey.dat'
        $unProtFile=$certDir+'\AppDetails.dat'
        if(Test-Path $unProtFile -PathType Leaf){
            $unProtPath=$certDir+'\AppDetails.dat'
            $kvalue=Get-Content -Path $keyPath
            Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        }

        $certDtlPath=$certDir+'\AppDetails.txt'
        if(Test-Path $certDtlPath -PathType Leaf){
            $lines=Get-Content -Path $certDtlPath
            $wpath1=$certDir+'\AppDetails1.txt'  
            $orgChk='-'+$orgNam
            $isExist=$False
            for($i=0;$i -lt $lines.Length;$i++){
                if($lines[$i] -match $orgChk){
                    $isExist=$true
                    $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                    $null='app_Id~'+$appId| Add-Content $wpath1 -PassThru
                    $null='org_Name~'+$orgNam| Add-Content $wpath1 -PassThru
                    $null='cer_ThumbPrint~'+$crtTPrnt| Add-Content $wpath1 -PassThru
                    ""| Add-Content $wpath1
                    $i=$i+4
                    continue
                }
                Add-Content -Path $wpath1 -Value $lines[$i]
            }
            if(!$isExist){
                $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                $null='app_Id~'+$appId| Add-Content $wpath1 -PassThru
                $null='org_Name~'+$orgNam| Add-Content $wpath1 -PassThru
                $null='cer_ThumbPrint~'+$crtTPrnt| Add-Content $wpath1 -PassThru
                ""| Add-Content $wpath1
            }
            Remove-Item $certDtlPath
            if(Test-Path $wpath1 -PathType Leaf){
                Rename-Item $wpath1 'AppDetails.txt'
            } 
        }else{
            $null='['+$appName+'-'+$orgNam+']'| Add-Content $certDtlPath
            $null='app_Id~'+$appId| Add-Content $certDtlPath
            $null='org_Name~'+$orgNam| Add-Content $certDtlPath
            $null='cer_ThumbPrint~'+$crtTPrnt| Add-Content $certDtlPath
            ""| Add-Content $certDtlPath
        }

        $key=Get-CryptoKey -FileDir $certDir -FileName '\AppKey.dat'
        $null=Protect-File $certDtlPath -Algorithm AES -KeyAsPlainText $key -RemoveSource
        Write-Host 'CertInfo dat file created successfully'
    }
}else{
    Write-Host "you have cancelled the script..." -ForegroundColor Red
    Exit
}
if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}