﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$Options=@()
$totModulues=''
$totUsrRoles=''
$totExoPermissns=''
$graph_DelHash=@{}
$graph_AppHash=@{}

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('Options')){
            $totOptions=$line.Replace('Options=','')
            $Options=$totOptions.Split('~')
        }
        if($line.StartsWith('Modules')){
            $totModulues=$line.Replace('Modules=','')
        }
        if($line.StartsWith('User_Roles')){
            $totUsrRoles=$line.Replace('User_Roles=','')
        }
        if($line.StartsWith('EXO_Permissions')){
            $totExoPermissns=$line.Replace('EXO_Permissions=','')
        }
        if($line.StartsWith('Graph_Del_permissions')){
            $totDelPermisn=$line.Replace('Graph_Del_permissions=','')
            $arrStr=$totDelPermisn.Split('~')
            foreach($perStr in $arrStr){   
                $arr=[String]$perStr -split '#'
                $graph_DelHash.Add($arr[0],$arr[1])
            }
        }
        if($line.StartsWith('Graph_App_permissions')){
            $totAppPermisn=$line.Replace('Graph_App_permissions=','')
            $arrStr=$totAppPermisn.Split('~')
            foreach($perStr in $arrStr){
                $arr=[String]$perStr -split '#'
                $graph_AppHash.Add($arr[0],$arr[1])
            }
            break;
        }
    }
    if($line.StartsWith('[Check_O365Prerequisites')){
        $isExist=$true
    }
}



$logDir=$egurkhaPath+'/agent/O365'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$WriteLog=$true
$LogFile = $logDir+"\CheckO365Prerequisites.log"
$LogFile1 = $logDir+"\CheckO365Prerequisites1.log"
$isFrstTimLog=$true

# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)
	[string]$date = Get-Date -Format G
    if ($WriteLog) {
        ( "[" + $date + "] -  [O365]  -  " + $string ) | Out-File -FilePath $LogFile -Append } 
    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }
}

function CacheObject ($Object) {
    if ($Object) {
        if (-not $script:ObjectByObjectClassId.ContainsKey($Object.ObjectType)) {
            $script:ObjectByObjectClassId[$Object.ObjectType] = @{}
        }
        $script:ObjectByObjectClassId[$Object.ObjectType][$Object.ObjectId] = $Object
        $script:ObjectByObjectId[$Object.ObjectId] = $Object
    }
}


function GetObjectByObjectId ($ObjectId) {
    if (-not $script:ObjectByObjectId.ContainsKey($ObjectId)) {
        Write-Verbose ("Querying Azure AD for object '{0}'" -f $ObjectId)
        try {
            $object = Get-AzureADObjectByObjectId -ObjectId $ObjectId
            CacheObject -Object $object
        } catch {
            Write-Verbose "Object not found."
        }
    }
    return $script:ObjectByObjectId[$ObjectId]
}


function GetOAuth2PermissionGrants ([switch]$FastMode) {
    if ($FastMode) {
        Get-AzureADOAuth2PermissionGrant -All $true
    } else {
        $script:ObjectByObjectClassId['ServicePrincipal'].GetEnumerator() | ForEach-Object { $i = 0 } {
            if ($ShowProgress) {
                Write-Progress -Activity "Retrieving delegated permissions..." `
                                -Status ("Checked {0}/{1} apps" -f $i++, $servicePrincipalCount) `
                                -PercentComplete (($i / $servicePrincipalCount) * 100)
            }

            $client = $_.Value
            Get-AzureADServicePrincipalOAuth2PermissionGrant -ObjectId $client.ObjectId
        }
    }
}


Function Get-AssignedPermissions{
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$applicationNam,
        [switch] $DelegatedPermissions,
        [switch] $ApplicationPermissions,
        [string[]] $UserProperties = @("DisplayName"),
        [string[]] $ServicePrincipalProperties = @("DisplayName"),
        [switch] $ShowProgress,
        [int] $PrecacheSize = 999
    )
    
    $err_delHash=@{}
    $err_AppHash=@{}
    $err_DelStat=''
    $err_AppStat=''
    foreach($key in $graph_DelHash.Keys){
        $val=[String]$graph_DelHash[$key]+','
        $err_delHash.Add($key,$val)
    }
    foreach($key in $graph_AppHash.Keys){
        $val=[String]$graph_AppHash[$key]+','
        $err_AppHash.Add($key,$val)
    }

    try {
        $tenant_details = Get-AzureADTenantDetail
    } catch {
        throw "You must call Connect-AzureAD before running this script."
    }
    Write-Verbose ("TenantId: {0}, InitialDomain: {1}" -f `
                    $tenant_details.ObjectId, `
                    ($tenant_details.VerifiedDomains | Where-Object { $_.Initial }).Name)

    $script:ObjectByObjectId = @{}
    $script:ObjectByObjectClassId = @{}

    $empty = @{} # Used later to avoid null checks

    Write-Verbose "Retrieving all ServicePrincipal objects..."
    Get-AzureADServicePrincipal -All $true | ForEach-Object {
        CacheObject -Object $_
    }
    $servicePrincipalCount = $script:ObjectByObjectClassId['ServicePrincipal'].Count

    if ($DelegatedPermissions -or (-not ($DelegatedPermissions -or $ApplicationPermissions))) {
        Write-Verbose ("Retrieving up to {0} User objects..." -f $PrecacheSize)
        Get-AzureADUser -Top $PrecacheSize | Where-Object {
            CacheObject -Object $_
        }
        Write-Verbose "Testing for OAuth2PermissionGrants bug before querying..."
        $fastQueryMode = $false
        try {
            $null = Get-AzureADOAuth2PermissionGrant -Top 999
            $fastQueryMode = $true
        } catch {
            if ($_.Exception.Message -and $_.Exception.Message.StartsWith("Unexpected end when deserializing array.")) {
                Write-Verbose ("Fast query for delegated permissions failed, using slow method...")
            } else {
                throw $_
            }
        }

        $DelAssignedPermissn=GetOAuth2PermissionGrants -FastMode:$fastQueryMode | ForEach-Object {
            $grant = $_
            if ($grant.Scope) {
                $grant.Scope.Split(" ") | Where-Object { $_ } | ForEach-Object {

                    $scope = $_

                    $grantDetails =  [ordered]@{
                            "PermissionType" = "Delegated"
                            "ClientObjectId" = $grant.ClientId
                            "ResourceObjectId" = $grant.ResourceId
                            "Permission" = $scope
                            "ConsentType" = $grant.ConsentType
                            "PrincipalObjectId" = $grant.PrincipalId
                        }

                    if ($ServicePrincipalProperties.Count -gt 0) {

                        $client = GetObjectByObjectId -ObjectId $grant.ClientId
                        $resource = GetObjectByObjectId -ObjectId $grant.ResourceId
                    

                        $insertAtClient = 2
                        $insertAtResource = 3
                        foreach ($propertyName in $ServicePrincipalProperties) {
                            $grantDetails.Insert($insertAtClient++, "Client$propertyName", $client.$propertyName)
                            $insertAtResource++
                            $grantDetails.Insert($insertAtResource, "Resource$propertyName", $resource.$propertyName)
                            $insertAtResource ++
                        }
                    }

                    if ($UserProperties.Count -gt 0) {

                        $principal = $empty
                        if ($grant.PrincipalId) {
                            $principal = GetObjectByObjectId -ObjectId $grant.PrincipalId
                        }

                        foreach ($propertyName in $UserProperties) {
                            $grantDetails["Principal$propertyName"] = $principal.$propertyName
                        }
                    }

                    if($grantDetails.ClientDisplayName -eq $applicationNam){
                            New-Object PSObject -Property $grantDetails
                    }
 
                }
            }
        }

        if($DelAssignedPermissn -ne $null -and $DelAssignedPermissn -ne ''){
            Write-Host "Delegated Permissions" -ForegroundColor White
            Write-Log("Delegated Permissions")
            Write-Host "---------------------" -ForegroundColor White
            Write-Log("-----------------------")
            foreach($key in $graph_DelHash.Keys){
                foreach($delPermissin in $DelAssignedPermissn){             
                    if([String]$graph_DelHash[$key] -match $delPermissin.Permission){
                        $delStr=$delPermissin.ResourceDisplayName+' -- '+$delPermissin.Permission
                        Write-Host $delStr -ForegroundColor Green
                        Write-Log($delStr)
                        $removStr=$delPermissin.Permission+','
                        $val=$err_delHash[$key].ToString().Replace($removStr,'')
                        $err_delHash.Remove($key)
                        $err_delHash.Add($key,$val)
                        
                    }
                }
            }
        }else{
            $err_DelStat='There is No Graph Delegated Roles and Permission added'
        }
    }
    Write-Host ''
    Write-Log("")
    $assignedAppPermissn=@()
    $isAppExist=$false
    if ($ApplicationPermissions -or (-not ($DelegatedPermissions -or $ApplicationPermissions))) {
        Write-Host "Application Permissions" -ForegroundColor White
        Write-Log("Application Permissions")
        Write-Host "-----------------------" -ForegroundColor White
        Write-Log("-----------------------")
        $script:ObjectByObjectClassId['ServicePrincipal'].GetEnumerator() | ForEach-Object { $i = 0 } {
            if ($ShowProgress) {
                Write-Progress -Activity "Retrieving application permissions..." `
                            -Status ("Checked {0}/{1} apps" -f $i++, $servicePrincipalCount) `
                            -PercentComplete (($i / $servicePrincipalCount) * 100)
            }

            $sp = $_.Value

            $assignedAppPermissn=Get-AzureADServiceAppRoleAssignedTo -ObjectId $sp.ObjectId -All $true `
            | Where-Object { $_.PrincipalType -eq "ServicePrincipal" } | ForEach-Object {
                $assignment = $_

                $resource = GetObjectByObjectId -ObjectId $assignment.ResourceId
                $appRole = $resource.AppRoles | Where-Object { $_.Id -eq $assignment.Id }

                $grantDetails = [ordered]@{
                    "PermissionType" = "Application"
                    "ClientObjectId" = $assignment.PrincipalId
                    "ResourceObjectId" = $assignment.ResourceId
                    "Permission" = $appRole.Value
                }

                if ($ServicePrincipalProperties.Count -gt 0) {
                    $client = GetObjectByObjectId -ObjectId $assignment.PrincipalId
                    $insertAtClient = 2
                    $insertAtResource = 3
                    foreach ($propertyName in $ServicePrincipalProperties) {
                        $grantDetails.Insert($insertAtClient++, "Client$propertyName", $client.$propertyName)
                        $insertAtResource++
                        $grantDetails.Insert($insertAtResource, "Resource$propertyName", $resource.$propertyName)
                        $insertAtResource ++
                    }
                }

                if($grantDetails.ClientDisplayName -eq $applicationNam){
                    New-Object PSObject -Property $grantDetails
                }
                #New-Object PSObject -Property $grantDetails
            }

            if($assignedAppPermissn -ne $null -and $assignedAppPermissn -ne ''){
                foreach($key in $graph_AppHash.Keys){   
                    foreach($appPermission in $assignedAppPermissn){             
                        if([String]$graph_AppHash[$key] -match $appPermission.Permission){
                            $isAppExist=$true
                            $appStr=$appPermission.ResourceDisplayName+' -- '+$appPermission.Permission
                            Write-Host $appStr -ForegroundColor Green
                            Write-Log($appStr)
                            $removStr=$appPermission.Permission+','
                            $val=$err_AppHash[$key].ToString().Replace($removStr,'')
                            $err_AppHash.Remove($key)
                            $err_AppHash.Add($key,$val)
                        }
                    }
                }
            }
        }
    }
    if(!$isAppExist){
        $err_AppStat='There is No Graph Application Roles and Permission added'
    }
    $outArr=@($err_DelStat,$err_delHash,$err_AppStat,$err_AppHash)
    return $outArr
}

$chexkBoxStr=''
######***GUI  form ****#######
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button

$O365DtlsLbl=New-Object System.Windows.Forms.Label
$O365UsrLbl=New-Object System.Windows.Forms.Label
$O365PassLbl=New-Object System.Windows.Forms.Label
$O365UsrTxtBx=New-Object System.Windows.Forms.TextBox
$O365PassTxtBx=New-Object System.Windows.Forms.TextBox 
    
$prxyDtlsLbl=New-Object System.Windows.Forms.Label
$prxyHostLbl=New-Object System.Windows.Forms.Label
$prxyPortLbl=New-Object System.Windows.Forms.Label
$prxyUsrLbl=New-Object System.Windows.Forms.Label
$prxyPassLbl=New-Object System.Windows.Forms.Label
$prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
$prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPassTxtBx=New-Object System.Windows.Forms.TextBox

$otherDtlsLbl=New-Object System.Windows.Forms.Label
$exoRolNamLbl=New-Object System.Windows.Forms.Label
$exoRolNamTxtBx=New-Object System.Windows.Forms.TextBox
$adAppNamLbl=New-Object System.Windows.Forms.Label
$adAppNamTxtBx=New-Object System.Windows.Forms.TextBox

$toChkLbl=New-Object System.Windows.Forms.Label

$totalvalues = ($Options.count)

$formsize = 382 + (30 * $totalvalues)
$flowlayoutsize = 10 + (30 * $totalvalues)
$buttonplacement = 329 + (30 * $totalvalues)

$script:CheckBoxArray = @()

$form_Load = {
    foreach($opt in $Options){
        $DynamicCheckBox = New-object System.Windows.Forms.CheckBox
        $DynamicCheckBox.Margin = '12, 8, 0, 0'
        $DynamicCheckBox.Name = $opt
        $DynamicCheckBox.Size = '210, 22'
        $DynamicCheckBox.Text = "" + $opt
        $DynamicCheckBox.TextAlign = 'MiddleLeft'
        $DynamicCheckBox.Checked=$true
        $flowlayoutpanel.Controls.Add($DynamicCheckBox)
        $script:CheckBoxArray += $DynamicCheckBox
    }       
}

#$formsize = 495
$form.Controls.Add($O365DtlsLbl)
$form.Controls.Add($O365UsrLbl)
$form.Controls.Add($O365UsrTxtBx)
$form.Controls.Add($O365PassLbl)
$form.Controls.Add($O365PassTxtBx)

$form.Controls.Add($prxyDtlsLbl)
$form.Controls.Add($prxyHostLbl)
$form.Controls.Add($prxyHostTxtBx)
$form.Controls.Add($prxyPortLbl)
$form.Controls.Add($prxyPortTxtBx)
$form.Controls.Add($prxyUsrLbl)
$form.Controls.Add($prxyUsrTxtBx)
$form.Controls.Add($prxyPassLbl)
$form.Controls.Add($prxyPassTxtBx)
$form.Controls.Add($otherDtlsLbl)
$form.Controls.Add($exoRolNamLbl)
$form.Controls.Add($exoRolNamTxtBx)
$form.Controls.Add($adAppNamLbl)
$form.Controls.Add($adAppNamTxtBx)
$form.Controls.Add($infoLabel)
$form.Controls.Add($infoLabel1)
$form.Controls.Add($toChkLbl)
$form.Controls.Add($flowlayoutpanel)
$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "428 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'O365 check prerequisites'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D
$form.add_Load($($form_Load))

$flowlayoutpanel.BorderStyle = 'FixedSingle'
$flowlayoutpanel.Location = '58, 307'
$flowlayoutpanel.Margin = '4, 4, 4, 4'
$flowlayoutpanel.Name = 'flowlayoutpanel1'
$flowlayoutpanel.AccessibleName = 'flowlayoutpanel1'
$flowlayoutpanel.Size = "316, $flowlayoutsize"
$flowlayoutpanel.TabIndex = 1

$O365DtlsLbl.Location="38,15"
$O365DtlsLbl.Anchor="Bottom, Left"
$O365DtlsLbl.Text="&Monitoring Account Credentails:"
$O365DtlsLbl.Size="200,20"
$O365UsrLbl.Location="58,38"
$O365UsrLbl.Anchor="Bottom, Left"
$O365UsrLbl.Text="&Username"
$O365UsrLbl.Size="115,20"
$O365UsrTxtBx.Location="175,38"
$O365UsrTxtBx.Name="O365User"
$O365UsrTxtBx.Size="200,20"
$O365UsrTxtBx.Text=""
$O365PassLbl.Location="58,67"
$O365PassLbl.Anchor="Bottom, Left"
$O365PassLbl.Text="&Password"
$O365PassLbl.Size="115,20"
$O365PassTxtBx.Location="175,67"
$O365PassTxtBx.Name="O365Pass"
$O365PassTxtBx.Size="200,20"
$O365PassTxtBx.Text=""
$O365PassTxtBx.PasswordChar='*'

$prxyDtlsLbl.Location="38,95"
$prxyDtlsLbl.Anchor="Bottom, Left"
$prxyDtlsLbl.Text="&Proxy Details :"
$prxyDtlsLbl.Size="100,20"
$prxyHostLbl.Location="58,118"
$prxyHostLbl.Anchor="Bottom, Left"
$prxyHostLbl.Text="&Host IP"
$prxyHostLbl.Size="115,20"
$prxyHostTxtBx.Location="175,118"
$prxyHostTxtBx.Name="ProxyHost"
$prxyHostTxtBx.Size="120,20"
$prxyHostTxtBx.Text="none"
$prxyPortLbl.Location="298,119"
$prxyPortLbl.Anchor="Bottom, Left"
$prxyPortLbl.Text="&Port"
$prxyPortLbl.Size="25,20"
$prxyPortTxtBx.Location="325,118"
$prxyPortTxtBx.Name="Port"
$prxyPortTxtBx.Size="50,20"
$prxyPortTxtBx.Text="none"
$prxyUsrLbl.Location="58,145"
$prxyUsrLbl.Anchor="Bottom, Left"
$prxyUsrLbl.Text="&Username"
$prxyUsrLbl.Size="115,20"
$prxyUsrTxtBx.Location="175,145"
$prxyUsrTxtBx.Name="ProxyUser"
$prxyUsrTxtBx.Size="200,20"
$prxyUsrTxtBx.Text="none"
$prxyPassLbl.Location="58,173"
$prxyPassLbl.Anchor="Bottom, Left"
$prxyPassLbl.Text="&Password"
$prxyPassLbl.Size="115,20"
$prxyPassTxtBx.Location="175,173"
$prxyPassTxtBx.Name="ProxyPass"
$prxyPassTxtBx.Size="200,20"
$prxyPassTxtBx.Text="none"
$prxyPassTxtBx.PasswordChar='*'

$otherDtlsLbl.Location="38,202"
$otherDtlsLbl.Anchor="Bottom, Left"
$otherDtlsLbl.Text="&Other Details :"
$otherDtlsLbl.Size="100,20"
$exoRolNamLbl.Location="58,226"
$exoRolNamLbl.Anchor="Bottom, Left"
$exoRolNamLbl.Text="&EXO Role Name"
$exoRolNamLbl.Size="115,20"
$exoRolNamTxtBx.Location="175,226"
$exoRolNamTxtBx.Name="exoRolNam"
$exoRolNamTxtBx.Size="200,20"
$exoRolNamTxtBx.Text="eGMonitoring-role"


$adAppNamLbl.Location="58,254"
$adAppNamLbl.Anchor="Bottom, Left"
$adAppNamLbl.Text="&AAD App Name"
$adAppNamLbl.Size="115,20"
$adAppNamTxtBx.Location="175,254"
$adAppNamTxtBx.Name="adAppNam"
$adAppNamTxtBx.Size="200,20"
$adAppNamTxtBx.Text="eGMsGraphRpt"

$toChkLbl.Location="38,281"
$toChkLbl.Anchor="Bottom, Left"
$toChkLbl.Text="&To Check :"
$toChkLbl.Size="100,20"
    
$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "175, $buttonplacement"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'
$frmDialog=$form.ShowDialog()

if($frmDialog -eq 'OK' ){
    $userName=$O365UsrTxtBx.Text
    $password=$O365PassTxtBx.Text
    $proxyHost=$prxyHostTxtBx.Text
    $proxyPort=$prxyPortTxtBx.Text
    $proxyUsr=$prxyUsrTxtBx.Text
    $proxyPass=$prxyPassTxtBx.Text

    $adAppNam=$adAppNamTxtBx.Text
    $exoRoleNam=$exoRolNamTxtBx.Text

    foreach($cbox in $CheckBoxArray){
        if($cbox.CheckState -eq 'Checked'){
            $cStr=($cbox.Name).ToString()
            $chexkBoxStr+='~'+$cStr
        }   
    }

    if($proxyHost -eq "" -or $proxyport -eq "" -or $proxyUsr -eq "" -or $userName -eq "" -or $password -eq "" )
    {
        Write-Host "Re-run the script with all the inputs...." -ForegroundColor Red
        Exit
    }
}
else{
    Write-Host 'Exiting...'
    exit
}

[string]$strtDate = Get-Date -Format G
Write-Host "****** Start at $strtDate *******"
Write-Log("****** Start at $strtDate *******")

$cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','smtp.partner.outlook.cn','https://login.chinacloudapi.cn','O365China')
$com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','smtp.office365.com','https://login.microsoftonline.com','O365Default')
$de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','outlook.office.de','https://login.microsoftonline.de','O365GermanyCloud')
$us=@('USGovernment','None','outlook.office365.us','https://login.microsoftonline.us','O365USGovDoD')

$azureCloud=$userName.Substring($userName.LastIndexOf('.')+1) 
$azureCloudArr=@()

if($azureCloud -eq 'com'){$azureEnvArr=$com}
elseif($azureCloud -eq 'cn'){$azureEnvArr=$cn}
elseif($azureCloud -eq 'de'){$azureEnvArr=$de}
elseif($azureCloud -eq 'us'){$azureEnvArr=$us}  
else{$azureEnvArr=$com}


$Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}



#User Details
$displayNam=''
Connect-MsolService -Credential $Credential -AzureEnvironment $azureEnvArr[0]
$usrDtls=Get-MsolUser -UserPrincipalName $userName |select DisplayName,SignInName,IsLicensed
Write-Host 'DisplayName -- SignInName -- IsLicensed' -ForegroundColor White
Write-Log("DisplayName -- SignInName -- IsLicensed")
Write-Host '---------------------------------------' -ForegroundColor White
Write-Log("---------------------------------------")
$displayNam=$usrDtls.DisplayName
$usrDtlsStr=$usrDtls.DisplayName+' -- '+$usrDtls.SignInName+' -- '+$usrDtls.IsLicensed
Write-Host $usrDtlsStr -ForegroundColor Green
Write-Log($usrDtlsStr)
Write-Host ''
Write-Log("")

## Date and Time, TimeFormat Details
Write-Host 'Date and Time,Hour format Details' -ForegroundColor White
Write-Log("Date and Time,Hour format Details")
Write-Host '----------------------------------' -ForegroundColor White
Write-Log("----------------------------------")
$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
Write-Host 'DateTimeFormat -->>'$DateTimeFormat -ForegroundColor Green
$datFrmtim=Get-Date -Format $DateTimeFormat
$datFrmtim12=[DateTime]::Now.AddHours(12).ToString($DateTimeFormat)
Write-Host $datFrmtim -ForegroundColor Green
Write-Host $datFrmtim12 -ForegroundColor Green
Write-Log("DateTimeFormat -->>"+$DateTimeFormat)
Write-Log($datFrmtim)
Write-Log($datFrmtim12)
Write-Host ''
Write-Log("")
Write-Host 'Date-LongDatePattern -->> '$CultureDateTimeFormat.LongDatePattern -ForegroundColor Green
Write-Log("Date-LongDatePattern -->>"+$CultureDateTimeFormat.LongDatePattern)
Write-Host 'Date-ShortDatePattern -->> '$CultureDateTimeFormat.ShortDatePattern -ForegroundColor Green
Write-Log("Date-ShortDatePattern -->>"+$CultureDateTimeFormat.ShortDatePattern)
Write-Host 'Time-LongTimePattern -->> '$CultureDateTimeFormat.LongTimePattern -ForegroundColor Green
Write-Log("Time-LongTimePattern -->>"+$CultureDateTimeFormat.LongTimePattern)
Write-Host 'Time-ShortTimePattern -->> '$CultureDateTimeFormat.ShortTimePattern -ForegroundColor Green
Write-Log("Time-ShortTimePattern -->>"+$CultureDateTimeFormat.ShortTimePattern)
Write-Host ''
Write-Log("")

Write-Host 'Hour format' -ForegroundColor White
Write-Log("Hour format")
Write-Host '------------' -ForegroundColor White
Write-Log("------------")
$format1=(Get-Date).ToString('tt')
$format2=(Get-Date).AddHours(12).ToString('tt')
Write-Host $format1 -ForegroundColor Green
Write-Log($format1)
Write-Host $format2 -ForegroundColor Green
Write-Log($format2)
Write-Host ''
Write-Log("")

## Check WINRM client -auth basic
$winrmStat=''
$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
Write-Host 'WINRM - Basic Authentication' -ForegroundColor White
Write-Log("WINRM - Basic Authentication")
Write-Host '-----------------------------' -ForegroundColor White
Write-Log("-----------------------------")
if($chkWinrm -match 'Basic=true'){
    Write-Host 'WINRM basic authentication is enabled' -ForegroundColor Green
    Write-Log("WINRM basic authentication is enabled")
}else{
    $winrmStat='WINRM basic authentication is not enabled'
    Write-Host 'WINRM basic authentication is not enabled' -ForegroundColor Red
    Write-Log("WINRM basic authentication is not enabled")
}
Write-Host ''
Write-Log("")

## Get Installed Package
$missedMod=@()
$errModules=''
Try{
    if($chexkBoxStr -match 'Modules'){
        Write-Host 'Installed Modules' -ForegroundColor White
        Write-Log("Installed Modules")
        Write-Host '-----------------' -ForegroundColor White
        Write-Log("-----------------")
        (Get-InstalledModule).Name |%{Write-Host $_ -ForegroundColor Green;Write-Log($_);$presentModStr+='~'+$_}
        $modulesArr=$totModulues.Split('~')
        foreach($module in $modulesArr){
            if($presentModStr -notmatch $module){
                $missedMod+=$module
            }       
        }
        Write-Host ''
        Write-Log("")
    }
}Catch{
    $errModules='Exception occurred in while getting modules. The exception is '+$_.Exception.Message
}


#Getting O365 monitoring Account Roles
$missedUsrRoles=@()
$errUsrRoles='';$usrRolesCnt=0
Try{
    if($chexkBoxStr -match 'User Roles'){
        Write-Host 'O365 Monitoring Roles' -ForegroundColor White
        Write-Log("O365 Monitoring Roles")
        Write-Host '---------------------' -ForegroundColor White
        Write-Log("---------------------")
        Connect-MsolService -Credential $Credential -AzureEnvironment $azureEnvArr[0]

        Get-MsolRole | %{$role = $_.name; Get-MsolRoleMember -RoleObjectId $_.objectid } |Where-Object{$_.EmailAddress -eq $userName} | select @{Name="Role"; Expression = {$role}} |%{
                    $usrRolesCnt++;
                    Write-Host $_.Role -ForegroundColor Green;
                    Write-Log($_.Role);
                    $presentUsrRol+='~'+$_.Role;
                }
        $usrRolesArr=$totUsrRoles.Split('~')
        foreach($usrRole in $usrRolesArr){
            if($presentUsrRol -notmatch $usrRole){
                $missedUsrRoles+=$usrRole
            }
        } 
        Write-Host ''
        Write-Log("")
    }
}
Catch{
    $errUsrRoles='Exception occurred in while getting user roles. The exception is '+$_.Exception.Message
}

$missedExoPermisns=@()
$auditLogStat='';$memberStatus=''
$errUsrPermisns='';$noUsrPermisns=''
Try{
    if($chexkBoxStr -match 'User Permissions'){
        try{
            $sessionOption = New-PSSessionOption -SkipRevocationCheck
            if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
                [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
                [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
                $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
            }
            Connect-ExchangeOnline -ExchangeEnvironmentName O365Default -Credential $Credential -PSSessionOption $sessionOption -ShowProgress $False -ShowBanner:$false -InformationAction SilentlyContinue
        }catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-Host 'Exception occurred in Connect-ExchangeOnline -->> '+$message -ForegroundColor Red
            Write-Log('Exception occurred in Connect-ExchangeOnline -->> '+$message)
            Write-Log("**** End *****")
            exit
        }

        Write-Host 'ExchangeOnline Permissions' -ForegroundColor White
        Write-Log("ExchangeOnline Permissions")
        Write-Host '--------------------------' -ForegroundColor White
        Write-Log("--------------------------")
        $exoRoleGrps=Get-RoleGroup |?{$_.Name -eq $exoRoleNam} | select * 
        if($exoRoleGrps.Count -eq 0){
            $noUsrPermisns='There is no Exo-Roles'
        }
        foreach($exorole in $exoRoleGrps){
            if($exorole.Identity -eq $exoRoleNam){
                Write-Host 'EXO - RoleName' -ForegroundColor White
                Write-Log("EXO - RoleName")
                Write-Host '------------' -ForegroundColor White
                Write-Log("------------")
                Write-Host $exoRoleNam -ForegroundColor Green
                Write-Log($exoRoleNam)
                Write-Host ''
                Write-Log("")
                Write-Host 'EXO - Roles' -ForegroundColor White
                Write-Log("EXO - Roles")
                Write-Host '-----------' -ForegroundColor White
                Write-Log("-----------")
                foreach($role in $exorole.Roles){
                    Write-Host $role -ForegroundColor Green
                    Write-Log($role)
                    $exoPermsnStr+='~'+$role
                }
                $exoPermisnArr=$totExoPermissns.Split('~')
                foreach($permission in $exoPermisnArr){
                    if($exoPermsnStr -notmatch $permission){
                        $missedExoPermisns+=$permission
                    }
                }

                Write-Host ''
                Write-Log("")
                Write-Host 'EXO - Members' -ForegroundColor White
                Write-Log("EXO - Members")
                Write-Host '-------------' -ForegroundColor White
                Write-Log("-------------")
                foreach($member in $exorole.Members){
                    if($member -eq $displayNam){
                        $memberStatus=$member
                        Write-Host $member -ForegroundColor Green
                        Write-Log($member)
                    }
                }
                Write-Host ''
                Write-Log("")
            }
        }
        Write-Host ''
        Write-Log("")

        ## AUDIT LOG
        $isEnabled=Get-AdminAuditLogConfig |select *
        Write-Host 'AuditLog' -ForegroundColor White
        Write-Log("AuditLog")
        Write-Host '--------' -ForegroundColor White
        Write-Log("--------")
        if($isEnabled.UnifiedAuditLogIngestionEnabled){
            Write-Host 'AuditLog is enabled' -ForegroundColor Green
            Write-Log("AuditLog is enabled")
        }else{
            $auditLogStat='AuditLog is not enabled'
            Write-Host 'AuditLog is not enabled' -ForegroundColor Red
            Write-Log("AuditLog is not enabled")
        }
        Write-Host ''
        Write-Log("")

        $getSession=Get-PSSession -ErrorAction SilentlyContinue
        if($getSession -ne $null -and $getSession -ne ''){
	        Disconnect-ExchangeOnline -Confirm:$false -WarningAction SilentlyContinue -InformationAction SilentlyContinue
        }

    }
}
Catch{
    $errUsrPermisns='Exception occurred in while getting user permissions. The exception is '+$_.Exception.Message
}

$errGraphPermisn=''
Try{
    if($chexkBoxStr -match 'Graph Permissions'){
        Write-Host 'O365 GraphAPI Permissions' -ForegroundColor White
        Write-Log("O365 GraphAPI Permissions")
        Write-Host '-------------------------' -ForegroundColor White
        Write-Log("-------------------------")
        $null=Connect-AzureAD -AzureEnvironmentName $azureEnvArr[0] -Credential $Credential

        $resArr=Get-AssignedPermissions -applicationNam $adAppNam 
        $errDelSt=[String]$resArr[0]
        $errDelHsh=[Hashtable]$resArr[1]
        $errAppSt=[String]$resArr[2]
        $errAppHsh=[Hashtable]$resArr[3]

        Disconnect-AzureAD
        Write-Log("")
    }
}
Catch{
    $errGraphPermisn='Exception occurred in while getting graph permissions. The exception is '+$_.Exception.Message
}


[string]$endDate = Get-Date -Format G
Write-Host "**** End at $endDate*****"
Write-Log("**** End at $endDate*****")
Write-Log("")




################# Missing prerequisites ########################

Write-Host ''
Write-Log("")
Write-Host '************** Missing prerequisites *******************'
Write-Log("************ Missing prerequisites ************")

if($winrmStat -ne ''){
    Write-Host 'WINRM - Basic Authentication'
    Write-Log("WINRM - Basic Authentication")
    Write-Host '----------------------------'
    Write-Log("----------------------------")
    Write-Host 'WINRM basic authentication is not enabled' -ForegroundColor Red
    Write-Log("WINRM basic authentication is not enabled")
    Write-Host ''
    Write-Log("")
}

if($chexkBoxStr -match 'Modules'){
    Write-Host 'Modules'
    Write-Log("Modules")
    Write-Host '-------'
    Write-Log("-------")
    if($errModules -ne ''){
        Write-Host $errModules
        Write-Log($errModules)
        Write-Host ''
        Write-Log("")
    }else{
        foreach($module in $missedMod){
            Write-Host $module -ForegroundColor Red
            Write-Log($module)
            Write-Host ''
            Write-Log("")
        }
    }
}

if($chexkBoxStr -match 'User Roles'){
    Write-Host 'User roles'
    Write-Log("User roles")
    Write-Host '----------'
    Write-Log("----------")
    if($errUsrRoles -ne ''){
        Write-Host $errUsrRoles
        Write-Log($errUsrRoles)
        Write-Host ''
        Write-Log("")
    }else{
        if($usrRolesCnt -eq 0){
            Write-Host 'There is no User Roles assigned'
            Write-Log("There is no User Roles assigned")
            Write-Host ''
            Write-Log("")
        }else{
            if($missedUsrRoles.Count -ne 0){
                foreach($usrRole in $missedUsrRoles){
                    Write-Host $usrRole -ForegroundColor Red
                     Write-Log($usrRole)
                }
            }
        }

    }
    Write-Host ''
    Write-Log("")
}

if($chexkBoxStr -match 'User Permissions'){
    Write-Host 'EXO - User Permissions'
    Write-Log("EXO - User Permissions")
    Write-Host '----------------------'
    Write-Log("----------------------")
    if($errUsrPermisns -ne ''){
        Write-Host $errUsrPermisns
        Write-Log($errUsrPermisns)
        Write-Host ''
        Write-Log("")
    }else{
        if($noUsrPermisns -ne ''){
            Write-Host $noUsrPermisns -ForegroundColor Red
            Write-Log($noUsrPermisns)
            Write-Host ''
            Write-Log("")
        }else{
            if($missedExoPermisns.Count -ne 0){
                Write-Host 'Role'
                Write-Log("Role")
                Write-Host '----'
                Write-Log("----")
                Write-Host 'Role Name -- '$exoRoleNam -ForegroundColor Red
                Write-Log("Role Name -- '$exoRoleNam")
                Write-Host ''
                Write-Log("")
                Write-Host 'Permissions'
                Write-Log("Permissions")
                Write-Host '-----------'
                Write-Log("-----------")
                foreach($permisn in $missedExoPermisns){
                    Write-Host $permisn -ForegroundColor Red
                    Write-Log($permisn)
                }
                Write-Host ''
                Write-Log("")
            }
            if($memberStatus -eq ''){
                Write-Host 'Members'
                Write-Log("Members")
                Write-Host '-------'
                Write-Log("-------")
                $str=$displayNam+' is not assigned in '+$exoRoleNam
                Write-Host $str -ForegroundColor Red
                Write-Log($str)
                Write-Host ''
                Write-Log("")
            }
        }
    }
    if($auditLogStat -ne ''){
        Write-Host 'AuditLog'
        Write-Log("AuditLog")
        Write-Host '--------'
        Write-Log("--------")
        Write-Host 'AuditLog is not enabled' -ForegroundColor Red
        Write-Log("AuditLog is not enabled")
        Write-Host ''
        Write-Log("")
    }
}
#<#
if($chexkBoxStr -match 'Graph Permissions'){
    Write-Host 'Graph Permissions' -ForegroundColor White
    Write-Host '-----------------' -ForegroundColor White
    if($errGraphPermisn -ne ''){
        Write-Host $errGraphPermisn
        Write-Log($errGraphPermisn)
        Write-Host ''
        Write-Log("")
    }

    if($errAppSt.Length -gt 0){
        Write-Host 'Application Permissions'
        Write-Host '-----------------------'
        Write-Log("Application Permissions")
        Write-Log("-----------------------")
        Write-Host $errAppSt -ForegroundColor Red
        Write-Log($errAppSt)
        Write-Host ''
        Write-Log("")
    }else{
        if($errAppHsh.Count -ne 0){
            Write-Host 'Application Permissions'
            Write-Host '-----------------------'
            Write-Log("Application Permissions")
            Write-Log("-----------------------")
            foreach($key in $errAppHsh.Keys){
                if($errAppHsh[$key] -ne $null -and $errAppHsh[$key] -ne ''){
                    $valStr=$errAppHsh[$key].Substring(0,$errAppHsh[$key].LastIndexOf(','))
                    Write-Host $key ' -- ' $valStr -ForegroundColor Red
                    Write-Log($key+' -- '+$valStr)
                }
            }
            Write-Host ''
            Write-Log("")
        }
    }

    if($errDelSt.Length -gt 0){
        Write-Host 'Delegated Permissions'
        Write-Host '---------------------'
        Write-Log("Delegated Permissions")
        Write-Log("---------------------")
        Write-Host $errDelSt -ForegroundColor Red
        Write-Log($errDelSt)
        Write-Host ''
        Write-Log("")

    }else{
        if($errDelHsh.Count -ne 0){
            Write-Host 'Delegated Permissions'
            Write-Host '---------------------'
            Write-Log("Delegated Permissions")
            Write-Log("---------------------")
            foreach($key in $errDelHsh.Keys){
                if($errDelHsh[$key] -ne $null -and $errDelHsh[$key] -ne ''){
                    $valStr=$errDelHsh[$key].Substring(0,$errDelHsh[$key].LastIndexOf(','))
                    Write-Host $key ' -- ' $valStr -ForegroundColor Red
                    Write-Log($key+' -- '+$valStr)
                }
            }
            Write-Host ''
            Write-Log("")
        }
    }
}
#>
if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}