﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

#<#
$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$Proxycrds=$testargs[2]
$pxycrds=$Proxycrds.split("#")
$proxyUsr=$pxycrds[0]
$proxyPass=Eg-O365Dcr -EncStr $pxycrds[1]
$proxyserverip=$testargs[3]
$Rptcrds=$testargs[4].split("#")
$reportingname=$Rptcrds[0]
$mTime=$Rptcrds[1]
$fetchDomains=$testargs[5]
$appDetails=$testargs[6]
#>

$appDetailsArr=$appDetails.ToString() -Split ("~!~")
$clientId=$appDetails[0]
$tenantName=$appDetails[1]
$thumbPrint=$appDetails[2]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')

$ManualThrottle=0
[double]$ActiveThrottle=.25
$ResetSeconds=870
#<#
$rptPath='MTM/'+$reportingname
$MyDir=$egurkhaPath+'/agent/MTM/'+$reportingname

if(!(Test-Path -Path $MyDir )){
    New-Item -ItemType directory -Path $MyDir
}
#>
$WriteLog=$true
$LogFile = $egurkhaPath+'/agent/MTM/'+$reportingname+"\audits.log"
$LogFile1 = $egurkhaPath+'/agent/MTM/'+$reportingname+"\audits1.log"


$isFrstTimLog=$true
# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)

	[string]$date = Get-Date -Format G
	
    if ($WriteLog) {
       ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append } 

    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }

}

Function Start-SleepWithProgress {
	Param([int]$sleeptime)

	For ($i=0;$i -le $sleeptime;$i++){
		$timeleft = ($sleeptime - $i);
		Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		start-sleep 1
	}
	
	Write-Progress -Completed -Activity "Sleeping"
}

Function New-CleanO365Session {


    $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
	
    $i = 0
	while (($Credential -eq $Null) -and ($i -lt 5)){
		$script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		$i++
	}

	if ($Credential -eq $null){
		Write-log "[Error] - Failed to get credentials"
		Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	}

	Write-Log "Removing all PS Sessions"
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
	    Disconnect-ExchangeOnline -Confirm:$false
    }

	[System.GC]::Collect()
	Write-Log ("Sleeping 15 seconds for Session Tear Down")
	Start-SleepWithProgress -SleepTime 15
	$Error.Clear()
	
	# Create the session
	Write-Log "Creating new PS Session"
	$sessionOption = New-PSSessionOption -SkipRevocationCheck
    if(!$proxyserverip.ToString().ToLower().Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
	    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred	
	        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType IEConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	    }
    }
		
	# Check for an error while creating the session
	if ($Error.Count -gt 0){
	
		Write-Log "[ERROR] - Error while setting up session"
		Write-log $Error
		$ErrorCount++
		if ($ErrorCount -gt 3){
			$deleky=0
			Write-log "[ERROR] - Failed to setup session after multiple tries"
			Write-log "[ERROR] - Aborting Script"
			exit		
		}
		Write-Log "Sleeping 60s so that issue can potentially be resolved"
		Start-SleepWithProgress -sleeptime 60

		New-CleanO365Session
	}
	else {
		$ErrorCount = 0
	}
	
	# Connect the ExchangeOnline
    if($appDetails -ne 'none'){
        Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
    }else{
        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption -WarningAction SilentlyContinue
    }
	
	# Set the Start time for the current session
	Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)

}

Function Test-O365Session {

	$ObjectTime = Get-Date
	$SessionInfo = $null
	$SessionInfo = Get-PSSession

	if ($SessionInfo -eq $null) { 
		Write-Log "[ERROR] - No Session Found"
		Write-log "Recreating Session"
		New-CleanO365Session
	}	
	elseif ($SessionInfo.State -ne "Opened"){
		Write-Log "[ERROR] - Session not in Open State"
		Write-log ($SessionInfo | fl | Out-String )
		Write-log "Recreating Session"
		New-CleanO365Session
	}
	elseif (($ObjectTime - $SessionStartTime).totalseconds -gt $ResetSeconds){
		Write-Log ("Session Has been active for greater than " + $ResetSeconds + " seconds" )
		Write-Log "Rebuilding Connection" 
		[int]$DelayinSeconds = ((($ResetSeconds * $ActiveThrottle) / 2) - 15)

		if ($DelayinSeconds -gt 0){
		
			Write-Log ("Sleeping " + $DelayinSeconds + " addtional seconds to allow throttle recovery")
			Start-SleepWithProgress -SleepTime $DelayinSeconds
		}
		else {
			Write-Log ("Active Delay calculated to be " + ($DelayinSeconds + 15) + " seconds no addtional delay needed")
		}

		New-CleanO365Session
	}
	else {

	}

	if ($ManualThrottle -gt 0){
		Write-log ("Sleeping " + $ManualThrottle + " milliseconds")
		Start-Sleep -Milliseconds $ManualThrottle
	}
}

Function Get-EstimatedTimeToCompletion {
	param([int]$ProcessedCount)

	$ProcessedCount++
	if (($ProcessedCount % 100) -eq 0){
		$CurrentDate = Get-Date
		$AveragePerObject = (((($CurrentDate) - $ScriptStartTime).totalseconds) / $ProcessedCount)
		Write-Log ("[STATS] - Total Number of Objects:     " + $ObjectCount)
		Write-Log ("[STATS] - Number of Objects processed: " + $ProcessedCount)
		Write-Log ("[STATS] - Average seconds per object:  " + $AveragePerObject)
		Write-Log ("[STATS] - Estimated completion time:   " + $CurrentDate.addseconds((($ObjectCount - $ProcessedCount) * $AveragePerObject)))
	}

	return $ProcessedCount
}

################################
$componentnam='Microsoft_Teams_domain'
$ps1FileName=$MyInvocation.MyCommand.Name
$isRunMainset=$false
if($appDetails -ne 'none'){
    $sprsetNam=Domains-GetSuperset -UserName $userName -Password $Password -ProxyServerIP $proxyserverip -ProxyUser $proxyUsr -ProxyPassword $proxyPass -appDetails $appDetails
}else{
    $sprsetNam=Domains-GetSuperset -UserName $userName -Password $Password -ProxyServerIP $proxyserverip -ProxyUser $proxyUsr -ProxyPassword $proxyPass
}

$ticks_dtlsArr= Domains-ReadFrmINI -ps1FileName $ps1FileName -RptName $reportingname -ComponentName $componentnam -EncType $encTyp
if($ticks_dtlsArr -eq $null -or $ticks_dtlsArr.Count -eq 0){
    $curTicks=(get-Date).Ticks
    Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $reportingname -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
    $isRunMainset=$true
}else{
    $curTicks=(get-Date).Ticks
    $stTicks=[long]$ticks_dtlsArr[2]
    $TimeFromTicks = [datetime]$stTicks
    $diff=((get-Date)-$TimeFromTicks)
    if($mTime -le $diff.Minutes){
        Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $reportingname -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
        $isRunMainset=$true
    }  
}
###############################
$superSetPath='MTM/'+$sprsetNam
$superSetDir=$egurkhaPath+'/agent/MTM/'+$sprsetNam
if(!(Test-Path -Path $superSetDir )){
    New-Item -ItemType directory -Path $superSetDir
}

if($isRunMainset){

    $isErrorOccur= $false

    $endDat = Get-Date
    $startDat=$endDat.AddMinutes(-$mTime)

    Set-StrictMode -Version 2
    $ErrorCount = 0
    New-CleanO365Session
    $ScriptStartTime = Get-Date
    $Error.Clear()

    Try{
        $auditOper = Eg-WriteFile -ComntRptPath $superSetPath -FileName "MTDAuditOper" -keyFileName "kMTDAuditOper" -EgPath $egurkhaPath
       
        $Oprtns=@("TeamsSessionStarted","BotAddedToTeam","ChannelAdded","ChannelDeleted","BotRemovedFromTeam","TeamCreated","ConnectorAdded","TabAdded","ConnectorRemoved","TabRemoved","TabUpdated","ConnectorUpdated","MemberAdded","MemberRoleChanged","TeamSettingChanged","TeamDeleted","MemberRemoved","ChannelSettingChanged","TeamsTenantSettingChanged")
        $curResCntMA=0
        while($true){
            $maResults=Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat -Operations $Oprtns -SessionId ma -SessionCommand ReturnLargeSet -ResultSize 5000 |Select-Object AuditData,Operations,RecordType,CreationDate,UserIds
            $maResults | Export-Csv $auditOper[1] -Encoding $encTyp -Append
            $curResCntMA=$curResCntMA+($maResults.count)
            if(($curResCntMA -eq 50000) -or ($maResults.count -lt 5000)){
                break
            }
        }
        $null=Protect-File  $auditOper[1] -Algorithm AES -KeyAsPlainText $auditOper[0] -RemoveSource
        }Catch{
	        $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$superSetPath+'\'
            $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kMTDAuditOper*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
            foreach($file in $fileRead){
                    $fileName=([String]$file.Name).Trim()
                    if([System.IO.File]::Exists(($egurkhaRprtPath+$fileName)) -eq 'True'){
                        Remove-Item $egurkhaRprtPath$fileName -Force
                    }
            }
	    }

    $csvDir=$egurkhaPath+'/agent/MTM/'+$sprsetNam+'/'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'MTDAuditOper'

    Write-Log "Script Complete Destroying PS Sessions"
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
        Disconnect-ExchangeOnline -Confirm:$false
    }
    [System.GC]::GetTotalMemory($true) | out-null
}

$readfiles=Eg-ReadFile -ComntRptPath $superSetPath -FileName "MTDAuditOper" -keyFileName "kMTDAuditOper" -EgPath $egurkhaPath
if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $mtmAuditLog= import-csv $csvfile -Encoding $encTyp
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTDAuditOper' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTDAuditOper' -InputFile $readfiles[4]

    Try{
        $mtdAuditOper = Eg-WriteFile -ComntRptPath $rptPath -FileName "MTDAuditOper" -keyFileName "kMTDAuditOper" -EgPath $egurkhaPath
        foreach($res in $mtmAuditLog){
            $usrId=([String]($res.AuditData| ConvertFrom-Json).UserId).Split('@')[1]
            if($usrId -ne $null -and $usrId -ne '' -and $fetchDomains -match $usrId){
                    $res |Export-Csv $mtdAuditOper[1] -Encoding $encTyp -Append
            }
        }
        $null=Protect-File  $mtdAuditOper[1] -Algorithm AES -KeyAsPlainText $mtdAuditOper[0] -RemoveSource
    }
    Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "fetchdomain Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg
    }
}