$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
function is2012
{
	$os = (Get-WmiObject Win32_OperatingSystem).Caption
	$os
	if($os.indexof("2012") -gt 0 -or $os.indexof("2016") -gt 0 -or $os.indexof("2019") -gt 0 -or $os.indexof("2022") -gt 0)
	{
		return $true
	}
	else
	{
		return $false
	}
}

$VmSwitchinfo = @()
$computer = $env:ComputerName
$oscheck = is2012
if($oscheck -eq $true)
{
	$ListofVMs = gwmi -namespace root\virtualization\v2 Msvm_ComputerSystem -filter "ElementName <> Name" -computer $computer
	$ListofSwitches = gwmi -namespace root\virtualization\v2 Msvm_VirtualEthernetSwitch -computer $computer
	$ListofSwitchPorts = gwmi -namespace root\virtualization\v2 Msvm_LanEndPoint  -computer $computer
	$ListofConnections = gwmi -namespace root\virtualization\v2 Msvm_ActiveConnection -computer $computer
}	
else
{
	$ListofVMs = gwmi -namespace root\virtualization Msvm_ComputerSystem -filter "ElementName <> Name" -computer $computer
	$ListofSwitches = gwmi -namespace root\virtualization Msvm_VirtualSwitch -computer $computer
	$ListofSwitchPorts = gwmi -namespace root\virtualization Msvm_SwitchPort  -computer $computer
	$ListofConnections = gwmi -namespace root\virtualization Msvm_ActiveConnection -computer $computer
	
}
foreach ($Switch in $ListofSwitches)
{
	$SwitchGUID = $Switch.Name
	$SwitchDisplayName = $Switch.ElementName
	$PortsOnSwitch = $ListofSwitchPorts | where {$_.SystemName -match $SwitchGUID} 
	foreach ($Port in $PortsOnSwitch)
	{
		$PortPath = $Port.__PATH
		$a = $ListofConnections | where {$_.Antecedent -like $PortPath}
		if ($a -ne $NULL)
		{
			$LANEndPoint = $a.Dependent 
			foreach ($VM in $ListofVMs)
			{
				$VMGUID = $VM.Name
				$VMDisplayName = $VM.ElementName
				if ($LanEndPoint -like "*$VMGUID*")
				{
					if($oscheck -eq $true)
					{
						$str = $SwitchGUID + "_" + $Port.Name.substring(10) + "=" + $SwitchDisplayName + ":" + $VMDisplayName
					}
					else
					{
						$str = $SwitchGUID + "_" + $Port.Name + "=" + $SwitchDisplayName + ":" + $VMDisplayName
					}
					write-host $str
				}
			}
		}
	}
}
