$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Function Get-PoolName
{
	param($serverCN)
	$PoolName = "-"
	$LDAPPath = 'LDAP://localhost:389/OU=Applications,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
	$Selector = New-Object DirectoryServices.DirectorySearcher
	$Selector.SearchRoot = $LDAPEntry
	$Selector.Filter = "(objectClass=pae-DesktopApplication)"
	$Selector.PageSize = 1000
	$Selector.SearchScope = "Subtree"
	$Apps = $Selector.FindAll()
	if($Apps -ne $null)
	{
		foreach($App in $Apps)
		{
			$attribute = $App.Properties
			$PoolName = $attribute.'pae-displayname'
			$servers = @($attribute.'pae-servers')
			if($servers.Contains($serverCN) -eq $True)
			{
				break
			}
		}
	}
	return $PoolName
}

$csservers = new-object System.Collections.ArrayList
$LDAPPath = 'LDAP://localhost:389/OU=Server,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-VDMProperties)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"

Write-Host "[View Connection Servers]"
Write-Host "--------------------------"
$vdms = $Selector.FindAll()
if($vdms -ne $null)
{
	foreach($vdm in $vdms)
	{
		$attribute = $vdm.Properties
		$fqdn = $attribute.'pae-fqhn'
		if(-not [string]::IsNullOrEmpty($fqdn))
		{
			$csservers += $fqdn
			Write-Host ($fqdn)
		}
		$isgateway = $attribute.'pae-vdmgateway'
		if($null -ne $isgateway -and $isgateway -eq 1)
		{
			$displayName = $attribute.'pae-displayname'
			$gateways += $displayName
		} 
	}
}
Write-Host "[View Access Gateway Servers]"
Write-Host "---------------------------------"
if($null -ne $gateways -and $gateways.count -gt 0)
{
	foreach($gateway in $gateways)
	{
		Write-host $gateway
	}
}
$LDAPEntry.Close()
write-host
$LDAPPath = 'LDAP://localhost:389/OU=VirtualCenter,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-VirtualCenter)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
Write-Host "[vCenter Server]"
Write-Host "------------------"
$vcs = $Selector.FindAll()
if($vcs -ne $null)
{
	foreach($vc in $vcs)
	{
		$attribute = $vc.Properties
		$url = $attribute.'pae-vcurl'
		Write-Host($url)
	}
}
$LDAPEntry.Close()
write-host
$LDAPPath = 'LDAP://localhost:389/OU=Database,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-EventDatabase)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
Write-Host "[DB Server]"
Write-Host "---------------"
$dbs = $Selector.FindAll()
if($dbs -ne $null)
{
	foreach($db in $dbs)
	{
		$attribute = $db.Properties
		$dbserver = $attribute.'pae-databasehostname'
		$dbport = $attribute.'pae-databaseportnumber'
		$dbtype = $attribute.'pae-databaseservertype'
		$s = $dbtype+"="+$dbserver+":"+$dbport 
		Write-Host($s)
	}
}
$LDAPEntry.Close()
write-host
write-host "[RDS Hosts]"
write-host "--------------"

$LDAPPath2 = 'LDAP://localhost:389/OU=Servers,DC=vdi,DC=vmware,DC=int'
$LDAPEntry2 = New-Object DirectoryServices.DirectoryEntry $LDAPPath2
$Selector2 = New-Object DirectoryServices.DirectorySearcher
$Selector2.SearchRoot = $LDAPEntry2

$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
$Selector1 = New-Object DirectoryServices.DirectorySearcher
$Selector1.SearchRoot = $LDAPEntry1
$Selector1.Filter = "(objectClass=pae-ServerPool)"
$Selector1.PageSize = 1000
$Selector1.SearchScope = "Subtree"
$Farms = $Selector1.FindAll()

if($Farms -ne $null)
{
	foreach($Farm in $Farms)
	{
		$attribute = $Farm.Properties
		$ServerType = $attribute.'pae-serverpooltype'
		if($ServerType -eq 8)
		{
			$FarmName = $attribute.'pae-displayname'
			$paeMemberDNOf = "CN=" + $FarmName + ",OU=Server Groups,DC=vdi,DC=vmware,DC=int";
			$PoolName = Get-PoolName -serverCN $paeMemberDNOf
			$Selector2.Filter = "(pae-MemberDNOf=$paeMemberDNOf)"
			$Selector2.PageSize = 1000
			$Selector2.SearchScope = "Subtree"
			$hosts = $Selector2.FindAll()
			if($hosts -ne $null)
			{
				foreach($h in $hosts)
				{
					$attribute = $h.Properties
					$hostname = $attribute.'iphostnumber'
					write-host("{0}={1}" -f $($hostname),$PoolName)
				}
			}
		}
	}
}
$LDAPEntry.Close()
write-host
Write-Host "[Horizon Security Server]"
Write-Host "--------------------------"
$LDAPPath = 'LDAP://localhost:389/OU=Server,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(&(objectClass=pae-VDMProperties)(pae-VDMSecurityServer=1))"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
$VDMSS = $Selector.FindAll()
if($VDMSS -ne $null)
{
	foreach($h in $VDMSS)
	{
		$attribute = $h.Properties
		$namevaluepair = $attribute.'pae-namevaluepair'
		foreach($item in $namevaluepair)
		{
			if($item.StartsWith("gw-clientHost"))
			{
				$pos = $item.indexOf("=")
				$vdmhost = $item.substring($pos+1)
			}
			if($item.StartsWith("gw-clientPort"))
			{
				$pos = $item.indexOf("=")
				$vdmport = $item.substring($pos+1)
			}
			if($null -ne $vdmhost -and $null -ne $vdmport)
			{
				write-host("{0}:{1}" -f $vdmhost,$vdmport)
				break
			}
		}
	}
}
$LDAPEntry.Close()
write-host
Write-Host "[Horizon Identity Server]"
Write-Host "--------------------------"
$LDAPPath = 'LDAP://localhost:389/OU=Authenticator,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-SAMLAuthenticator)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
$idps = $Selector.FindAll()
if($idps -ne $null)
{
	foreach($h in $idps)
	{
		$attribute = $h.Properties
		$url = $attribute.'pae-samlmetadataurl'
		write-host($url)
	}
}
$LDAPEntry.Close()

Write-Host

$count = 0
$tips = ""
Write-Host "[ActiveDirectory_server]"
Write-Host "----------------------------"
$d = ( gwmi win32_computersystem).domain
$ips = @(([net.dns]::GetHostEntry($d)).AddressList)
if($? -and $ips)
{
	foreach($ip in $ips)
	{
		if($ip.AddressFamily -eq "InterNetwork")
		{
			if($count -eq 0)
			{
				$tips = $ip.IPAddressToString
			}
			else
			{
				$tips = $tips +","+ $ip.IPAddressToString
			}
			$count = $count + 1
		}
	}
	Write-Host $d "=" $tips
}

Write-Host 
Write-Host "[Composer_server]"
Write-Host "-------------------"
if($vcs -ne $null)
{
	foreach($vc in $vcs)
	{
		$attribute = $vc.Properties
		$compURL = $attribute.'pae-sviurl'
		Write-Host($compURL)
	}
}
$LDAPEntry.Close()
write-host
Write-Host "[Horizon View Cluster/Cloud Pod]"
Write-Host "---------------------------------"
$GlobalLDAPPath = 'LDAP://localhost:389/OU=Pod,OU=Properties,DC=vdiglobal,DC=vmware,DC=int'
$LDAPPath = 'LDAP://localhost:389/CN=Common,OU=Global,OU=Properties,DC=vdi,DC=vmware,DC=int'
$isFederationPodEnabled = $false
$Error.Clear()
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $GlobalLDAPPath
if($LDAPEntry.Path -ne $NULL)
{
	$isFederationPodEnabled = $true
}
else
{
	$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
}


if($isFederationPodEnabled -eq $true)
{
	$Selector = New-Object DirectoryServices.DirectorySearcher
	$Selector.SearchRoot = $LDAPEntry
	$Selector.Filter = "(objectClass=pae-PodProperties)"
	$Selector.PageSize = 1000
	$Selector.SearchScope = "Subtree"
	$pods = $Selector.FindAll()
	$LDAPEntry.Close()
	if($pods -ne $null)
	{
		foreach($pod in $pods)
		{
			$attribute = $pod.Properties
			$displayName = $attribute.'pae-displayname'
			$path = $pod.path
			$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $path
			$Selector = New-Object DirectoryServices.DirectorySearcher
			$Selector.SearchRoot = $LDAPEntry
			$Selector.Filter = "(objectClass=pae-PodEndpoint)"
			$Selector.PageSize = 1000
			$Selector.SearchScope = "Subtree"
			$csinpods = $Selector.FindAll()
			$LDAPEntry.Close()
			if($csinpods -ne $null)
			{
				foreach($csinpod in $csinpods)
				{
					$attribute = $csinpod.Properties
					$csname = $attribute.'pae-url'
					write-host $displayName, $csname -separator "#"
				}
			} 
		}
	}
}
else
{
	
	$Selector = New-Object DirectoryServices.DirectorySearcher
	$Selector.SearchRoot = $LDAPEntry
	$Selector.Filter = "(objectClass=pae-VDMProperties)"
	$Selector.PageSize = 1000
	$Selector.SearchScope = "Subtree"
	$idps = $Selector.FindAll()
	if($idps -ne $null)
	{
		foreach($h in $idps)
		{
			$attribute = $h.Properties
			$clustername = $attribute.'pae-clustername'
			foreach($svr in $csservers)
			{
				write-host($clustername) , $svr -separator "#"
			}
		}
	}
}
$LDAPEntry.Close()
write-host

