﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$testargs=$args
$reportingname='EXO\'+$testargs[0]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

	$sendascount=0;
	$sendonbehalfcount=0;
    try{
        $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "nonowneractvts" -keyFileName "knonowneractvts" -EgPath $egurkhaPath
        if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
            $datafile=$readfiles[1] -replace (".csv",".dat") 
            $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
            $excAdminAuditLog= import-csv $csvfile -Encoding $encTyp
            Remove-Item $csvfile
            Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'nonowneractvts' -InputFile $readfiles[3]
            Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'knonowneractvts' -InputFile $readfiles[4]
            Write-Host 'ReadFile:'$readfiles[3]
        }
    }
    catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
    
    [System.GC]::GetTotalMemory($true) | out-null
	if ($excAdminAuditLog -ne $null)
	{
	    foreach($log in $excAdminAuditLog){
		$data= $log.AuditData | ConvertFrom-Json

		if($data -ne "" -and $data -ne $null){

		    if(($data.ClientInfoString).Length -gt 128)
			{
			   $data.ClientInfoString= $data.ClientInfoString.Substring(0,126)
			}

		    if($data.Operation -eq  'SendAs')
		    {
			    Write-Host '>##SendAs'  $data.CreationTime ~!~ $data.Id ~!~  $data.Operation ~!~ $data.ResultStatus ~!~ $data.UserType ~!~ $data.UserId ~!~ $data.ClientIPAddress  ~!~ $data.ClientInfoString ~!~ $data.ExternalAccess ~!~ $data.MailboxOwnerUPN ~!~ $data.OrganizationName ~!~ $data.OriginatingServer ~!~  $data.Item.Subject ~!~ "-" ~!~ "-" ~!~ $data.SendAsUserMailboxGuid ~!~ $data.SendAsUserSmtp '>'
			    $sendascount++
		    }
		    if($data.Operation -eq  'SendOnBehalf')
		    {
			    Write-Host '>##SendOnBehalf'$data.CreationTime ~!~ $data.Id ~!~ $data.Operation ~!~ $data.ResultStatus ~!~ $data.UserType ~!~ $data.UserId ~!~ $data.ClientIPAddress  ~!~ $data.ClientInfoString ~!~ $data.ExternalAccess ~!~ $data.MailboxOwnerUPN ~!~ $data.OrganizationName ~!~ $data.OriginatingServer ~!~ $data.Item.Subject ~!~ $data.SendOnBehalfOfUserMailboxGuid  ~!~ $data.SendOnBehalfOfUserSmtp ~!~ "-" ~!~ "-" '>'
			    $sendonbehalfcount++
		    }
		}
	    }
	    Write-Host ">##CountSendAs" $sendascount '>'
	    Write-Host ">##couuntSendOnBehalf" $sendonbehalfcount '>'
	}
[System.GC]::GetTotalMemory($true) | out-null