﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear 

$testargs=$args
$reportingname='EXO\'+$testargs[0]
$ExcludingNames=$testargs[1]
$mTime=$testargs[2]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt')
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}

$sysDateFmt=Get-Date # -Format 'MM/dd/yyyy HH:mm:ss'
$endDat=$sysDateFmt   #[datetime]::ParseExact($sysDateFmt,'MM/dd/yyyy HH:mm:ss',$null) 
$startDat=$endDat.AddMinutes(-$mTime)
try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $TotMailbxcnt= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
        Write-Host 'ReadFile:'$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
[System.GC]::GetTotalMemory($true) | out-null
if( $TotMailbxcnt -eq $null -or  $TotMailbxcnt -eq ''){	
	write-host "#TotMailbxcnt~-5"   
	Write-Host '#FrwdMailbxcnt~-5'  
	Write-Host '#litigationhold~-5' 
	Write-Host '#Inplacehold~-5'    
	Write-Host '#ShrdMailboxes~-5'  
	Write-Host '#RecChgMailbx~-5'   
	Write-Host '#RecCreMailbx~-5'   
	Write-Host '#SoftTotMailbx~-5'  
	Write-Host '#AllmailboxHold~-5'
	exit
}
$ShrdMailboxescnt=0
$FrwdMailboxescnt=0
$litigationholdcnt=0
$RecChgMailbx=0
$SoftTotMailbx=0
$RecCreMailbx=0
$Inplaceholdcnt=0
	
$ExcludingNames=$ExcludingNames.Replace("_"," ")	
$ExcludingName=$ExcludingNames.split('|')

$TotMailbxcnt= $TotMailbxcnt|where {$ExcludingName -notcontains $_.DisplayName}
$mxbxcnt=0
$TotMailbxcnt|ForEach-Object{$mxbxcnt++}
$ShrdMailboxes = $TotMailbxcnt|Where{$_.RecipientTypeDetails -eq 'SharedMailbox'}|Select *
$litigationholdTmp=$TotMailbxcnt|Where{$_.LitigationHoldEnabled -eq $true}|Sort-Object -Property WhenChanged -Descending
$litigationholdcnt=$litigationholdTmp.Count
$litigationhold=$litigationholdTmp | select -First 100
$FrwdMailbx=$TotMailbxcnt|Where{$_.DeliverToMailboxAndForward -eq $true -and $_.ForwardingSmtpAddress -ne $null -and $_.ForwardingSmtpAddress -ne ''}|Select *
$Inplacehold=$TotMailbxcnt|Where{$_.InPlaceHolds -eq $true -and $_.InPlaceHolds -notcontains ' '}|Select *


# Shrd mailbox DD measure  
if($ShrdMailboxes -ne $null){
	foreach($ShrdMailbox in $ShrdMailboxes){  
	    $ShrdMailboxescnt++
	    Write-Host '#ddShrdMailboxes'$ShrdMailbox.UserPrincipalName '~!~' $ShrdMailbox.Identity
	}
}

# SoftDelete mailbox DD measure
	   
if($TotMailbxcnt -ne $null){
    foreach($TotMailbx in $TotMailbxcnt){ 
        $softDelDat=([String]$TotMailbx.WhenSoftDeleted).Trim()
        if($softDelDat -ne $null -and $softDelDat -ne ''){
            $SoftDelTime=Eg-ParseExact -dateStr $softDelDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt 
            #$SoftDelTime = [DateTime]::ParseExact($TotMailbx.WhenSoftDeleted,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            if($SoftDelTime -gt $startDat){
                $SoftTotMailbx++
		        Write-Host '#ddSoftTotMailbx'$TotMailbx.DisplayName '~!~'$TotMailbx.UserPrincipalName '~!~' $TotMailbx.WhenSoftDeleted
            }
        }
        # New Created mailbox DD measure
        $mbCreatDat=([String]$TotMailbx.WhenCreated).Trim()
	    if($mbCreatDat -ne $null -and $mbCreatDat -ne ''){
            $WhenCreatedTime =Eg-ParseExact -dateStr $mbCreatDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            #$WhenCreatedTime = [DateTime]::ParseExact($TotMailbx.WhenCreated,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
    		if($WhenCreatedTime -gt $startDat){
                $RecCreMailbx++
		        Write-Host '#ddRecCreMailbx'$TotMailbx.DisplayName '~!~'$TotMailbx.UserPrincipalName '~!~' $TotMailbx.WhenCreated
            }
        }
        # Recently Modified mailbox DD measure
        $mbChangDat=([String]$TotMailbx.WhenChanged).Trim()
        if($mbChangDat -ne $null -and $mbChangDat -ne ''){
            $WhenCHanTime =Eg-ParseExact -dateStr $mbChangDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            #$WhenCHanTime = [DateTime]::ParseExact($TotMailbx.WhenChanged,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
    	    if($WhenCHanTime -gt $startDat){
                $RecChgMailbx++
		        Write-Host '#ddRecChgMailbx'$TotMailbx.DisplayName '~!~'$TotMailbx.UserPrincipalName '~!~' $TotMailbx.WhenChanged
	        }
	    }
    }
}

# Frwd mailbox DD measure
if($FrwdMailbx -ne $null){
	foreach($Mailbx in $FrwdMailbx){  
	    $FrwdMailboxescnt++
	    if($Mailbx.ForwardingSmtpAddress -eq ''){
		    $Mailbx.ForwardingSmtpAddress='-'
	    }
	    Write-Host '#ddfrwdmailbx '$Mailbx.UserPrincipalName '~!~' $Mailbx.ForwardingSmtpAddress '~!~'$Mailbx.DeliverToMailboxAndForward
    }
}

#litigation Measure DD 
if($litigationhold -ne $null){
	foreach($litigation in $litigationhold){
		#$litigationholdcnt++
		Write-Host '#ddlitigationhold '$litigation.DisplayName '~!~' $litigation.PrimarySmtpAddress '~!~'$litigation.RecipientTypeDetails
	}
}

#Inplacehold Measure DD
if($Inplaceholdcnt -ne $null){
    foreach($Inplacehold in $Inplaceholdcnt){
	    if($Inplacehold -ne $null -and $Inplacehold -ne '' ){
		    $Inplaceholdcnt++
		    Write-Host '#ddInplacehold '$Inplacehold.DisplayName '~!~' $Inplacehold.PrimarySmtpAddress '~!~'$Inplacehold.RecipientTypeDetails
	    }
    }
}
write-host "#TotMailbxcnt~"   $mxbxcnt
Write-Host '#FrwdMailbxcnt~'  $FrwdMailboxescnt
Write-Host '#litigationhold~' $litigationholdcnt
Write-Host '#Inplacehold~'    $Inplaceholdcnt
Write-Host '#ShrdMailboxes~'  $ShrdMailboxescnt
Write-Host '#RecChgMailbx~'   $RecChgMailbx
Write-Host '#RecCreMailbx~'   $RecCreMailbx
Write-Host '#SoftTotMailbx~'  $SoftTotMailbx

if($mxbxcnt -gt 0){
	if($litigationholdcnt -eq $mxbxcnt){
		Write-Host '#AllmailboxHold~'1
	}else{
		Write-Host '#AllmailboxHold~'0
	}
}else{
    Write-Host '#AllmailboxHold~'0
}
[System.GC]::GetTotalMemory($true) | out-null