$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}
Add-PSSnapin Citrix.Authentication.FederatedAuthenticationService.V1

Write-Host "FAS MS Certificate Authority"
Write-Host "============================"
$FasMsCertificateAuthorities = Get-FasMsCertificateAuthority -Default
if ($FasMsCertificateAuthorities -ne $null)
{
	foreach ($FasMsCertificateAuthority in $FasMsCertificateAuthorities)
   	{	
		$count = 0
        $PublishedTemplates = ""
		$PubTemplates = $FasMsCertificateAuthority.PublishedTemplates
        if ($PubTemplates -ne $null)
        {
		    foreach ($PubTemplate in $PubTemplates)
		    {
			    if ($count -eq 0)
			    {
				    $PublishedTemplates = $PubTemplate
			    }
			    else
			    {
				    $PublishedTemplates = $PublishedTemplates + "," + $PubTemplate
			    }
			    $count = $count + 1
		    }
        }
       	Write-Host ($FasMsCertificateAuthority.Address,$FasMsCertificateAuthority.IsAccessible,$FasMsCertificateAuthority.IsDefault,$PublishedTemplates) -Separator "#~#"
   	}
}


 
