$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding 
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

Import-Module -Name Intersight.PowerShell

[string]$ApiKeyId = $args[0]
[string]$ApiKeyFilePath = $args[1]
[string]$URL = $args[2]
[string]$BasePath = "https://intersight.com"
if ($URL -ne $null -and $URL -ne "none")
{
	[string]$BasePath = $URL
}

$ProxyHost = 'none'
$ProxyUser = 'none'
$ProxyPwd = 'none'

if($args.Length -eq 5)
{
	
	$eGInstallDir = $args[3]
	# The format is https://ip:port#user#password
	$ProxyArr = $args[4].ToString().Split('#') 
	if($ProxyArr.Length -eq 3)
	{
		$ProxyHost = $ProxyArr[0]
		$ProxyUser = $ProxyArr[1]
		$ProxyPwd = $ProxyArr[2]
		$OEPath = $eGInstallDir + "\lib\OE.exe"
		$ProxyPwd = & $OEPath $ProxyPwd
	}
}

if($ProxyHost -ne 'none')
{
	[system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($ProxyHost)
	if($ProxyUser -ne 'none' -and $ProxyPwd -ne 'none')
	{
		$proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $ProxyUser, $(convertto-securestring $ProxyPwd -asplaintext -force)
		[system.net.webrequest]::defaultwebproxy.credentials = $proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
		[system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	}
}

$ApiParams = @{                       
    BasePath          = $BasePath
    ApiKeyId          = $ApiKeyId
    ApiKeyFilePath    = $ApiKeyFilePath
    #HttpSingingHeader = @("(request-target)", "Host", "Date", "Digest")
    HttpSigningHeader = @("(request-target)", "Host", "Date", "Digest")
}
Set-IntersightConfiguration @ApiParams

$PSUs = Get-IntersightEquipmentPsu
if ($PSUs -ne $null)
{
	foreach($PSU in $PSUs)
	{
		Write-Host ($PSU.Dn,$PSU.OperState,$PSU.Presence,$PSU.Voltage,$PSU.PsuId,$PSU.Vid,$PSU.PartNumber,$PSU.Revision) -Separator "#~#"
	}
}


