#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get the Subnet Information of Active Directory
.DESCRIPTION

			This Script is used to collect the Subnet Information of Active Directory
			Measure are: 
			1.Subnets in the site
			
.INPUTS
			CONST_TEST_HDR and CONST_TEST_END
.OUTPUTS
			Collect the Meausres of Subnet Information in following format
            <Site Name>
            <Subnet>

#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]


import-module ActiveDirectory

Clear-Host

#To get the Subnet Information of Active Directory
Function getADSubnetInfo
{

    $Forest = Get-ADForest -Current LocalComputer | select RootDomain,PartitionsContainer
	$rootDomain = $Forest.RootDomain
	$ConfigurationPart = ($Forest.PartitionsContainer -Replace "CN=Partitions,","")
	$AllSites = Get-ADObject -Server $rootDomain -Filter { objectClass -eq "site" } -SearchBase $ConfigurationPart -Properties *

	foreach ( $Site in $AllSites )
	{
		$siteName = $Site.Name
		Write-Host "Site Name : " $siteName
		$subnets = $Site.siteObjectBL
		if ( $subnets -ne $null)
		{
			foreach ($subnet in $subnets)
			{
				$SubnetSplit = $Subnet.Split(",")
					Write-Host $SubnetSplit[0].Replace("CN=","")
			}
		}
		else
		{
			Write-Host "None"
		}
	}

}

#Main Region Starts
try
{
	
    Write-Host $global:CONST_TEST_HDR
    Write-Host "-------------------"
       
    getADSubnetInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends

