#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get the Operation masters of Active Directory
.DESCRIPTION

			This Script is used to collect the Operation masters of Active Directory
			Measures are:
			1.PDC emulator server,
			2.RID master server,
			3.Infrastructure master server,
			4.Schema master server,
			5.Domain naming master server

.INPUTS
			CONST_TEST_HDR and CONST_TEST_END
.OUTPUTS
			Collect the Measures of  Operation masters in following format

            <PDCEmulator><Delimiter><RIDMaster><Delimiter><InfrastructureMaster><Delimiter>
            <SchemaMaster><Delimiter><DomainNamingMaster>
#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]


import-module ActiveDirectory

Clear-Host

# To get the Operation masters of Active Directory

Function getADConfigOprtnMastrInfo
{
	
	$Forest = Get-ADForest -Current LocalComputer | select SchemaMaster,DomainNamingMaster
	$Domain = Get-ADDomain | select PDCEmulator,RIDMaster,InfrastructureMaster
	Write-Host "PDCEmulator: " $Domain.PDCEmulator
	Write-Host "RIDMaster: " $Domain.RIDMaster
	Write-Host "InfrastructureMaster: " $Domain.InfrastructureMaster
	Write-Host "SchemaMaster: " $Forest.SchemaMaster
	Write-Host "DomainNamingMaster: " $Forest.DomainNamingMaster

}

#Main Region Starts
try
{
	   
   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------------------------"
   
    getADConfigOprtnMastrInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends


