param(
    [int] $SessionID = 0,
    [string] $UserName="",
    [string] $SessionState = "Disconnected", # Either Active or Disconnected
    [switch] $IdleTime,
    [int] $IdleTimeInMinutes=15,
    [string] $PriorityToChange = "BelowNormal", # Should be one of the following Normal/Idle/RealTime/High/BelowNormal/AboveNormal
    [string] $ProcessesToIgnore="",
	[string]$revertPrrtyFrUsrsInRgstry = "false"
    )

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Set-StrictMode -Version 1
[string[]] $DefaultIgnoredProcesses = @('cmd', 'dwm', 'explorer','conhost','taskhostw','winlogon','powershell', 'java' ,'js', 'vm-jsn','jsn', 'tomcat','wfshell','ctxgfx')
$global:PrePriorityIDWise = @{}

function DeleteRegistryKey
{
    param(
        [parameter(Mandatory=$true)]$SessionID
         )
    Remove-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -Recurse
}

function DeleteRegistryKeys
{
    Remove-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\*" -Recurse
}

#revert the process pririty for already changed sessions when session id comes to active from idle or disconnected state
function RevertPrrtyFrUsrsInRgstry
{
    [boolean] $keyFound = Test-Path -path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation"
    if($keyFound)
    {
        $inFile = "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\"
        $allPath = Get-ChildItem -path ($inFile -replace ([char] 0xa0), '?') | Select Name,Property
       
        foreach ($crntPath in $allPath)
        {
            $pathName = $crntPath.Name      
            $sessionId = $pathName.Substring($pathName.LastIndexOf("\")+1)		
		
            $processes = (Get-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$sessionId\").CurrentPriorities | ConvertFrom-Csv
       
            foreach ($process in $processes)
            {
				if($process.ProcessName -eq "wfshell")
				{
					continue
				}
                $priorityToChange =  "$($process.PriorityClass)"
                $curntPriority = ""
                try
                { 
                    $curntPriority = (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass
                    (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass = $priorityToChange 
          
                    Write-host "Successfully reverted the priority for the process $($process.ProcessName) with pid $($process.Id) from $($curntPriority) to $($priorityToChange) in the session $SessionID. "
                }
                catch
                {
                    $Host.UI.WriteErrorLine("Failed to revert the priority for the process $($process.ProcessName) with pid $($process.Id) from $($curntPriority) to $($priorityToChange) in the session $SessionID. ")
                }
               
            }
        }
		DeleteRegistryKeys       
    }
}

function CreateRegistryKeys
{
    [Boolean] $keyFound = $false
    [boolean] $keyFound = Test-Path -path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation"
    if($keyFound -eq $False)
    {
        New-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent" -Name "Automation" -ErrorAction SilentlyContinue | Out-Null
    }
}

#Export the process details to registry
function ExportProcessPriorityState 
{
    param(
        [parameter(Mandatory=$true)]$SessionID,
        [parameter(Mandatory=$true)]$UserName,
        [parameter(Mandatory=$true)]$ProcessList
    )

    $sessionPriority = $ProcessList | Select-Object -Property SessionID,ProcessName,Id,PriorityClass

    For($incr = 0; $incr -lt $sessionPriority.Length; $incr++ )
	{
        $CurntPrcsID = $sessionPriority[$incr].Id
        $sessionPriority[$incr].PriorityClass = $global:PrePriorityIDWise.$CurntPrcsID
	}

    New-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation" -Name "$SessionID" -ErrorAction SilentlyContinue | Out-Null
    New-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -PropertyType String -Name UserName -Value $UserName | Out-Null
    New-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -PropertyType MultiString -Name CurrentPriorities -Value ($sessionPriority | ConvertTo-Csv) -Force | Out-Null
}

#Find whether session key already available or not in registry
function TestRegistryValue
{
    param (
        [parameter(Mandatory=$true)][ValidateNotNullOrEmpty()]$Path,
       [parameter(Mandatory=$true)][ValidateNotNullOrEmpty()]$Value
    )
    try
    {
        Get-ItemProperty -Path $Path -Name $Value -ErrorAction Stop | Out-Null
        return $True
    }
    catch
    {
        return $False
    }
    
}

#change the process priority for session Id which is went to idle or disconnected state
Function ChangePrrtyForUsers
{   
	[string] $PreviousUserName = $null
	[string] $PreviousExportDateStr = $null
	[int] $PreviousWfShellPID = -1
	$PriorityIDWise = @{}

	$Realtime = [System.Collections.Generic.List[string]]@()
	$High = [System.Collections.Generic.List[string]]@()
	$Above_normal = [System.Collections.Generic.List[string]]@()
	$Normal = [System.Collections.Generic.List[string]]@()
	$Low = [System.Collections.Generic.List[string]]@()

	$Failed = [System.Collections.Generic.List[string]]@()
	$Excluded = [System.Collections.Generic.List[string]]@()

	if($SessionID -gt 0)
	{
		# Create the Automation key as it is not available by default
		CreateRegistryKeys
		
		# Find the session id if we exported his processes before in the registry
		$KeyExists = TestRegistryValue -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -value CurrentPriorities 
		
		# If the session id is found, collect all the attributes from the regisry like username, export date and its previous process priorities
		if($KeyExists -eq $True)
		{
			$PreviousPriorities = (Get-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID\").CurrentPriorities | ConvertFrom-Csv
			$PreviousUserName = (Get-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID\").UserName
			
			# Find the previous wfshell process ID
			[int] $PreviousWfShellPID = @($PreviousPriorities | Where-Object {$_.SessionID -eq $SessionID -and $_.ProcessName -eq "wfshell"} -ErrorAction SilentlyContinue)[0].ID

			foreach ($process in $PreviousPriorities)
			{  
				$PriorityIDWise.add($process.Id,$process.PriorityClass)
			}
		}
		
		# If the session id is found in the registry but the given username and the username in the registry are different. Could be the 
		# session id is reused by the OS.
		if($KeyExists -and ($PreviousUserName -ne $null -and $UserName -ne $PreviousUserName))
		{
			DeleteRegistryKey -SessionID $SessionID
		}
		
		# Find all the processes that are running currently for the given session ID
		[array]$RunningProcesses = @(Get-Process | Where-Object {$_.SessionID -eq $SessionID} -ErrorAction SilentlyContinue)

		# Find the current wfshell process ID
		[int] $CurrentWfShellPID = @($RunningProcesses | Where-Object {$_.SessionID -eq $SessionID -and $_.ProcessName -eq "wfshell"} -ErrorAction SilentlyContinue)[0].ID

		if (($SessionState -eq "Active") -or ($SessionState -eq "Disconnected"))
		{
			if($IdleTimeInMinutes -ge 1)
			{
				If ($KeyExists -eq $False)
				{
					$prirtyChngdPrcsLst = [System.Collections.ArrayList]@()
                    $global:PrePriorityIDWise.clear()
					foreach ($process in $RunningProcesses)
					{						
						if($process.ProcessName -eq "wfshell")
						{
							$global:PrePriorityIDWise.add($process.Id,$process.PriorityClass)                                
							[void]$prirtyChngdPrcsLst.add($process)
						}
						
						# Ignore processes if available in DefaultIgnoredProcesses or ProcessesToIgnore parameter				
						if(($DefaultIgnoredProcesses -like $($process.ProcessName)) -or (($ProcessesToIgnore -split "/") -like $($process.ProcessName)))
						{
							$excldPrc = "$($process.ProcessName) ($($process.Id))"

							[void]$Excluded.Add($excldPrc)	
						}
						else
						{
							$CurrentPriority = "$($process.PriorityClass)"
							try
							{
								if($CurrentPriority -ne "BelowNormal")
								{
    							    $global:PrePriorityIDWise.add($process.Id,$process.PriorityClass)                                
								    $process.PriorityClass = "$($PriorityToChange)" 				
								    [void]$prirtyChngdPrcsLst.add($process)	
                                
                                    $stmnt = "$($process.ProcessName)($($process.Id))";
								    if($CurrentPriority -eq "Normal")
								    {
									    [void]$Normal.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "High")
								    {
									    [void]$High.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "AboveNormal")
								    {
									    [void]$Above_normal.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "Idle")
								    {
									    [void]$Low.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "RealTime")
								    {
									    [void]$Realtime.add($stmnt);
								    }	
                                }						
							                                
                            }
							catch
							{									
								[void]$Failed.add( "$($process.ProcessName)($($process.Id))");	
							}
                        }						
					}

					if($Excluded -ne $null -and $Excluded.Count -gt 0)
                    {							
						Write-host ("Excluded from reduce priority in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Excluded)). ")
					}
                    if($Realtime -ne $null -and $Realtime.Count -gt 0)
                    {					
					    Write-host "Successfully reduced the priority from Realtime to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Realtime)). ";				
                    }
                    if($High -ne $null -and $High.Count -gt 0)
                    {						
	                    Write-host "Successfully reduced the priority from High to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($High)). ";
					}
					if($Above_normal -ne $null -and $Above_normal.Count -gt 0)
                    {						 
						Write-host "Successfully reduced the priority from Above normal to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Above_normal)). ";
					}
					if($Normal -ne $null -and $Normal.Count -gt 0)
                    {						 
						Write-host "Successfully reduced the priority from Normal to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Normal)). ";
					}
					if($Low -ne $null -and $Low.Count -gt 0)
                    {						 
						Write-host "Successfully reduced the priority from Low to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Low)). ";
					}
					
					if($Failed -ne $null -and $Failed.Count -gt 0)
                    {
						$FailedPrcss = CnvrtLstToStr($Failed)
						$Host.UI.WriteErrorLine( "Failed to reduce the priority to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $FailedPrcss. ")
					}

					ExportProcessPriorityState -SessionID $SessionID -ProcessList $prirtyChngdPrcsLst -UserName $UserName
				}
			}
			elseif($IdleTimeInMinutes -eq 0)
			{		
				If($KeyExists -eq $True)
				{	    
					# It is possible that the SessionID and Username can be same after you logged off directly from idle.
					# In this case i had seen you before and recorded you in the automation. 
					# We are comparing the wfshell.exe process id so verify whether i had seen you before

					if($CurrentWfShellPID -eq $PreviousWfShellPID)
					{
						foreach ($process in $PreviousPriorities)
						{
							if($process.ProcessName -eq "wfshell")
							{
								continue
							}
							
							$processId = $process.Id
							$prevPriortity = $PriorityIDWise.$processId
                            $curntPriority = ""
							try
							{
                                 $curntPriority = (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass
                                 (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass = $prevPriortity 
								 Write-host "Successfully reverted the priority for the process $($process.ProcessName) with pid $($process.Id) running in session $SessionID from $($curntPriority) to $($prevPriortity). "
							}
							catch
							{
								$Host.UI.WriteErrorLine("Failed to revert the priority for the process $($process.ProcessName) with pid $($process.Id) running in session $SessionID from $($curntPriority) to $($prevPriortity). ")
							}
						}
						DeleteRegistryKey -SessionID $SessionID
					}
					# Now delete the session id from the Automation key as he has recovered from idle session to active
				}
			}   
		}
    }

}

Function CnvrtLstToStr
{
 param(
        [parameter(Mandatory=$true)]$PrcsList
        )

    $PrcsStr = ""
    try
	{
        if($PrcsList -ne $null -and $PrcsList.Count -gt 0)
        {
            $PrcsArray = $PrcsList.ToArray() | Sort-Object

            if($PrcsArray -ne $null -and $PrcsArray.Count -gt 0)
            {

                $PrcsStr = ($PrcsArray -join ", ")

            }
         }
     }
     catch
     {
        $PrcsStr = ""
     }

    return $PrcsStr
}

#code start here
Function ExecuteScript
{
    if($revertPrrtyFrUsrsInRgstry -eq "true")
    {
	    RevertPrrtyFrUsrsInRgstry
    }
    else
    {
        ChangePrrtyForUsers
    }	
}

ExecuteScript
# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU+sJDCyNpP5Xr85P1ToUi+LFm
# m26gghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFP3x/K2wUSABqoQF
# 9EtXUBPjTMYAMA0GCSqGSIb3DQEBAQUABIICAC83F79L8VlqIXEKDgvOd2iCGfaW
# vWw4wLgV48OKTSSv/nGdM6f6ja/yRZkK6mXacosg04cSXvhVnyKYh7GC+xu6nbRY
# 0GB9sQ0qyGXsAa6VoL9HSc/9csiWAb1xt7wEfOJXqCTUD2AFbOAZE0R8V7/9dHlE
# 0HBSi9jigDdjkrt4+CdLsM5ZIpSSheUiZ6535uo90lQrexFUZVxGf/GCcTtPBIux
# HuSwkrMghTqJznw45LAkfuIFJ2GZytshM8uE7qbIy6shYkGXvsrIa+fhdE325HpI
# XqR+v8oVx9gQNcvcwLi9lmgx+3ppn0fU9bPSi2YNyV3hTqTBpoT66slsh5/DPgVe
# 199Zo7qL3Tv43+UJsvXI+AUGa53dq/uNCbNDjy6AlV0X4gkAjxvVwFyvH2Bra1aG
# pJAEs+NFhlBcOPFIPlh+pHHiMScTwKJfSzcbEiP3UVoqfp3hZpx9gmEJ7MoE+NQt
# RbCpHuzWgVBW4Tzy4NayDJP0iQh6tKmSYM4cx1zXMXWY+oka3ZmifH5i8C8C8xtR
# 1HYjFmmLS4H6on6TZQEtxTJ/2LJKcYAKnHd/Yc8rHlFkR3gXlgV9qjtewNh/V9Yx
# u3T/j33x7YWAKrFagJZ7va3r0jCqYbbDFWJQPGmKXYM1/nyKnzW5afrXx4WG2TEt
# gcaW8zh82YyMAPl8oYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MjAzMDIyMzM3NTdaMC8GCSqGSIb3DQEJBDEiBCCFS+1Fmq+VuQ3UoQWfZ/7L/s2q
# iI5P5ehyxZpcexB49jANBgkqhkiG9w0BAQEFAASCAQC7hZInThr33SE8hJhqapiQ
# LPAH/qBJEj7HVwD7hwOXK2tN/QZpdYM+XVeOJrh3c0N6SWwgccKATC3SFgMQoyPM
# UAAiNr/XB4ws2pxHmeW1QVVdvVtIJGC3CvGKonFeNT3Dbc225DxntAkbCa9HiaWx
# NMzojnYoJWPfAs9tmCiF0U/DaUcFvxNaly6KaEyX/2Dpx/BN6aHHeJauusUHhI4W
# wriU26VlEgfWBfhtNHTiw98DY2MnHaWcAK9jhMcvBPhXb1HGIe+7EgclF/lu68jv
# NWpMRPuFiY/6vxzo0HdR6uuoYyB/PJTyDP37351gv7JIqGql7qopQoB7ohpA/9OD
# SIG # End signature block
