$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}


$computer = $env:computername

Write-Host "Client Access Server Rollup Details"
Write-Host "---------------------------------------"
$Exch = Get-ExchangeServer -identity $computer  | where {$_.ServerRole -ne "Edge"} 
if($Exch)
{
	# Check for exchange server admin version
	if($Exch.AdminDisplayVersion.major -eq "8")
	{
		$E2K7 = $true
	}
	if($Exch.AdminDisplayVersion.major -eq "14")
	{
		$E2K = $true
	}
	Write-Host "Server Name: " $computer
	Write-Host "Server Role: " $Exch.ServerRole
	Write-Host "Exchange Version: " $Exch.AdminDisplayVersion
	
	#Get Exchange server version
	$MsxVersion = $Exch.ExchangeVersion		
		
	$Srv = $Exch.Name
		
	if($E2K -eq $true)
	{
		$key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\AE1D439464EB1B8488741FFA028E291C\Patches\"
	}
		
	if($E2K7 -eq $true)
	{
		$key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\461C2B4266EDEF444B864AD6D9E5B613\Patches\"
	}
		
	$type = [Microsoft.Win32.RegistryHive]::LocalMachine
	$regKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($type, $Srv)
	$regKey = $regKey.OpenSubKey($key)
		
	if ($regKey.SubKeyCount -eq 0)
	{
		$DetailRollup+= "No Patches installed"
	}
	else
	{
		#Loop each of the subkeys (Patches) and gather the Installed date and Displayname of the Exchange patch
		$ErrorActionPreference = "SilentlyContinue"
		ForEach($sub in $regKey.GetSubKeyNames())
		{
			$SUBkey = $key + $Sub
			$SUBregKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($type, $Srv)
			$SUBregKey = $SUBregKey.OpenSubKey($SUBkey)
			ForEach($SubX in $SUBRegkey.GetValueNames())
			{
				# Display Installed date and Displayname of the Exchange patch
				IF ($Subx -eq "Installed") 
				{
					$d = $SUBRegkey.GetValue($SubX)
					$d = $d.substring(4,2) + "/" + $d.substring(6,2) + "/" + $d.substring(0,4)
				}
				IF ($Subx -eq "DisplayName") 
				{
					$cd = $SUBRegkey.GetValue($SubX)
					$DetailRollup+=  "Rollup Version:  $($d) - $($cd)"
				}
			}
		}	
		$DetailRollup+=  ""
	}
	Write-Host $DetailRollup	
}

Write-Host "Client Access Server - Autodiscover"
Write-Host "---------------------------------------"

$cas = Get-ClientAccessServer -identity $computer
if ($cas)
{	
	Write-Host "Server Name: " $cas.name
	Write-Host "AutoDiscoverServiceInternalUri: " $cas.AutoDiscoverServiceInternalUri
	Write-Host "AutoDiscoverSiteScope: " $cas.AutoDiscoverSiteScope
}


Write-Host "Client Access Server - Autodiscover Virtual Directory"
Write-Host "----------------------------------------------------------"
$AUTOVD = Get-AutodiscoverVirtualDirectory -Server $computer
if ($AUTOVD)
{
	Write-Host "Server Name: " $AUTOVD.Server
	Write-Host "Name: " $AUTOVD.name
	Write-Host "InternalURL: " $AUTOVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $AUTOVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $AUTOVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $AUTOVD.ExternalAuthenticationMethods
	
}


Write-Host "Client Access Server - ActiveSync Virtual Directory"
Write-Host "--------------------------------------------------------"

$ASyncVD = Get-ActiveSyncVirtualDirectory -server $computer
if($ASyncVD)
{
	Write-Host "Server Name: " $ASyncVD.Server
	Write-Host "Name: " $ASyncVD.name
	Write-Host "InternalURL: " $ASyncVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $ASyncVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $ASyncVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $ASyncVD.ExternalAuthenticationMethods
}

Write-Host "Client Access Server - ECP Virtual Directory"
Write-Host "-----------------------------------------------"

$ECPVD = Get-ECPVirtualDirectory -server $computer
if($ECPVD)
{
	Write-Host "Server Name: " $ECPVD.Server
	Write-Host "Name: " $ECPVD.name
	Write-Host "InternalURL: " $ECPVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $ECPVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $ECPVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $ECPVD.ExternalAuthenticationMethods
}

Write-Host "Client Access Server - OAB Virtual Directory"
Write-Host "----------------------------------------------"

$OABVD = Get-OABVirtualDirectory -server $computer
if($OABVD)
{
	Write-Host "Server Name: " $OABVD.Server
	Write-Host "Name: " $OABVD.name
	Write-Host "InternalURL: " $OABVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $OABVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $OABVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $OABVD.ExternalAuthenticationMethods
}
Write-Host "Client Access Server - OWA Virtual Directory"
Write-Host "----------------------------------------------"

$OWAVD = Get-OWAVirtualDirectory -server $computer
if($OWAVD)
{
	Write-Host "Server Name: " $OWAVD.Server
	Write-Host "Name: " $OWAVD.name
	Write-Host "InternalUrl: " $OWAVD.InternalUrl
	Write-Host "InternalAuthenticationMethods: " $OWAVD.InternalAuthenticationMethods
	Write-Host "ExternalUrl: " $OWAVD.ExternalUrl
	Write-Host "ExternalAuthenticationMethods: " $OWAVD.ExternalAuthenticationMethods
}
Write-Host "Client Access Server - WebServices Virtual Directory"
Write-Host "------------------------------------------------------"

$WEBSVD = Get-WebServicesVirtualDirectory -server $computer
if($WEBSVD)
{
	Write-Host "Server Name: " $WebSVD.server
	Write-Host "Name: " $WEBSVD.name
	Write-Host "InternalURL: " $WEBSVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $WebSVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $WebSVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $WebSVD.ExternalAuthenticationMethods
}

Write-Host "Client Access Server - Powershell Virtual Directory"
Write-Host "---------------------------------------------------------"

$PWSVD = Get-PowershellVirtualDirectory -server $computer
if($PWSVD)
{
	Write-Host "Server Name : " $PWSVD.server
	Write-Host "Name: " $PWSVD.name
	Write-Host "CertificateAuthentication: " $PWSVD.CertificateAuthentication
	Write-Host "RequireSSL: " $PWSVD.RequireSSL	
	Write-Host "MetabasePath: " $PWSVD.MetabasePath
	Write-Host "Path: " $PWSVD.Path		
	Write-Host "InternalURL: " $PWSVD.InternalURL		
	Write-Host "ExternalURL: " $PWSVD.ExternalURL
}	

Write-Host "RPCClientAccess Information"
Write-Host "-------------------------------"

$RPC = Get-RPCClientAccess -server $computer
if($RPC)
{

	Write-Host "Server Name: " $RPC.server
	Write-Host "Responsibility: " $RPC.Responsibility
	Write-Host "MaximumConnections: " $RPC.MaximumConnections
	Write-Host "EncryptionRequired: " $RPC.EncryptionRequired
	Write-Host "BlockedClientVersions: " $RPC.BlockedClientVersions
}

Write-Host "POP3 settings"
Write-Host "-----------------"
$pops = Get-PopSettings -server $computer
foreach ($pop in $pops)
{
	Write-Host "Name: " $pop.Name
	Write-Host "ProtocolName: " $pop.ProtocolName
	Write-Host "MaxCommandSize: " $pop.MaxCommandSize
	Write-Host "MessageRetrievalSortOrder: " $pop.MessageRetrievalSortOrder
	Write-Host "ShowHiddenFoldersEnabled: " $pop.ShowHiddenFoldersEnabled
	Write-Host "SSLBindings: " $pop.SSLBindings
	Write-Host "InternalConnectionSettings: " $pop.InternalConnectionSettings
	Write-Host "ExternalConnectionSettings: " $pop.ExternalConnectionSettings
	Write-Host "X509CertificateName: " $pop.X509CertificateName
	Write-Host "AuthenticatedConnectionTimeout: " $pop.AuthenticatedConnectionTimeout
	Write-Host "MaxConnections: " $pop.MaxConnections
	Write-Host "MaxConnectionFromSingleIP: " $pop.MaxConnectionFromSingleIP
	Write-Host "MaxConnectionsPerUser: " $pop.MaxConnectionsPerUser
	Write-Host "ProxyTargetPort: " $pop.ProxyTargetPort
	Write-Host "OwaServerUrl: " $pop.OwaServerUrl
	Write-Host "ProtocolLogEnabled: " $pop.ProtocolLogEnabled
	Write-Host "EnforceCertificateErrors: " $pop.EnforceCertificateErrors
}	

Write-Host "IMAP settings"
Write-Host "----------------"
$pops = Get-IMAPSettings -server $env:computername
foreach ($pop in $pops)
{
	Write-Host "Name: " $pop.Name
	Write-Host "ProtocolName: " $pop.ProtocolName
	Write-Host "MaxCommandSize: " $pop.MaxCommandSize
	Write-Host "MessageRetrievalSortOrder: " $pop.MessageRetrievalSortOrder
	Write-Host "ShowHiddenFoldersEnabled: " $pop.ShowHiddenFoldersEnabled
	Write-Host "SSLBindings: " $pop.SSLBindings
	Write-Host "InternalConnectionSettings: " $pop.InternalConnectionSettings
	Write-Host "ExternalConnectionSettings: " $pop.ExternalConnectionSettings
	Write-Host "X509CertificateName: " $pop.X509CertificateName
	Write-Host "AuthenticatedConnectionTimeout: " $pop.AuthenticatedConnectionTimeout
	Write-Host "MaxConnections: " $pop.MaxConnections
	Write-Host "MaxConnectionFromSingleIP: " $pop.MaxConnectionFromSingleIP
	Write-Host "MaxConnectionsPerUser: " $pop.MaxConnectionsPerUser
	Write-Host "ProxyTargetPort: " $pop.ProxyTargetPort
	Write-Host "OwaServerUrl: " $pop.OwaServerUrl
	Write-Host "ProtocolLogEnabled: " $pop.ProtocolLogEnabled
	Write-Host "EnforceCertificateErrors: " $pop.EnforceCertificateErrors
}	

Write-Host "Client Access Server - Exchange Certificates"
Write-Host "------------------------------------------------"
$certs = Get-ExchangeCertificate -Server $computer
if($certs)
{
	foreach($cert in $certs)
	{
		$certthumb = $cert.Thumbprint
		$CertDom = $cert.CertificateDomains
		$certserv = $cert.services
		$certAR = $cert.AccessRules
		$certPK = $cert.HasPrivatekey
		$certSSigned = $cert.IsSelfSigned
		$certIss = $cert.Issuer
		$certNA = $cert.NotAfter
		$certNB = $cert.NotBefore
		$certPKS = $cert.PublicKeySize
		$certRoot = $cert.RootCAType
		$certSN = $cert.SerialNumber
		$certstatus = $cert.status
		$certsubj = $cert.subject
		Write-Host "AccessRules: " $($certAR)
		Write-Host "Certificate Domains: " $($CertDom)
		Write-Host "HasPrivateKey: " $($certPK)	
		Write-Host "IsSelfSigned: " $($certSSigned)
		Write-Host "Issuer: " $($certIss)		
		Write-Host "NotAfter: " $($certNA)
		Write-Host "NotBefore: " $($certNB)
		Write-Host "PublicKeySize: " $($certPKS)
		Write-Host "RootCAType: " $($certRoot)
		Write-Host "SerialNumber: " $($certSN)
		Write-Host "Services: " $($certserv)
		Write-Host "Status: " $($certstatus)
		Write-Host "Subject: " $($certsubj)
		Write-Host "ThumbPrint: " $($certthumb)
	}	
}

Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010

	
	
# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU4fClN22kiR8+RqFxH7h5MILh
# V7OgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFApfZloTeA1pX+kj
# SQdx2reNUoajMA0GCSqGSIb3DQEBAQUABIICABr4FQoz1Ecjtrg7YT8wz2uDm70q
# Dtc9RlRf5DdmXA9IcjlhXYxB1DGClgNAh6GZGyGIxumnWnCDLTErGCLluaPo+38N
# KBayzz5aHltBfBPUq24WFfM+R9Xf3fTRFvZw52OS9jFcozIuuIz8K6oxTLLsIbeb
# WdOMLHSVFcKE9PYGMsALD5auEZHE7iI4D1jYV5l4AhwtiNOeuTdu2Pxcf3BeAohA
# 8/ZVglIuX5GvI6kqTzeVSYRGvJgLagn2Zxxv1Xemv5Esemd7gXZOqsGjSKuDw2F8
# yltPc2hA42R5ZztJeK7Rhnm6YvOxq6xmNjoBjtNEKYwiKYzrQYYZO/ZWGT346HAp
# MtHnsTC2wrEEfR92IkLEgYETTZkXdP7ceeUnmbO2V4GNaVN4sAS/GFjOpKmgrcdV
# jPBXxX8M08nay+6exL+jw03wHvJQHa+lCWhcxT8hdD986AGXeN2XmAhhBpFHxDAs
# Cb0WAum3THmex2etERyn+1LuJnaUz1nu6DAODvw3Jk+Ge0ZGUQWBH1MT5tRH5FzR
# gcE369+jW9Hpz4OOI7dUQxzwzHUJlrC+YYnvIMLw2G6LingjVtFdrhhyo+zkFQeV
# wn7Ff7Neo2nEcHUnzoywiHzlAhZqkMb1gMPgLIESTVHPBl1aIXkBKf1m61e0LlCM
# 491GD+tLYZEPpnINoYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM0MjNaMC8GCSqGSIb3DQEJBDEiBCCOfL3iNoEijNKjCanQx5M9X/xg
# kY3+2SyXIWNpGG8E5TANBgkqhkiG9w0BAQEFAASCAQB00bIj/HkYrEETzVESmwyl
# Xi++KI61gUpsUZ5Z7zGqf6YVWTIiScu3TF+oBd4IfiX76T2XAXc3bgZm+6lgVyTd
# wrBwegMUEuatySCDqZd80XmgO1RIlBVwZL4tHNwGtUuG8e4ML5cK286zOemJ9hLc
# MYkJ4oAQCzBUFjLN2hEgzHZfaNNXT9a8qIfGEescosYsM4yg/629SIzbpBKhxyaL
# gWp7s/4G8zrP4LUWFeEe+ElLFax9VDkJoV3uONqNN7EwuwF3CDwrjE4z7Y5Mi4RZ
# O/wHsJC5Yli+Cqg9v40JtxykPLzHAZJjb1vUwoAQ/BEK7BmOQuiWEmo+ci23nQjY
# SIG # End signature block
