export = agent;

declare const agent: Agent;

declare class Agent {
  start(options: AgentConfig): Agent;
}

interface AgentConfig {
  component_id: string;
  unique_component_id: string;
  agent_port?: number;
  agent_host?: string;

  // Log config
  log_level?: string; // options: error, warn, info, verbose, debug, silly
  log_file_count?: number;
  log_file_size?: number;

  // transport config
  socket_timeout?: number,
  flush_interval?: number,
  max_batch_size?: number,
  max_queue_size?: number,
  is_zipped_payload?: boolean,
  pay_load_message_type?: string, // JSON or PROTOBUF

  // exceptions config
  max_exception_trace_line_count?: number,
  ignore_exceptions?: string, // comma separted exception names
  include_exceptions?: string,
  max_exception_trace_limit?: number,
  max_exce_stack_trace_capture_limit?: number,
  exception_fqen_capture_limit?: number,
  capture_cause_of_the_exception?: boolean,
  max_exception_cause_depth?: number,
  error_status_code_range?: string,

  // inframetrics config to collect cpu,memory,gc,eventloop metrics
  enable_inframetrics?: boolean,
  inframetrics_interval?: number,
  enable_infra_exceptions?: boolean,
  enable_event_loop_metrics?: boolean,
  enable_gc_metrics?: boolean,
  enable_uptime_metrics?: boolean,
  // cpu
  enable_cpu_metrics?: boolean,
  enable_cpu_profiling?: boolean,
  cpu_profiling_duration?: number,
  // memory
  enable_memory_metrics?: boolean,

  /** BTM config Starts */
  enable_btm?: true,
  btm_interval?: number,

  // http url patterns
  max_url_segments?: number,
  chars_to_exclude?: string,
  excluded_patterns?: string,
  slow_url_threshold?: number,
  stalled_url_threshold?: number,
  http_headers?: boolean,
  http_cookies?: boolean,
  http_status_code?: boolean,

  /** Discovery config */
  discovery_details_interval?: number,
  discovery_reminder_interval?: number,
  portno_discovery_timeout?: number,
  cmd_to_get_container_id?: string,

  /** RUM config */
  enable_rum_btm_transaction_mapping?: boolean,
  enable_rum_injection?: boolean,
  rum_snippet?: string,
  rum_snippet_injection_place?: Array,

  /** Worker Thread config */
  enable_worker_thread_metrics?: boolean,
  enable_wtm_from_inside_thread?: boolean,

  /** Debug config */
  enable_console_log?: boolean,
}
